/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.classifier.naivebayes.ComplementaryNaiveBayesClassifier;
import org.apache.mahout.classifier.naivebayes.NaiveBayesModel;
import org.apache.mahout.classifier.naivebayes.StandardNaiveBayesClassifier;
import org.apache.mahout.classifier.naivebayes.training.TrainNaiveBayesJob;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.MathHelper;
import org.junit.Before;
import org.junit.Test;

public class NaiveBayesTest
extends MahoutTestCase {
    private Configuration conf;
    private File inputFile;
    private File outputDir;
    private File tempDir;
    static final Text LABEL_STOLEN = new Text("/stolen/");
    static final Text LABEL_NOT_STOLEN = new Text("/not_stolen/");
    static final Vector.Element COLOR_RED = MathHelper.elem(0, 1.0);
    static final Vector.Element COLOR_YELLOW = MathHelper.elem(1, 1.0);
    static final Vector.Element TYPE_SPORTS = MathHelper.elem(2, 1.0);
    static final Vector.Element TYPE_SUV = MathHelper.elem(3, 1.0);
    static final Vector.Element ORIGIN_DOMESTIC = MathHelper.elem(4, 1.0);
    static final Vector.Element ORIGIN_IMPORTED = MathHelper.elem(5, 1.0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.conf = this.getConfiguration();
        this.inputFile = this.getTestTempFile("trainingInstances.seq");
        this.outputDir = this.getTestTempDir("output");
        this.outputDir.delete();
        this.tempDir = this.getTestTempDir("tmp");
        SequenceFile.Writer writer = new SequenceFile.Writer(FileSystem.get((Configuration)this.conf), this.conf, new Path(this.inputFile.getAbsolutePath()), Text.class, VectorWritable.class);
        try {
            writer.append((Writable)LABEL_STOLEN, (Writable)NaiveBayesTest.trainingInstance(COLOR_RED, TYPE_SPORTS, ORIGIN_DOMESTIC));
            writer.append((Writable)LABEL_NOT_STOLEN, (Writable)NaiveBayesTest.trainingInstance(COLOR_RED, TYPE_SPORTS, ORIGIN_DOMESTIC));
            writer.append((Writable)LABEL_STOLEN, (Writable)NaiveBayesTest.trainingInstance(COLOR_RED, TYPE_SPORTS, ORIGIN_DOMESTIC));
            writer.append((Writable)LABEL_NOT_STOLEN, (Writable)NaiveBayesTest.trainingInstance(COLOR_YELLOW, TYPE_SPORTS, ORIGIN_DOMESTIC));
            writer.append((Writable)LABEL_STOLEN, (Writable)NaiveBayesTest.trainingInstance(COLOR_YELLOW, TYPE_SPORTS, ORIGIN_IMPORTED));
            writer.append((Writable)LABEL_NOT_STOLEN, (Writable)NaiveBayesTest.trainingInstance(COLOR_YELLOW, TYPE_SUV, ORIGIN_IMPORTED));
            writer.append((Writable)LABEL_STOLEN, (Writable)NaiveBayesTest.trainingInstance(COLOR_YELLOW, TYPE_SUV, ORIGIN_IMPORTED));
            writer.append((Writable)LABEL_NOT_STOLEN, (Writable)NaiveBayesTest.trainingInstance(COLOR_YELLOW, TYPE_SUV, ORIGIN_DOMESTIC));
            writer.append((Writable)LABEL_NOT_STOLEN, (Writable)NaiveBayesTest.trainingInstance(COLOR_RED, TYPE_SUV, ORIGIN_IMPORTED));
            writer.append((Writable)LABEL_STOLEN, (Writable)NaiveBayesTest.trainingInstance(COLOR_RED, TYPE_SPORTS, ORIGIN_IMPORTED));
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
    }

    @Test
    public void toyData() throws Exception {
        TrainNaiveBayesJob trainNaiveBayes = new TrainNaiveBayesJob();
        trainNaiveBayes.setConf(this.conf);
        trainNaiveBayes.run(new String[]{"--input", this.inputFile.getAbsolutePath(), "--output", this.outputDir.getAbsolutePath(), "-el", "--tempDir", this.tempDir.getAbsolutePath()});
        NaiveBayesModel naiveBayesModel = NaiveBayesModel.materialize((Path)new Path(this.outputDir.getAbsolutePath()), (Configuration)this.conf);
        StandardNaiveBayesClassifier classifier = new StandardNaiveBayesClassifier(naiveBayesModel);
        NaiveBayesTest.assertEquals((long)2L, (long)classifier.numCategories());
        Vector prediction = classifier.classifyFull(NaiveBayesTest.trainingInstance(COLOR_RED, TYPE_SUV, ORIGIN_DOMESTIC).get());
        NaiveBayesTest.assertTrue((prediction.get(0) < prediction.get(1) ? 1 : 0) != 0);
    }

    @Test
    public void toyDataComplementary() throws Exception {
        TrainNaiveBayesJob trainNaiveBayes = new TrainNaiveBayesJob();
        trainNaiveBayes.setConf(this.conf);
        trainNaiveBayes.run(new String[]{"--input", this.inputFile.getAbsolutePath(), "--output", this.outputDir.getAbsolutePath(), "-el", "--trainComplementary", "--tempDir", this.tempDir.getAbsolutePath()});
        NaiveBayesModel naiveBayesModel = NaiveBayesModel.materialize((Path)new Path(this.outputDir.getAbsolutePath()), (Configuration)this.conf);
        ComplementaryNaiveBayesClassifier classifier = new ComplementaryNaiveBayesClassifier(naiveBayesModel);
        NaiveBayesTest.assertEquals((long)2L, (long)classifier.numCategories());
        Vector prediction = classifier.classifyFull(NaiveBayesTest.trainingInstance(COLOR_RED, TYPE_SUV, ORIGIN_DOMESTIC).get());
        NaiveBayesTest.assertTrue((prediction.get(0) < prediction.get(1) ? 1 : 0) != 0);
    }

    static VectorWritable trainingInstance(Vector.Element ... elems) {
        DenseVector trainingInstance = new DenseVector(6);
        for (Vector.Element elem : elems) {
            trainingInstance.set(elem.index(), elem.get());
        }
        return new VectorWritable((Vector)trainingInstance);
    }
}

