/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sequencelearning.hmm;

import org.apache.mahout.classifier.sequencelearning.hmm.HMMTestBase;
import org.apache.mahout.classifier.sequencelearning.hmm.HmmAlgorithms;
import org.apache.mahout.classifier.sequencelearning.hmm.HmmModel;
import org.apache.mahout.math.Matrix;
import org.junit.Test;

public class HMMAlgorithmsTest
extends HMMTestBase {
    @Test
    public void testForwardAlgorithm() {
        double[][] alphaExpectedA = new double[][]{{0.02, 0.0392, 0.002438, 3.5456E-4, 0.0011554672, 7.158497E-4, 4.614927E-5}, {0.01, 0.0054, 0.001824, 6.9486E-4, 7.586904E-4, 2.514137E-4, 1.721505E-5}, {0.32, 0.0262, 0.002542, 3.8026E-4, 1.360234E-4, 3.002345E-5, 9.659608E-5}, {0.03, 0.0, 0.013428, 0.00951084, 0.0, 0.0, 2.428986E-5}};
        Matrix alpha = HmmAlgorithms.forwardAlgorithm((HmmModel)this.getModel(), (int[])this.getSequence(), (boolean)false);
        HMMAlgorithmsTest.assertNotNull((Object)alpha);
        HMMAlgorithmsTest.assertEquals((long)4L, (long)alpha.numCols());
        HMMAlgorithmsTest.assertEquals((long)7L, (long)alpha.numRows());
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                HMMAlgorithmsTest.assertEquals((double)alphaExpectedA[i][j], (double)alpha.get(j, i), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testLogScaledForwardAlgorithm() {
        double[][] alphaExpectedA = new double[][]{{0.02, 0.0392, 0.002438, 3.5456E-4, 0.0011554672, 7.158497E-4, 4.614927E-5}, {0.01, 0.0054, 0.001824, 6.9486E-4, 7.586904E-4, 2.514137E-4, 1.721505E-5}, {0.32, 0.0262, 0.002542, 3.8026E-4, 1.360234E-4, 3.002345E-5, 9.659608E-5}, {0.03, 0.0, 0.013428, 0.00951084, 0.0, 0.0, 2.428986E-5}};
        Matrix alpha = HmmAlgorithms.forwardAlgorithm((HmmModel)this.getModel(), (int[])this.getSequence(), (boolean)true);
        HMMAlgorithmsTest.assertNotNull((Object)alpha);
        HMMAlgorithmsTest.assertEquals((long)4L, (long)alpha.numCols());
        HMMAlgorithmsTest.assertEquals((long)7L, (long)alpha.numRows());
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                HMMAlgorithmsTest.assertEquals((double)Math.log(alphaExpectedA[i][j]), (double)alpha.get(j, i), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testBackwardAlgorithm() {
        double[][] betaExpectedA = new double[][]{{0.0015730559, 0.003543656, 0.00738264, 0.040692, 0.0848, 0.17, 1.0}, {0.0017191865, 0.002386795, 0.00923652, 0.052232, 0.1018, 0.17, 1.0}, {3.825772E-4, 0.001238558, 0.00259464, 0.012096, 0.0664, 0.66, 1.0}, {4.390858E-4, 0.007076994, 0.01063512, 0.013556, 0.0304, 0.17, 1.0}};
        Matrix beta = HmmAlgorithms.backwardAlgorithm((HmmModel)this.getModel(), (int[])this.getSequence(), (boolean)false);
        HMMAlgorithmsTest.assertNotNull((Object)beta);
        HMMAlgorithmsTest.assertEquals((long)4L, (long)beta.numCols());
        HMMAlgorithmsTest.assertEquals((long)7L, (long)beta.numRows());
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                HMMAlgorithmsTest.assertEquals((double)betaExpectedA[i][j], (double)beta.get(j, i), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testLogScaledBackwardAlgorithm() {
        double[][] betaExpectedA = new double[][]{{0.0015730559, 0.003543656, 0.00738264, 0.040692, 0.0848, 0.17, 1.0}, {0.0017191865, 0.002386795, 0.00923652, 0.052232, 0.1018, 0.17, 1.0}, {3.825772E-4, 0.001238558, 0.00259464, 0.012096, 0.0664, 0.66, 1.0}, {4.390858E-4, 0.007076994, 0.01063512, 0.013556, 0.0304, 0.17, 1.0}};
        Matrix beta = HmmAlgorithms.backwardAlgorithm((HmmModel)this.getModel(), (int[])this.getSequence(), (boolean)true);
        HMMAlgorithmsTest.assertNotNull((Object)beta);
        HMMAlgorithmsTest.assertEquals((long)4L, (long)beta.numCols());
        HMMAlgorithmsTest.assertEquals((long)7L, (long)beta.numRows());
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                HMMAlgorithmsTest.assertEquals((double)Math.log(betaExpectedA[i][j]), (double)beta.get(j, i), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testViterbiAlgorithm() {
        int[] expected = new int[]{2, 0, 3, 3, 0, 0, 2};
        int[] computed = HmmAlgorithms.viterbiAlgorithm((HmmModel)this.getModel(), (int[])this.getSequence(), (boolean)false);
        HMMAlgorithmsTest.assertNotNull((Object)computed);
        HMMAlgorithmsTest.assertEquals((long)computed.length, (long)this.getSequence().length);
        for (int i = 0; i < this.getSequence().length; ++i) {
            HMMAlgorithmsTest.assertEquals((long)expected[i], (long)computed[i]);
        }
    }

    @Test
    public void testLogScaledViterbiAlgorithm() {
        int[] expected = new int[]{2, 0, 3, 3, 0, 0, 2};
        int[] computed = HmmAlgorithms.viterbiAlgorithm((HmmModel)this.getModel(), (int[])this.getSequence(), (boolean)true);
        HMMAlgorithmsTest.assertNotNull((Object)computed);
        HMMAlgorithmsTest.assertEquals((long)computed.length, (long)this.getSequence().length);
        for (int i = 0; i < this.getSequence().length; ++i) {
            HMMAlgorithmsTest.assertEquals((long)expected[i], (long)computed[i]);
        }
    }
}

