/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.distance;

import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.distance.EuclideanDistanceMeasure;
import org.apache.mahout.common.distance.ManhattanDistanceMeasure;
import org.apache.mahout.common.distance.MinkowskiDistanceMeasure;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.junit.Test;

public final class TestMinkowskiMeasure
extends MahoutTestCase {
    @Test
    public void testMeasure() {
        int b;
        int a;
        MinkowskiDistanceMeasure minkowskiDistanceMeasure = new MinkowskiDistanceMeasure(1.5);
        ManhattanDistanceMeasure manhattanDistanceMeasure = new ManhattanDistanceMeasure();
        EuclideanDistanceMeasure euclideanDistanceMeasure = new EuclideanDistanceMeasure();
        Vector[] vectors = new Vector[]{new DenseVector(new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0}), new DenseVector(new double[]{1.0, 1.0, 1.0, 0.0, 0.0, 0.0}), new DenseVector(new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0})};
        double[][] minkowskiDistanceMatrix = new double[3][3];
        double[][] manhattanDistanceMatrix = new double[3][3];
        double[][] euclideanDistanceMatrix = new double[3][3];
        for (a = 0; a < 3; ++a) {
            for (b = 0; b < 3; ++b) {
                minkowskiDistanceMatrix[a][b] = minkowskiDistanceMeasure.distance(vectors[a], vectors[b]);
                manhattanDistanceMatrix[a][b] = manhattanDistanceMeasure.distance(vectors[a], vectors[b]);
                euclideanDistanceMatrix[a][b] = euclideanDistanceMeasure.distance(vectors[a], vectors[b]);
            }
        }
        for (a = 0; a < 3; ++a) {
            for (b = 0; b < 3; ++b) {
                TestMinkowskiMeasure.assertTrue((minkowskiDistanceMatrix[a][b] <= manhattanDistanceMatrix[a][b] ? 1 : 0) != 0);
                TestMinkowskiMeasure.assertTrue((minkowskiDistanceMatrix[a][b] >= euclideanDistanceMatrix[a][b] ? 1 : 0) != 0);
            }
        }
        TestMinkowskiMeasure.assertEquals((double)0.0, (double)minkowskiDistanceMatrix[0][0], (double)1.0E-6);
        TestMinkowskiMeasure.assertTrue((minkowskiDistanceMatrix[0][0] < minkowskiDistanceMatrix[0][1] ? 1 : 0) != 0);
        TestMinkowskiMeasure.assertTrue((minkowskiDistanceMatrix[0][1] < minkowskiDistanceMatrix[0][2] ? 1 : 0) != 0);
    }
}

