/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.similarity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.clustering.ClusteringTestUtils;
import org.apache.mahout.common.DummyOutputCollector;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.StringTuple;
import org.apache.mahout.common.distance.EuclideanDistanceMeasure;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.similarity.VectorDistanceInvertedMapper;
import org.apache.mahout.math.hadoop.similarity.VectorDistanceMapper;
import org.apache.mahout.math.hadoop.similarity.VectorDistanceSimilarityJob;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class TestVectorDistanceSimilarityJob
extends MahoutTestCase {
    private FileSystem fs;
    private static final double[][] REFERENCE = new double[][]{{1.0, 1.0}, {2.0, 1.0}, {1.0, 2.0}, {2.0, 2.0}, {3.0, 3.0}, {4.0, 4.0}, {5.0, 4.0}, {4.0, 5.0}, {5.0, 5.0}};
    private static final double[][] SEEDS = new double[][]{{1.0, 1.0}, {10.0, 10.0}};

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.fs = FileSystem.get((Configuration)this.getConfiguration());
    }

    @Test
    public void testVectorDistanceMapper() throws Exception {
        Mapper.Context context = (Mapper.Context)EasyMock.createMock(Mapper.Context.class);
        StringTuple tuple = new StringTuple();
        tuple.add("foo");
        tuple.add("123");
        context.write((Object)tuple, (Object)new DoubleWritable(Math.sqrt(2.0)));
        tuple = new StringTuple();
        tuple.add("foo2");
        tuple.add("123");
        context.write((Object)tuple, (Object)new DoubleWritable(1.0));
        EasyMock.replay((Object[])new Object[]{context});
        RandomAccessSparseVector vector = new RandomAccessSparseVector(2);
        vector.set(0, 2.0);
        vector.set(1, 2.0);
        VectorDistanceMapper mapper = new VectorDistanceMapper();
        TestVectorDistanceSimilarityJob.setField(mapper, "measure", new EuclideanDistanceMeasure());
        ArrayList seedVectors = Lists.newArrayList();
        RandomAccessSparseVector seed1 = new RandomAccessSparseVector(2);
        seed1.set(0, 1.0);
        seed1.set(1, 1.0);
        RandomAccessSparseVector seed2 = new RandomAccessSparseVector(2);
        seed2.set(0, 2.0);
        seed2.set(1, 1.0);
        seedVectors.add(new NamedVector((Vector)seed1, "foo"));
        seedVectors.add(new NamedVector((Vector)seed2, "foo2"));
        TestVectorDistanceSimilarityJob.setField(mapper, "seedVectors", seedVectors);
        mapper.map((WritableComparable)new IntWritable(123), new VectorWritable((Vector)vector), context);
        EasyMock.verify((Object[])new Object[]{context});
    }

    @Test
    public void testVectorDistanceInvertedMapper() throws Exception {
        Mapper.Context context = (Mapper.Context)EasyMock.createMock(Mapper.Context.class);
        DenseVector expectVec = new DenseVector(new double[]{Math.sqrt(2.0), 1.0});
        context.write((Object)new Text("other"), (Object)new VectorWritable((Vector)expectVec));
        EasyMock.replay((Object[])new Object[]{context});
        NamedVector vector = new NamedVector((Vector)new RandomAccessSparseVector(2), "other");
        vector.set(0, 2.0);
        vector.set(1, 2.0);
        VectorDistanceInvertedMapper mapper = new VectorDistanceInvertedMapper();
        TestVectorDistanceSimilarityJob.setField(mapper, "measure", new EuclideanDistanceMeasure());
        ArrayList seedVectors = Lists.newArrayList();
        RandomAccessSparseVector seed1 = new RandomAccessSparseVector(2);
        seed1.set(0, 1.0);
        seed1.set(1, 1.0);
        RandomAccessSparseVector seed2 = new RandomAccessSparseVector(2);
        seed2.set(0, 2.0);
        seed2.set(1, 1.0);
        seedVectors.add(new NamedVector((Vector)seed1, "foo"));
        seedVectors.add(new NamedVector((Vector)seed2, "foo2"));
        TestVectorDistanceSimilarityJob.setField(mapper, "seedVectors", seedVectors);
        mapper.map((WritableComparable)new IntWritable(123), new VectorWritable((Vector)vector), context);
        EasyMock.verify((Object[])new Object[]{context});
    }

    @Test
    public void testRun() throws Exception {
        Path input = this.getTestTempDirPath("input");
        Path output = this.getTestTempDirPath("output");
        Path seedsPath = this.getTestTempDirPath("seeds");
        List<VectorWritable> points = TestVectorDistanceSimilarityJob.getPointsWritable(REFERENCE);
        List<VectorWritable> seeds = TestVectorDistanceSimilarityJob.getPointsWritable(SEEDS);
        Configuration conf = this.getConfiguration();
        ClusteringTestUtils.writePointsToFile(points, true, new Path(input, "file1"), this.fs, conf);
        ClusteringTestUtils.writePointsToFile(seeds, true, new Path(seedsPath, "part-seeds"), this.fs, conf);
        String[] args = new String[]{TestVectorDistanceSimilarityJob.optKey("input"), input.toString(), TestVectorDistanceSimilarityJob.optKey("seeds"), seedsPath.toString(), TestVectorDistanceSimilarityJob.optKey("output"), output.toString(), TestVectorDistanceSimilarityJob.optKey("distanceMeasure"), EuclideanDistanceMeasure.class.getName()};
        ToolRunner.run((Configuration)this.getConfiguration(), (Tool)new VectorDistanceSimilarityJob(), (String[])args);
        int expectedOutputSize = SEEDS.length * REFERENCE.length;
        int outputSize = Iterables.size((Iterable)new SequenceFileIterable(new Path(output, "part-m-00000"), conf));
        TestVectorDistanceSimilarityJob.assertEquals((long)expectedOutputSize, (long)outputSize);
    }

    @Test
    public void testMaxDistance() throws Exception {
        Path input = this.getTestTempDirPath("input");
        Path output = this.getTestTempDirPath("output");
        Path seedsPath = this.getTestTempDirPath("seeds");
        List<VectorWritable> points = TestVectorDistanceSimilarityJob.getPointsWritable(REFERENCE);
        List<VectorWritable> seeds = TestVectorDistanceSimilarityJob.getPointsWritable(SEEDS);
        Configuration conf = this.getConfiguration();
        ClusteringTestUtils.writePointsToFile(points, true, new Path(input, "file1"), this.fs, conf);
        ClusteringTestUtils.writePointsToFile(seeds, true, new Path(seedsPath, "part-seeds"), this.fs, conf);
        double maxDistance = 10.0;
        String[] args = new String[]{TestVectorDistanceSimilarityJob.optKey("input"), input.toString(), TestVectorDistanceSimilarityJob.optKey("seeds"), seedsPath.toString(), TestVectorDistanceSimilarityJob.optKey("output"), output.toString(), TestVectorDistanceSimilarityJob.optKey("distanceMeasure"), EuclideanDistanceMeasure.class.getName(), TestVectorDistanceSimilarityJob.optKey("maxDistance"), String.valueOf(maxDistance)};
        ToolRunner.run((Configuration)this.getConfiguration(), (Tool)new VectorDistanceSimilarityJob(), (String[])args);
        int outputSize = 0;
        for (Pair record : new SequenceFileIterable(new Path(output, "part-m-00000"), conf)) {
            ++outputSize;
            TestVectorDistanceSimilarityJob.assertTrue((((DoubleWritable)record.getSecond()).get() <= maxDistance ? 1 : 0) != 0);
        }
        TestVectorDistanceSimilarityJob.assertEquals((long)14L, (long)outputSize);
    }

    @Test
    public void testRunInverted() throws Exception {
        Path input = this.getTestTempDirPath("input");
        Path output = this.getTestTempDirPath("output");
        Path seedsPath = this.getTestTempDirPath("seeds");
        List<VectorWritable> points = TestVectorDistanceSimilarityJob.getPointsWritable(REFERENCE);
        List<VectorWritable> seeds = TestVectorDistanceSimilarityJob.getPointsWritable(SEEDS);
        Configuration conf = this.getConfiguration();
        ClusteringTestUtils.writePointsToFile(points, true, new Path(input, "file1"), this.fs, conf);
        ClusteringTestUtils.writePointsToFile(seeds, true, new Path(seedsPath, "part-seeds"), this.fs, conf);
        String[] args = new String[]{TestVectorDistanceSimilarityJob.optKey("input"), input.toString(), TestVectorDistanceSimilarityJob.optKey("seeds"), seedsPath.toString(), TestVectorDistanceSimilarityJob.optKey("output"), output.toString(), TestVectorDistanceSimilarityJob.optKey("distanceMeasure"), EuclideanDistanceMeasure.class.getName(), TestVectorDistanceSimilarityJob.optKey("outType"), "v"};
        ToolRunner.run((Configuration)this.getConfiguration(), (Tool)new VectorDistanceSimilarityJob(), (String[])args);
        DummyOutputCollector<WritableComparable, Writable> collector = new DummyOutputCollector<WritableComparable, Writable>();
        for (Pair record : new SequenceFileIterable(new Path(output, "part-m-00000"), conf)) {
            collector.collect((WritableComparable)record.getFirst(), (Writable)record.getSecond());
        }
        TestVectorDistanceSimilarityJob.assertEquals((long)REFERENCE.length, (long)collector.getData().size());
        for (Map.Entry entry : collector.getData().entrySet()) {
            TestVectorDistanceSimilarityJob.assertEquals((long)SEEDS.length, (long)((VectorWritable)entry.getValue().iterator().next()).get().size());
        }
    }

    private static List<VectorWritable> getPointsWritable(double[][] raw) {
        ArrayList points = Lists.newArrayList();
        for (double[] fr : raw) {
            RandomAccessSparseVector vec = new RandomAccessSparseVector(fr.length);
            vec.assign(fr);
            points.add(new VectorWritable((Vector)vec));
        }
        return points;
    }
}

