/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.similarity.cooccurrence.measures;

import org.apache.mahout.common.ClassUtils;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.CityBlockSimilarity;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.CooccurrenceCountSimilarity;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.CosineSimilarity;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.EuclideanDistanceSimilarity;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.LoglikelihoodSimilarity;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.PearsonCorrelationSimilarity;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.TanimotoCoefficientSimilarity;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.VectorSimilarityMeasure;
import org.junit.Test;

public class VectorSimilarityMeasuresTest
extends MahoutTestCase {
    static double distributedSimilarity(double[] one, double[] two, Class<? extends VectorSimilarityMeasure> similarityMeasureClass) {
        double rand = VectorSimilarityMeasuresTest.computeSimilarity(one, two, similarityMeasureClass, (Vector)new RandomAccessSparseVector(one.length));
        double seq = VectorSimilarityMeasuresTest.computeSimilarity(one, two, similarityMeasureClass, (Vector)new SequentialAccessSparseVector(one.length));
        double dense = VectorSimilarityMeasuresTest.computeSimilarity(one, two, similarityMeasureClass, (Vector)new DenseVector(one.length));
        VectorSimilarityMeasuresTest.assertEquals((double)seq, (double)rand, (double)1.0E-10);
        VectorSimilarityMeasuresTest.assertEquals((double)seq, (double)dense, (double)1.0E-10);
        VectorSimilarityMeasuresTest.assertEquals((double)dense, (double)rand, (double)1.0E-10);
        return seq;
    }

    private static double computeSimilarity(double[] one, double[] two, Class<? extends VectorSimilarityMeasure> similarityMeasureClass, Vector like) {
        VectorSimilarityMeasure similarityMeasure = (VectorSimilarityMeasure)ClassUtils.instantiateAs(similarityMeasureClass, VectorSimilarityMeasure.class);
        Vector oneNormalized = similarityMeasure.normalize(VectorSimilarityMeasuresTest.asVector(one, like));
        Vector twoNormalized = similarityMeasure.normalize(VectorSimilarityMeasuresTest.asVector(two, like));
        double normOne = similarityMeasure.norm(oneNormalized);
        double normTwo = similarityMeasure.norm(twoNormalized);
        double dot = 0.0;
        for (int n = 0; n < one.length; ++n) {
            if (oneNormalized.get(n) == 0.0 || twoNormalized.get(n) == 0.0) continue;
            dot += similarityMeasure.aggregate(oneNormalized.get(n), twoNormalized.get(n));
        }
        return similarityMeasure.similarity(dot, normOne, normTwo, one.length);
    }

    static Vector asVector(double[] values, Vector like) {
        Vector vector = like.like();
        for (int dim = 0; dim < values.length; ++dim) {
            vector.set(dim, values[dim]);
        }
        return vector;
    }

    @Test
    public void testCooccurrenceCountSimilarity() {
        double similarity = VectorSimilarityMeasuresTest.distributedSimilarity(new double[]{0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 0.0}, new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, CooccurrenceCountSimilarity.class);
        VectorSimilarityMeasuresTest.assertEquals((double)5.0, (double)similarity, (double)0.0);
    }

    @Test
    public void testTanimotoCoefficientSimilarity() {
        double similarity = VectorSimilarityMeasuresTest.distributedSimilarity(new double[]{0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 0.0}, new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, TanimotoCoefficientSimilarity.class);
        VectorSimilarityMeasuresTest.assertEquals((double)0.454545455, (double)similarity, (double)1.0E-6);
    }

    @Test
    public void testCityblockSimilarity() {
        double similarity = VectorSimilarityMeasuresTest.distributedSimilarity(new double[]{0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 0.0}, new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, CityBlockSimilarity.class);
        VectorSimilarityMeasuresTest.assertEquals((double)0.142857143, (double)similarity, (double)1.0E-6);
    }

    @Test
    public void testLoglikelihoodSimilarity() {
        double similarity = VectorSimilarityMeasuresTest.distributedSimilarity(new double[]{0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 0.0}, new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, LoglikelihoodSimilarity.class);
        VectorSimilarityMeasuresTest.assertEquals((double)0.03320155369284261, (double)similarity, (double)1.0E-6);
    }

    @Test
    public void testCosineSimilarity() {
        double similarity = VectorSimilarityMeasuresTest.distributedSimilarity(new double[]{0.0, 2.0, 0.0, 0.0, 8.0, 3.0, 0.0, 6.0, 0.0, 1.0, 2.0, 2.0, 0.0}, new double[]{3.0, 0.0, 0.0, 0.0, 7.0, 0.0, 2.0, 2.0, 1.0, 3.0, 2.0, 1.0, 1.0}, CosineSimilarity.class);
        VectorSimilarityMeasuresTest.assertEquals((double)0.769846046, (double)similarity, (double)1.0E-6);
    }

    @Test
    public void testPearsonCorrelationSimilarity() {
        double similarity = VectorSimilarityMeasuresTest.distributedSimilarity(new double[]{0.0, 2.0, 0.0, 0.0, 8.0, 3.0, 0.0, 6.0, 0.0, 1.0, 1.0, 2.0, 1.0}, new double[]{3.0, 0.0, 0.0, 0.0, 7.0, 0.0, 2.0, 2.0, 1.0, 3.0, 2.0, 4.0, 3.0}, PearsonCorrelationSimilarity.class);
        VectorSimilarityMeasuresTest.assertEquals((double)0.5303300858899108, (double)similarity, (double)1.0E-6);
    }

    @Test
    public void testEuclideanDistanceSimilarity() {
        double similarity = VectorSimilarityMeasuresTest.distributedSimilarity(new double[]{0.0, 2.0, 0.0, 0.0, 8.0, 3.0, 0.0, 6.0, 0.0, 1.0, 1.0, 2.0, 1.0}, new double[]{3.0, 0.0, 0.0, 0.0, 7.0, 0.0, 2.0, 2.0, 1.0, 3.0, 2.0, 4.0, 4.0}, EuclideanDistanceSimilarity.class);
        VectorSimilarityMeasuresTest.assertEquals((double)0.11268865367232477, (double)similarity, (double)1.0E-6);
    }
}

