/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import java.util.Random;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.hadoop.stochasticsvd.qr.GivensThinSolver;
import org.junit.Test;

public class SSVDCommonTest
extends MahoutTestCase {
    private static final double SCALE = 1000.0;
    private static final double SVD_EPSILON = 1.0E-10;

    @Test
    public void testGivensQR() throws Exception {
        DenseMatrix m = new DenseMatrix(3, 3);
        m.assign(new DoubleFunction(){
            private final Random rnd = RandomUtils.getRandom();

            public double apply(double arg0) {
                return this.rnd.nextDouble() * 1000.0;
            }
        });
        m.setQuick(0, 0, 1.0);
        m.setQuick(0, 1, 2.0);
        m.setQuick(0, 2, 3.0);
        m.setQuick(1, 0, 4.0);
        m.setQuick(1, 1, 5.0);
        m.setQuick(1, 2, 6.0);
        m.setQuick(2, 0, 7.0);
        m.setQuick(2, 1, 8.0);
        m.setQuick(2, 2, 9.0);
        GivensThinSolver qrSolver = new GivensThinSolver(m.rowSize(), m.columnSize());
        qrSolver.solve((Matrix)m);
        DenseMatrix qtm = new DenseMatrix(qrSolver.getThinQtTilde());
        SSVDCommonTest.assertOrthonormality(qtm.transpose(), false, 1.0E-10);
        Matrix aClone = new DenseMatrix(qrSolver.getThinQtTilde()).transpose().times((Matrix)qrSolver.getRTilde());
        System.out.println("aclone : " + aClone);
    }

    public static void assertOrthonormality(Matrix mtx, boolean insufficientRank, double epsilon) {
        int n = mtx.columnSize();
        int rank = 0;
        for (int i = 0; i < n; ++i) {
            Vector ei = mtx.viewColumn(i);
            double norm = ei.norm(2.0);
            if (Math.abs(1.0 - norm) < epsilon) {
                ++rank;
            } else {
                SSVDCommonTest.assertTrue((Math.abs(norm) < epsilon ? 1 : 0) != 0);
            }
            for (int j = 0; j <= i; ++j) {
                Vector e_j = mtx.viewColumn(j);
                double dot = ei.dot(e_j);
                SSVDCommonTest.assertTrue((Math.abs((double)(i == j && rank > j ? 1 : 0) - dot) < epsilon ? 1 : 0) != 0);
            }
        }
        SSVDCommonTest.assertTrue((!insufficientRank && rank == n || insufficientRank && rank < n ? 1 : 0) != 0);
    }
}

