/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDCommonTest;
import org.apache.mahout.math.hadoop.stochasticsvd.qr.GramSchmidt;

public final class SSVDTestsHelper {
    private SSVDTestsHelper() {
    }

    static void generateDenseInput(Path outputPath, FileSystem dfs, Vector svalues, int m, int n) throws IOException {
        SSVDTestsHelper.generateDenseInput(outputPath, dfs, svalues, m, n, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void generateDenseInput(Path outputPath, FileSystem dfs, Vector svalues, int m, int n, int startRowKey) throws IOException {
        RandomWrapper rnd = RandomUtils.getRandom();
        int svCnt = svalues.size();
        Matrix v = SSVDTestsHelper.generateDenseOrthonormalRandom(n, svCnt, (Random)rnd);
        Matrix u = SSVDTestsHelper.generateDenseOrthonormalRandom(m, svCnt, (Random)rnd);
        Matrix mx = m > n ? v : u;
        for (int i = 0; i < svCnt; ++i) {
            mx.assignColumn(i, mx.viewColumn(i).times(svalues.getQuick(i)));
        }
        try (SequenceFile.Writer w = SequenceFile.createWriter((FileSystem)dfs, (Configuration)dfs.getConf(), (Path)outputPath, IntWritable.class, VectorWritable.class);){
            DenseVector outV = new DenseVector(n);
            VectorWritable vw = new VectorWritable((Vector)outV);
            IntWritable iw = new IntWritable();
            for (int i = 0; i < m; ++i) {
                iw.set(startRowKey + i);
                for (int j = 0; j < n; ++j) {
                    outV.setQuick(j, u.viewRow(i).dot(v.viewRow(j)));
                }
                w.append((Writable)iw, (Writable)vw);
            }
        }
    }

    static Matrix generateDenseOrthonormalRandom(int m, int n, Random rnd) {
        DenseMatrix result = new DenseMatrix(m, n);
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < m; ++i) {
                result.setQuick(i, j, rnd.nextDouble() - 0.5);
            }
        }
        GramSchmidt.orthonormalizeColumns((Matrix)result);
        SSVDCommonTest.assertOrthonormality((Matrix)result, false, 1.0E-10);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        MahoutTestCase ca = new MahoutTestCase();
        Configuration conf = ca.getConfiguration();
        LocalFileSystem dfs = FileSystem.getLocal((Configuration)conf);
        Path outputDir = new Path("/tmp/DRM");
        dfs.mkdirs(outputDir);
        outputDir = new Path("/tmp/DRM-sparse");
        RandomWrapper rnd = RandomUtils.getRandom();
        try (SequenceFile.Writer w = SequenceFile.createWriter((FileSystem)dfs, (Configuration)dfs.getConf(), (Path)new Path(outputDir, "sparse.seq"), IntWritable.class, VectorWritable.class);){
            IntWritable iw = new IntWritable();
            VectorWritable vw = new VectorWritable();
            int avgNZero = 40;
            int n = 4500000;
            for (int i = 1; i < n; ++i) {
                RandomAccessSparseVector vector = new RandomAccessSparseVector(n);
                double nz = Math.round((double)avgNZero * (rnd.nextGaussian() + 1.0));
                if (nz < 0.0) {
                    nz = 0.0;
                }
                int j = 1;
                while ((double)j < nz) {
                    vector.set(rnd.nextInt(n), rnd.nextGaussian() * 25.0 + 3.0);
                    ++j;
                }
                iw.set(i);
                vw.set((Vector)vector);
                w.append((Writable)iw, (Writable)vw);
            }
        }
    }
}

