/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.collocations.llr;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.StringTuple;
import org.apache.mahout.vectorizer.collocations.llr.CollocMapper;
import org.apache.mahout.vectorizer.collocations.llr.Gram;
import org.apache.mahout.vectorizer.collocations.llr.GramKey;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public final class CollocMapperTest
extends MahoutTestCase {
    private Mapper.Context context;
    private Counter counter;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.counter = (Counter)EasyMock.createMock(Counter.class);
        this.context = (Mapper.Context)EasyMock.createMock(Mapper.Context.class);
    }

    @Test
    public void testCollectNgrams() throws Exception {
        Text key = new Text();
        key.set("dummy-key");
        String[] input = new String[]{"the", "best", "of", "times", "the", "worst", "of", "times"};
        StringTuple inputTuple = new StringTuple();
        for (String i : input) {
            inputTuple.add(i);
        }
        String[][] values = new String[][]{{"h_the", "the best"}, {"t_best", "the best"}, {"h_of", "of times"}, {"t_times", "of times"}, {"h_best", "best of"}, {"t_of", "best of"}, {"h_the", "the worst"}, {"t_worst", "the worst"}, {"h_times", "times the"}, {"t_the", "times the"}, {"h_worst", "worst of"}, {"t_of", "worst of"}};
        Configuration conf = this.getConfiguration();
        conf.set("maxShingleSize", "2");
        EasyMock.expect((Object)this.context.getConfiguration()).andReturn((Object)conf);
        for (String[] v : values) {
            Gram.Type p = v[0].startsWith("h") ? Gram.Type.HEAD : Gram.Type.TAIL;
            int frequency = 1;
            if ("of times".equals(v[1])) {
                frequency = 2;
            }
            Gram subgram = new Gram(v[0].substring(2), frequency, p);
            Gram ngram = new Gram(v[1], frequency, Gram.Type.NGRAM);
            GramKey subgramKey = new GramKey(subgram, new byte[0]);
            GramKey subgramNgramKey = new GramKey(subgram, ngram.getBytes());
            this.context.write((Object)subgramKey, (Object)subgram);
            this.context.write((Object)subgramNgramKey, (Object)ngram);
        }
        EasyMock.expect((Object)this.context.getCounter((Enum)CollocMapper.Count.NGRAM_TOTAL)).andReturn((Object)this.counter);
        this.counter.increment(7L);
        EasyMock.replay((Object[])new Object[]{this.context, this.counter});
        CollocMapper c = new CollocMapper();
        c.setup(this.context);
        c.map(key, inputTuple, this.context);
        EasyMock.verify((Object[])new Object[]{this.context});
    }

    @Test
    public void testCollectNgramsWithUnigrams() throws Exception {
        Text key = new Text();
        key.set("dummy-key");
        String[] input = new String[]{"the", "best", "of", "times", "the", "worst", "of", "times"};
        StringTuple inputTuple = new StringTuple();
        for (String i : input) {
            inputTuple.add(i);
        }
        String[][] values = new String[][]{{"h_the", "the best"}, {"t_best", "the best"}, {"h_of", "of times"}, {"t_times", "of times"}, {"h_best", "best of"}, {"t_of", "best of"}, {"h_the", "the worst"}, {"t_worst", "the worst"}, {"h_times", "times the"}, {"t_the", "times the"}, {"h_worst", "worst of"}, {"t_of", "worst of"}, {"u_worst", "worst"}, {"u_of", "of"}, {"u_the", "the"}, {"u_best", "best"}, {"u_times", "times"}};
        Configuration conf = this.getConfiguration();
        conf.set("maxShingleSize", "2");
        conf.setBoolean("emit-unigrams", true);
        EasyMock.expect((Object)this.context.getConfiguration()).andReturn((Object)conf);
        for (String[] v : values) {
            Gram.Type p = v[0].startsWith("h") ? Gram.Type.HEAD : Gram.Type.TAIL;
            p = v[0].startsWith("u") ? Gram.Type.UNIGRAM : p;
            int frequency = 1;
            if ("of times".equals(v[1]) || "of".equals(v[1]) || "times".equals(v[1]) || "the".equals(v[1])) {
                frequency = 2;
            }
            if (p == Gram.Type.UNIGRAM) {
                Gram unigram = new Gram(v[1], frequency, Gram.Type.UNIGRAM);
                GramKey unigramKey = new GramKey(unigram, new byte[0]);
                this.context.write((Object)unigramKey, (Object)unigram);
                continue;
            }
            Gram subgram = new Gram(v[0].substring(2), frequency, p);
            Gram ngram = new Gram(v[1], frequency, Gram.Type.NGRAM);
            GramKey subgramKey = new GramKey(subgram, new byte[0]);
            GramKey subgramNgramKey = new GramKey(subgram, ngram.getBytes());
            this.context.write((Object)subgramKey, (Object)subgram);
            this.context.write((Object)subgramNgramKey, (Object)ngram);
        }
        EasyMock.expect((Object)this.context.getCounter((Enum)CollocMapper.Count.NGRAM_TOTAL)).andReturn((Object)this.counter);
        this.counter.increment(7L);
        EasyMock.replay((Object[])new Object[]{this.context, this.counter});
        CollocMapper c = new CollocMapper();
        c.setup(this.context);
        c.map(key, inputTuple, this.context);
        EasyMock.verify((Object[])new Object[]{this.context});
    }
}

