/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.encoders;

import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.vectorizer.encoders.ContinuousValueEncoder;
import org.junit.Test;

public final class ContinuousValueEncoderTest
extends MahoutTestCase {
    @Test
    public void testAddToVector() {
        ContinuousValueEncoder enc = new ContinuousValueEncoder("foo");
        DenseVector v1 = new DenseVector(20);
        enc.addToVector("-123", (Vector)v1);
        ContinuousValueEncoderTest.assertEquals((double)-123.0, (double)v1.minValue(), (double)0.0);
        ContinuousValueEncoderTest.assertEquals((double)0.0, (double)v1.maxValue(), (double)0.0);
        ContinuousValueEncoderTest.assertEquals((double)123.0, (double)v1.norm(1.0), (double)0.0);
        v1 = new DenseVector(20);
        enc.addToVector("123", (Vector)v1);
        ContinuousValueEncoderTest.assertEquals((double)123.0, (double)v1.maxValue(), (double)0.0);
        ContinuousValueEncoderTest.assertEquals((double)0.0, (double)v1.minValue(), (double)0.0);
        ContinuousValueEncoderTest.assertEquals((double)123.0, (double)v1.norm(1.0), (double)0.0);
        DenseVector v2 = new DenseVector(20);
        enc.setProbes(2);
        enc.addToVector("123", (Vector)v2);
        ContinuousValueEncoderTest.assertEquals((double)123.0, (double)v2.maxValue(), (double)0.0);
        ContinuousValueEncoderTest.assertEquals((double)246.0, (double)v2.norm(1.0), (double)0.0);
        v1 = v2.minus((Vector)v1);
        ContinuousValueEncoderTest.assertEquals((double)123.0, (double)v1.maxValue(), (double)0.0);
        ContinuousValueEncoderTest.assertEquals((double)123.0, (double)v1.norm(1.0), (double)0.0);
        DenseVector v3 = new DenseVector(20);
        enc.setProbes(2);
        enc.addToVector("100", (Vector)v3);
        v1 = v2.minus((Vector)v3);
        ContinuousValueEncoderTest.assertEquals((double)23.0, (double)v1.maxValue(), (double)0.0);
        ContinuousValueEncoderTest.assertEquals((double)46.0, (double)v1.norm(1.0), (double)0.0);
        enc.addToVector("7", (Vector)v1);
        ContinuousValueEncoderTest.assertEquals((double)30.0, (double)v1.maxValue(), (double)0.0);
        ContinuousValueEncoderTest.assertEquals((double)60.0, (double)v1.norm(1.0), (double)0.0);
        ContinuousValueEncoderTest.assertEquals((double)30.0, (double)v1.get(10), (double)0.0);
        ContinuousValueEncoderTest.assertEquals((double)30.0, (double)v1.get(18), (double)0.0);
        v2 = new DenseVector(20);
        v3 = new DenseVector(20);
        enc.setProbes(6);
        enc.addToVector("145", (Vector)v2);
        enc.addToVector((byte[])null, 145.0, (Vector)v3);
        ContinuousValueEncoderTest.assertEquals((double)0.0, (double)v2.minus((Vector)v3).norm(1.0), (double)0.0);
        try {
            enc.addToVector("foobar", (Vector)v1);
            ContinuousValueEncoderTest.fail((String)"Should have noticed bad numeric format");
        }
        catch (NumberFormatException e) {
            ContinuousValueEncoderTest.assertEquals((Object)"For input string: \"foobar\"", (Object)e.getMessage());
        }
    }

    @Test
    public void testAsString() {
        ContinuousValueEncoder enc = new ContinuousValueEncoder("foo");
        ContinuousValueEncoderTest.assertEquals((Object)"foo:123", (Object)enc.asString("123"));
    }
}

