/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.markdown;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.HtmlCommentBlock;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.ext.definition.DefinitionExtension;
import com.vladsch.flexmark.ext.escaped.character.EscapedCharacterExtension;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.ext.typographic.TypographicExtension;
import com.vladsch.flexmark.ext.wikilink.WikiLinkExtension;
import com.vladsch.flexmark.ext.yaml.front.matter.YamlFrontMatterExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.TextCollectingVisitor;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.maven.doxia.markup.HtmlMarkup;
import org.apache.maven.doxia.markup.TextMarkup;
import org.apache.maven.doxia.module.markdown.FlexmarkDoxiaLinkResolver;
import org.apache.maven.doxia.module.markdown.YamlFrontMatterVisitor;
import org.apache.maven.doxia.module.xhtml5.Xhtml5Parser;
import org.apache.maven.doxia.parser.AbstractTextParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;

@Singleton
@Named(value="markdown")
public class MarkdownParser
extends AbstractTextParser
implements TextMarkup {
    private static final Pattern METADATA_SECTION_PATTERN = Pattern.compile("\\A^(?:title|author|date|address|affiliation|copyright|email|keywords|language|phone|subtitle)[ \\t]*:[\\S\\s]+?^[ \\t]*$", 10);
    private static final Pattern METADATA_ENTRY_PATTERN = Pattern.compile("^([^:\\r\\n]+?)[ \\t]*:([\\S\\s]+?)(?=(?:^(?:[^:\\r\\n]+?)[ \\t]*:)|^[ \\t]*$)", 8);
    @Inject
    private MarkdownHtmlParser parser;
    private static final Parser FLEXMARK_PARSER;
    private static final Parser FLEXMARK_METADATA_PARSER;
    private static final HtmlRenderer FLEXMARK_HTML_RENDERER;

    public void parse(Reader source, Sink sink, String reference) throws ParseException {
        try {
            String html = this.toHtml(source);
            this.parser.parse(html, this.getWrappedSink(sink), "Intermediate HTML from " + reference);
        }
        catch (IOException e) {
            throw new ParseException("Failed reading Markdown source document", (Exception)e);
        }
    }

    private boolean processMetadataForHtml(StringBuilder html, StringBuilder source) {
        int endOffset;
        LinkedHashMap<String, List<String>> metadata;
        if (source.toString().startsWith("---")) {
            Document documentRoot = FLEXMARK_METADATA_PARSER.parse(source.toString());
            YamlFrontMatterVisitor visitor = new YamlFrontMatterVisitor();
            visitor.visit((Node)documentRoot);
            metadata = visitor.getData();
            endOffset = visitor.getEndOffset();
        } else {
            metadata = new LinkedHashMap();
            Matcher metadataMatcher = METADATA_SECTION_PATTERN.matcher(source);
            if (metadataMatcher.find()) {
                String entry = metadataMatcher.group(0) + EOL;
                Matcher entryMatcher = METADATA_ENTRY_PATTERN.matcher(entry);
                while (entryMatcher.find()) {
                    String key = entryMatcher.group(1);
                    String value = MarkdownParser.normalizeMultilineValue(entryMatcher.group(2));
                    metadata.put(key, Collections.singletonList(value));
                }
                endOffset = metadataMatcher.end(0);
            } else {
                endOffset = 0;
            }
        }
        if (endOffset > 0) {
            source.delete(0, endOffset);
        }
        return this.writeHtmlMetadata(html, metadata);
    }

    static String normalizeMultilineValue(String value) {
        return value.trim().replaceAll("[ \\t]*[\\r\\n]+[ \\t]*", " ");
    }

    private boolean writeHtmlMetadata(StringBuilder html, Map<String, List<String>> data) {
        boolean containsTitle = false;
        for (Map.Entry<String, List<String>> entry : data.entrySet()) {
            if (!this.writeHtmlMetadata(html, entry.getKey(), entry.getValue())) continue;
            containsTitle = true;
        }
        return containsTitle;
    }

    private boolean writeHtmlMetadata(StringBuilder html, String key, List<String> values) {
        if ("title".equalsIgnoreCase(key)) {
            html.append("<title>");
            html.append(HtmlTools.escapeHTML((String)values.stream().collect(Collectors.joining(", ")), (boolean)false));
            html.append("</title>");
            return true;
        }
        if (key.equalsIgnoreCase("author") && values.size() > 1) {
            for (String value : values) {
                this.writeHtmlMetadata(html, key, Collections.singletonList(value));
            }
        } else {
            String separator = key.equalsIgnoreCase("keywords") ? "," : EOL;
            html.append("<meta name='");
            html.append(HtmlTools.escapeHTML((String)key));
            html.append("' content='");
            html.append(HtmlTools.escapeHTML((String)values.stream().collect(Collectors.joining(separator))));
            html.append("' />");
        }
        return false;
    }

    String toHtml(Reader source) throws IOException {
        StringBuilder markdownText = new StringBuilder(IOUtils.toString((Reader)source));
        StringBuilder html = new StringBuilder(1000);
        html.append("<html>");
        html.append("<head>");
        boolean haveTitle = this.processMetadataForHtml(html, markdownText);
        Document documentRoot = FLEXMARK_PARSER.parse(markdownText.toString());
        if (!haveTitle && documentRoot.hasChildren()) {
            Node firstNode;
            for (firstNode = documentRoot.getFirstChild(); firstNode != null && firstNode instanceof HtmlCommentBlock; firstNode = firstNode.getNext()) {
            }
            if (firstNode != null && firstNode instanceof Heading) {
                html.append("<title>");
                TextCollectingVisitor collectingVisitor = new TextCollectingVisitor();
                String headingText = collectingVisitor.collectAndGetText(firstNode);
                html.append(HtmlTools.escapeHTML((String)headingText, (boolean)false));
                html.append("</title>");
            }
        }
        html.append("</head>");
        html.append("<body>");
        FLEXMARK_HTML_RENDERER.render((Node)documentRoot, (Appendable)html);
        html.append("</body>");
        html.append("</html>");
        return html.toString();
    }

    static {
        MutableDataSet flexmarkOptions = new MutableDataSet();
        flexmarkOptions.set(Parser.EXTENSIONS, Arrays.asList(EscapedCharacterExtension.create(), AbbreviationExtension.create(), AutolinkExtension.create(), DefinitionExtension.create(), TypographicExtension.create(), TablesExtension.create(), WikiLinkExtension.create(), FootnoteExtension.create(), StrikethroughExtension.create()));
        flexmarkOptions.set(TypographicExtension.SINGLE_QUOTE_UNMATCHED, (Object)"&apos;");
        flexmarkOptions.set(HtmlRenderer.HTML_BLOCK_OPEN_TAG_EOL, (Object)false);
        flexmarkOptions.set(HtmlRenderer.HTML_BLOCK_CLOSE_TAG_EOL, (Object)false);
        flexmarkOptions.set(HtmlRenderer.MAX_TRAILING_BLANK_LINES, (Object)-1);
        FLEXMARK_PARSER = Parser.builder((DataHolder)flexmarkOptions).build();
        MutableDataSet flexmarkMetadataOptions = new MutableDataSet();
        flexmarkMetadataOptions.set(Parser.EXTENSIONS, Arrays.asList(YamlFrontMatterExtension.create()));
        FLEXMARK_METADATA_PARSER = Parser.builder((DataHolder)flexmarkMetadataOptions).build();
        FLEXMARK_HTML_RENDERER = HtmlRenderer.builder((DataHolder)flexmarkOptions).linkResolverFactory((LinkResolverFactory)new FlexmarkDoxiaLinkResolver.Factory()).build();
    }

    @Named
    public static class MarkdownHtmlParser
    extends Xhtml5Parser {
        protected void init() {
            super.init();
        }

        protected boolean baseEndTag(XmlPullParser parser, Sink sink) {
            boolean visited = super.baseEndTag(parser, sink);
            if (!visited && parser.getName().equals(HtmlMarkup.DIV.toString())) {
                this.handleUnknown(parser, sink, 3);
                visited = true;
            }
            return visited;
        }

        protected boolean baseStartTag(XmlPullParser parser, Sink sink) {
            boolean visited = super.baseStartTag(parser, sink);
            if (!visited && parser.getName().equals(HtmlMarkup.DIV.toString())) {
                this.handleUnknown(parser, sink, 2);
                visited = true;
            }
            return visited;
        }
    }
}

