/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.site.decoration.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.doxia.site.decoration.Banner;
import org.apache.maven.doxia.site.decoration.Body;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.LinkItem;
import org.apache.maven.doxia.site.decoration.Logo;
import org.apache.maven.doxia.site.decoration.Menu;
import org.apache.maven.doxia.site.decoration.MenuItem;
import org.apache.maven.doxia.site.decoration.PublishDate;
import org.apache.maven.doxia.site.decoration.Skin;
import org.apache.maven.doxia.site.decoration.Version;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DecorationXpp3Reader {
    private boolean addDefaultEntities = true;
    public final ContentTransformer contentTransformer;

    public DecorationXpp3Reader() {
        this(new ContentTransformer(){

            @Override
            public String transform(String source, String fieldName) {
                return source;
            }
        });
    }

    public DecorationXpp3Reader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public DecorationModel read(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        DecorationModel decorationModel = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"project".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'project' but found '" + parser.getName() + "'", parser, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'project'", parser, null);
                }
                decorationModel = this.parseDecorationModel(parser, strict);
                decorationModel.setModelEncoding(parser.getInputEncoding());
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return decorationModel;
        }
        throw new XmlPullParserException("Expected root element 'project' but found no element at all: invalid XML document", parser, null);
    }

    public DecorationModel read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read((XmlPullParser)parser, strict);
    }

    public DecorationModel read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public DecorationModel read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)in), strict);
    }

    public DecorationModel read(InputStream in) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)in));
    }

    private Banner parseBanner(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Banner banner = new Banner();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "name", null, parsed)) {
                banner.setName(this.interpolatedTrimmed(parser.nextText(), "name"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "src", null, parsed)) {
                banner.setSrc(this.interpolatedTrimmed(parser.nextText(), "src"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "alt", null, parsed)) {
                banner.setAlt(this.interpolatedTrimmed(parser.nextText(), "alt"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "href", null, parsed)) {
                banner.setHref(this.interpolatedTrimmed(parser.nextText(), "href"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "border", null, parsed)) {
                banner.setBorder(this.interpolatedTrimmed(parser.nextText(), "border"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "width", null, parsed)) {
                banner.setWidth(this.interpolatedTrimmed(parser.nextText(), "width"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "height", null, parsed)) {
                banner.setHeight(this.interpolatedTrimmed(parser.nextText(), "height"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "title", null, parsed)) {
                banner.setTitle(this.interpolatedTrimmed(parser.nextText(), "title"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return banner;
    }

    private Body parseBody(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Body body = new Body();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "head", null, parsed)) {
                body.setHead(this.interpolatedTrimmed(parser.nextText(), "head"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "links", null, parsed)) {
                ArrayList<LinkItem> links = new ArrayList<LinkItem>();
                while (parser.nextTag() == 2) {
                    if ("item".equals(parser.getName())) {
                        links.add(this.parseLinkItem(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                body.setLinks(links);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "breadcrumbs", null, parsed)) {
                ArrayList<LinkItem> breadcrumbs = new ArrayList<LinkItem>();
                while (parser.nextTag() == 2) {
                    if ("item".equals(parser.getName())) {
                        breadcrumbs.add(this.parseLinkItem(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                body.setBreadcrumbs(breadcrumbs);
                continue;
            }
            if ("menu".equals(parser.getName())) {
                List<Menu> menus = body.getMenus();
                if (menus == null) {
                    menus = new ArrayList<Menu>();
                }
                menus.add(this.parseMenu(parser, strict));
                body.setMenus(menus);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "footer", null, parsed)) {
                body.setFooter(this.interpolatedTrimmed(parser.nextText(), "footer"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return body;
    }

    private DecorationModel parseDecorationModel(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DecorationModel decorationModel = new DecorationModel();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            if ("name".equals(name)) {
                decorationModel.setName(this.interpolatedTrimmed(value, "name"));
                continue;
            }
            if ("combine.self".equals(name)) {
                decorationModel.setCombineSelf(this.interpolatedTrimmed(value, "combine.self"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "bannerLeft", null, parsed)) {
                decorationModel.setBannerLeft(this.parseBanner(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "bannerRight", null, parsed)) {
                decorationModel.setBannerRight(this.parseBanner(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "publishDate", null, parsed)) {
                decorationModel.setPublishDate(this.parsePublishDate(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                decorationModel.setVersion(this.parseVersion(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "edit", null, parsed)) {
                decorationModel.setEdit(this.interpolatedTrimmed(parser.nextText(), "edit"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "poweredBy", null, parsed)) {
                ArrayList<Logo> poweredBy = new ArrayList<Logo>();
                while (parser.nextTag() == 2) {
                    if ("logo".equals(parser.getName())) {
                        poweredBy.add(this.parseLogo(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                decorationModel.setPoweredBy(poweredBy);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "skin", null, parsed)) {
                decorationModel.setSkin(this.parseSkin(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "body", null, parsed)) {
                decorationModel.setBody(this.parseBody(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "custom", null, parsed)) {
                decorationModel.setCustom(Xpp3DomBuilder.build((XmlPullParser)parser, (boolean)true));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return decorationModel;
    }

    private LinkItem parseLinkItem(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        LinkItem linkItem = new LinkItem();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("name".equals(name)) {
                linkItem.setName(this.interpolatedTrimmed(value, "name"));
                continue;
            }
            if ("href".equals(name)) {
                linkItem.setHref(this.interpolatedTrimmed(value, "href"));
                continue;
            }
            if ("img".equals(name)) {
                linkItem.setImg(this.interpolatedTrimmed(value, "img"));
                continue;
            }
            if ("position".equals(name)) {
                linkItem.setPosition(this.interpolatedTrimmed(value, "position"));
                continue;
            }
            if ("alt".equals(name)) {
                linkItem.setAlt(this.interpolatedTrimmed(value, "alt"));
                continue;
            }
            if ("border".equals(name)) {
                linkItem.setBorder(this.interpolatedTrimmed(value, "border"));
                continue;
            }
            if ("width".equals(name)) {
                linkItem.setWidth(this.interpolatedTrimmed(value, "width"));
                continue;
            }
            if ("height".equals(name)) {
                linkItem.setHeight(this.interpolatedTrimmed(value, "height"));
                continue;
            }
            if ("target".equals(name)) {
                linkItem.setTarget(this.interpolatedTrimmed(value, "target"));
                continue;
            }
            if ("title".equals(name)) {
                linkItem.setTitle(this.interpolatedTrimmed(value, "title"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return linkItem;
    }

    private Logo parseLogo(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Logo logo = new Logo();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("name".equals(name)) {
                logo.setName(this.interpolatedTrimmed(value, "name"));
                continue;
            }
            if ("href".equals(name)) {
                logo.setHref(this.interpolatedTrimmed(value, "href"));
                continue;
            }
            if ("img".equals(name)) {
                logo.setImg(this.interpolatedTrimmed(value, "img"));
                continue;
            }
            if ("position".equals(name)) {
                logo.setPosition(this.interpolatedTrimmed(value, "position"));
                continue;
            }
            if ("alt".equals(name)) {
                logo.setAlt(this.interpolatedTrimmed(value, "alt"));
                continue;
            }
            if ("border".equals(name)) {
                logo.setBorder(this.interpolatedTrimmed(value, "border"));
                continue;
            }
            if ("width".equals(name)) {
                logo.setWidth(this.interpolatedTrimmed(value, "width"));
                continue;
            }
            if ("height".equals(name)) {
                logo.setHeight(this.interpolatedTrimmed(value, "height"));
                continue;
            }
            if ("target".equals(name)) {
                logo.setTarget(this.interpolatedTrimmed(value, "target"));
                continue;
            }
            if ("title".equals(name)) {
                logo.setTitle(this.interpolatedTrimmed(value, "title"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return logo;
    }

    private Menu parseMenu(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Menu menu = new Menu();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("name".equals(name)) {
                menu.setName(this.interpolatedTrimmed(value, "name"));
                continue;
            }
            if ("inherit".equals(name)) {
                menu.setInherit(this.interpolatedTrimmed(value, "inherit"));
                continue;
            }
            if ("inheritAsRef".equals(name)) {
                menu.setInheritAsRef(this.getBooleanValue(this.interpolatedTrimmed(value, "inheritAsRef"), "inheritAsRef", parser, "false"));
                continue;
            }
            if ("ref".equals(name)) {
                menu.setRef(this.interpolatedTrimmed(value, "ref"));
                continue;
            }
            if ("img".equals(name)) {
                menu.setImg(this.interpolatedTrimmed(value, "img"));
                continue;
            }
            if ("alt".equals(name)) {
                menu.setAlt(this.interpolatedTrimmed(value, "alt"));
                continue;
            }
            if ("position".equals(name)) {
                menu.setPosition(this.interpolatedTrimmed(value, "position"));
                continue;
            }
            if ("border".equals(name)) {
                menu.setBorder(this.interpolatedTrimmed(value, "border"));
                continue;
            }
            if ("width".equals(name)) {
                menu.setWidth(this.interpolatedTrimmed(value, "width"));
                continue;
            }
            if ("height".equals(name)) {
                menu.setHeight(this.interpolatedTrimmed(value, "height"));
                continue;
            }
            if ("title".equals(name)) {
                menu.setTitle(this.interpolatedTrimmed(value, "title"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if ("item".equals(parser.getName())) {
                List<MenuItem> items = menu.getItems();
                if (items == null) {
                    items = new ArrayList<MenuItem>();
                }
                items.add(this.parseMenuItem(parser, strict));
                menu.setItems(items);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return menu;
    }

    private MenuItem parseMenuItem(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        MenuItem menuItem = new MenuItem();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("collapse".equals(name)) {
                menuItem.setCollapse(this.getBooleanValue(this.interpolatedTrimmed(value, "collapse"), "collapse", parser, "false"));
                continue;
            }
            if ("ref".equals(name)) {
                menuItem.setRef(this.interpolatedTrimmed(value, "ref"));
                continue;
            }
            if ("name".equals(name)) {
                menuItem.setName(this.interpolatedTrimmed(value, "name"));
                continue;
            }
            if ("href".equals(name)) {
                menuItem.setHref(this.interpolatedTrimmed(value, "href"));
                continue;
            }
            if ("img".equals(name)) {
                menuItem.setImg(this.interpolatedTrimmed(value, "img"));
                continue;
            }
            if ("position".equals(name)) {
                menuItem.setPosition(this.interpolatedTrimmed(value, "position"));
                continue;
            }
            if ("alt".equals(name)) {
                menuItem.setAlt(this.interpolatedTrimmed(value, "alt"));
                continue;
            }
            if ("border".equals(name)) {
                menuItem.setBorder(this.interpolatedTrimmed(value, "border"));
                continue;
            }
            if ("width".equals(name)) {
                menuItem.setWidth(this.interpolatedTrimmed(value, "width"));
                continue;
            }
            if ("height".equals(name)) {
                menuItem.setHeight(this.interpolatedTrimmed(value, "height"));
                continue;
            }
            if ("target".equals(name)) {
                menuItem.setTarget(this.interpolatedTrimmed(value, "target"));
                continue;
            }
            if ("title".equals(name)) {
                menuItem.setTitle(this.interpolatedTrimmed(value, "title"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "description", null, parsed)) {
                menuItem.setDescription(this.interpolatedTrimmed(parser.nextText(), "description"));
                continue;
            }
            if ("item".equals(parser.getName())) {
                List<MenuItem> items = menuItem.getItems();
                if (items == null) {
                    items = new ArrayList<MenuItem>();
                }
                items.add(this.parseMenuItem(parser, strict));
                menuItem.setItems(items);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return menuItem;
    }

    private PublishDate parsePublishDate(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        PublishDate publishDate = new PublishDate();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("position".equals(name)) {
                publishDate.setPosition(this.interpolatedTrimmed(value, "position"));
                continue;
            }
            if ("format".equals(name)) {
                publishDate.setFormat(this.interpolatedTrimmed(value, "format"));
                continue;
            }
            if ("timezone".equals(name)) {
                publishDate.setTimezone(this.interpolatedTrimmed(value, "timezone"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return publishDate;
    }

    private Skin parseSkin(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Skin skin = new Skin();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                skin.setGroupId(this.interpolatedTrimmed(parser.nextText(), "groupId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                skin.setArtifactId(this.interpolatedTrimmed(parser.nextText(), "artifactId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                skin.setVersion(this.interpolatedTrimmed(parser.nextText(), "version"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return skin;
    }

    private Version parseVersion(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Version version = new Version();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("position".equals(name)) {
                version.setPosition(this.interpolatedTrimmed(value, "position"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return version;
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

