/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;

public class PluginWrapper {
    private String groupId;
    private String artifactId;
    private String version;
    private String source;

    public static List addAll(List plugins, String source) {
        ArrayList<PluginWrapper> results = null;
        if (!plugins.isEmpty()) {
            results = new ArrayList<PluginWrapper>(plugins.size());
            Iterator iter = plugins.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (o instanceof Plugin) {
                    results.add(new PluginWrapper((Plugin)o, source));
                    continue;
                }
                if (!(o instanceof ReportPlugin)) continue;
                results.add(new PluginWrapper((ReportPlugin)o, source));
            }
        }
        return results;
    }

    public PluginWrapper(Plugin plugin, String source) {
        this.setGroupId(plugin.getGroupId());
        this.setArtifactId(plugin.getArtifactId());
        this.setVersion(plugin.getVersion());
        this.setSource(source);
    }

    public PluginWrapper(ReportPlugin plugin, String source) {
        this.setGroupId(plugin.getGroupId());
        this.setArtifactId(plugin.getArtifactId());
        this.setVersion(plugin.getVersion());
        this.setSource(source);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}

