/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;

public abstract class AbstractPropertyEnforcerRule
extends AbstractNonCacheableEnforcerRule {
    private String regex = null;
    private String regexMessage = null;

    public final void setRegex(String regex) {
        this.regex = regex;
    }

    public final String getRegex() {
        return this.regex;
    }

    public final void setRegexMessage(String regexMessage) {
        this.regexMessage = regexMessage;
    }

    public final String getRegexMessage() {
        return this.regexMessage;
    }

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Object propValue = this.resolveValue(helper);
        if (propValue == null) {
            String message = this.getMessage();
            if (message == null) {
                message = this.getName() + " \"" + this.getPropertyName() + "\" is required for this build.";
            }
            throw new EnforcerRuleException(message);
        }
        if (this.regex != null && !propValue.toString().matches(this.regex)) {
            if (this.regexMessage == null) {
                this.regexMessage = this.getName() + " \"" + this.getPropertyName() + "\" evaluates to \"" + propValue + "\".  " + "This does not match the regular expression \"" + this.regex + "\"";
            }
            throw new EnforcerRuleException(this.regexMessage);
        }
    }

    public abstract String getName();

    public abstract String getPropertyName();

    public abstract Object resolveValue(EnforcerRuleHelper var1) throws EnforcerRuleException;
}

