/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public abstract class AbstractBanDependencies
extends AbstractNonCacheableEnforcerRule {
    private boolean searchTransitive = true;
    private transient DependencyGraphBuilder graphBuilder;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        MavenProject project = null;
        try {
            project = (MavenProject)helper.evaluate("${project}");
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleException("Unable to retrieve the MavenProject: ", (Exception)((Object)eee));
        }
        try {
            this.graphBuilder = (DependencyGraphBuilder)helper.getComponent(DependencyGraphBuilder.class);
        }
        catch (ComponentLookupException e) {
            try {
                this.graphBuilder = (DependencyGraphBuilder)helper.getComponent(DependencyGraphBuilder.class.getName(), "maven2");
            }
            catch (ComponentLookupException e1) {
                throw new EnforcerRuleException("Unable to lookup DependencyGraphBuilder: ", (Exception)((Object)e));
            }
        }
        Set<Artifact> dependencies = this.getDependenciesToCheck(project);
        Set<Artifact> foundExcludes = this.checkDependencies(dependencies, helper.getLog());
        if (foundExcludes != null && !foundExcludes.isEmpty()) {
            String message = this.getMessage();
            StringBuilder buf = new StringBuilder();
            if (message != null) {
                buf.append(message + "\n");
            }
            for (Artifact artifact : foundExcludes) {
                buf.append(this.getErrorMessage(artifact));
            }
            message = buf.toString() + "Use 'mvn dependency:tree' to locate the source of the banned dependencies.";
            throw new EnforcerRuleException(message);
        }
    }

    protected CharSequence getErrorMessage(Artifact artifact) {
        return "Found Banned Dependency: " + artifact.getId() + "\n";
    }

    protected Set<Artifact> getDependenciesToCheck(MavenProject project) {
        Set<Artifact> dependencies = null;
        try {
            DependencyNode node = this.graphBuilder.buildDependencyGraph(project, null);
            if (this.searchTransitive) {
                dependencies = this.getAllDescendants(node);
            } else if (node.getChildren() != null) {
                dependencies = new HashSet<Artifact>();
                for (DependencyNode depNode : node.getChildren()) {
                    dependencies.add(depNode.getArtifact());
                }
            }
        }
        catch (DependencyGraphBuilderException e) {
            throw new RuntimeException(e);
        }
        return dependencies;
    }

    private Set<Artifact> getAllDescendants(DependencyNode node) {
        HashSet<Artifact> children = null;
        if (node.getChildren() != null) {
            children = new HashSet<Artifact>();
            for (DependencyNode depNode : node.getChildren()) {
                children.add(depNode.getArtifact());
                Set<Artifact> subNodes = this.getAllDescendants(depNode);
                if (subNodes == null) continue;
                children.addAll(subNodes);
            }
        }
        return children;
    }

    protected abstract Set<Artifact> checkDependencies(Set<Artifact> var1, Log var2) throws EnforcerRuleException;

    public boolean isSearchTransitive() {
        return this.searchTransitive;
    }

    public void setSearchTransitive(boolean theSearchTransitive) {
        this.searchTransitive = theSearchTransitive;
    }
}

