/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.List;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractStandardEnforcerRule;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractVersionEnforcer
extends AbstractStandardEnforcerRule {
    private String version;

    public void enforceVersion(Log log, String variableName, String requiredVersionRange, ArtifactVersion actualVersion) throws EnforcerRuleException {
        if (StringUtils.isEmpty((String)requiredVersionRange)) {
            throw new EnforcerRuleException(variableName + " version can't be empty.");
        }
        String msg = "Detected " + variableName + " Version: " + actualVersion;
        if (actualVersion.toString().equals(requiredVersionRange)) {
            log.debug((CharSequence)(msg + " is allowed in the range " + requiredVersionRange + "."));
        } else {
            try {
                VersionRange vr = VersionRange.createFromVersionSpec((String)requiredVersionRange);
                if (!AbstractVersionEnforcer.containsVersion(vr, actualVersion)) {
                    String message = this.getMessage();
                    if (StringUtils.isEmpty((String)message)) {
                        message = msg + " is not in the allowed range " + vr + ".";
                    }
                    throw new EnforcerRuleException(message);
                }
                log.debug((CharSequence)(msg + " is allowed in the range " + requiredVersionRange + "."));
            }
            catch (InvalidVersionSpecificationException e) {
                throw new EnforcerRuleException("The requested " + variableName + " version " + requiredVersionRange + " is invalid.", (Exception)((Object)e));
            }
        }
    }

    public static boolean containsVersion(VersionRange allowedRange, ArtifactVersion theVersion) {
        boolean matched = false;
        ArtifactVersion recommendedVersion = allowedRange.getRecommendedVersion();
        if (recommendedVersion == null) {
            List restrictions = allowedRange.getRestrictions();
            for (Restriction restriction : restrictions) {
                if (!restriction.containsVersion(theVersion)) continue;
                matched = true;
                break;
            }
        } else {
            int compareTo = recommendedVersion.compareTo((Object)theVersion);
            matched = compareTo <= 0;
        }
        return matched;
    }

    public String getCacheId() {
        if (StringUtils.isNotEmpty((String)this.version)) {
            return "" + this.version.hashCode();
        }
        return "0";
    }

    public boolean isCacheable() {
        return true;
    }

    public boolean isResultValid(EnforcerRule theCachedRule) {
        return true;
    }

    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(String theVersion) {
        this.version = theVersion;
    }
}

