/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractBanDependencies;
import org.apache.maven.plugins.enforcer.utils.ArtifactMatcher;

public class BannedDependencies
extends AbstractBanDependencies {
    private List<String> excludes = null;
    private List<String> includes = null;

    @Override
    protected Set<Artifact> checkDependencies(Set<Artifact> theDependencies, Log log) throws EnforcerRuleException {
        Set<Artifact> included;
        Set<Artifact> excluded = this.checkDependencies(theDependencies, this.excludes);
        if (excluded != null && (included = this.checkDependencies(theDependencies, this.includes)) != null) {
            excluded.removeAll(included);
        }
        return excluded;
    }

    private Set<Artifact> checkDependencies(Set<Artifact> dependencies, List<String> thePatterns) throws EnforcerRuleException {
        HashSet<Artifact> foundMatches = null;
        if (thePatterns != null && thePatterns.size() > 0) {
            for (String pattern : thePatterns) {
                Object[] subStrings = pattern.split(":");
                subStrings = StringUtils.stripAll((String[])subStrings);
                String resultPattern = StringUtils.join((Object[])subStrings, (String)":");
                for (Artifact artifact : dependencies) {
                    if (!this.compareDependency(resultPattern, artifact)) continue;
                    if (foundMatches == null) {
                        foundMatches = new HashSet<Artifact>();
                    }
                    foundMatches.add(artifact);
                }
            }
        }
        return foundMatches;
    }

    protected boolean compareDependency(String pattern, Artifact artifact) throws EnforcerRuleException {
        boolean result;
        ArtifactMatcher.Pattern am = new ArtifactMatcher.Pattern(pattern);
        try {
            result = am.match(artifact);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new EnforcerRuleException("Invalid Version Range: ", (Exception)((Object)e));
        }
        return result;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> theExcludes) {
        this.excludes = theExcludes;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> theIncludes) {
        this.includes = theIncludes;
    }
}

