/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.enforcer.AbstractVersionEnforcer;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class RequireMavenVersion
extends AbstractVersionEnforcer {
    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            MavenSession mavenSession = (MavenSession)helper.evaluate("${session}");
            String mavenVersion = mavenSession.getSystemProperties().getProperty("maven.version");
            helper.getLog().debug((CharSequence)("Detected Maven Version: " + mavenVersion));
            DefaultArtifactVersion detectedVersion = new DefaultArtifactVersion(mavenVersion);
            this.enforceVersion(helper.getLog(), "Maven", this.getVersion(), (ArtifactVersion)detectedVersion);
        }
        catch (ExpressionEvaluationException e) {
            e.printStackTrace();
        }
    }
}

