/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.ArrayList;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Profile;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.StringUtils;

public class RequireProfileIdsExist
extends AbstractNonCacheableEnforcerRule {
    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            MavenSession session = (MavenSession)helper.evaluate("${session}");
            ArrayList profileIds = new ArrayList();
            profileIds.addAll(session.getProjectBuildingRequest().getActiveProfileIds());
            profileIds.addAll(session.getProjectBuildingRequest().getInactiveProfileIds());
            for (MavenProject project : session.getProjects()) {
                for (Profile profile : project.getModel().getProfiles()) {
                    profileIds.remove(profile.getId());
                    if (!profileIds.isEmpty()) continue;
                    return;
                }
            }
            for (org.apache.maven.settings.Profile profile : session.getSettings().getProfiles()) {
                profileIds.remove(profile.getId());
                if (!profileIds.isEmpty()) continue;
                return;
            }
            StringBuilder sb = new StringBuilder();
            if (profileIds.size() > 1) {
                sb.append("The requested profiles don't exist: ");
            } else {
                sb.append("The requested profile doesn't exist: ");
            }
            sb.append(StringUtils.join(profileIds.iterator(), (String)", "));
            throw new EnforcerRuleException(sb.toString());
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException(e.getMessage());
        }
    }
}

