/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules;

import java.text.ChoiceFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.enforcer.rules.utils.ArtifactMatcher;
import org.apache.maven.enforcer.rules.utils.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import org.eclipse.aether.version.VersionConstraint;

@Named(value="banDynamicVersions")
public final class BanDynamicVersions
extends AbstractStandardEnforcerRule {
    private static final String RELEASE = "RELEASE";
    private static final String LATEST = "LATEST";
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    private boolean allowSnapshots;
    private boolean allowLatest;
    private boolean allowRelease;
    private boolean allowRanges;
    private boolean allowRangesWithIdenticalBounds;
    private boolean excludeOptionals;
    private String[] excludedScopes;
    private List<String> ignores = null;
    private final MavenProject project;
    private final RepositorySystem repoSystem;
    private final MavenSession mavenSession;

    @Inject
    public BanDynamicVersions(MavenProject project, RepositorySystem repoSystem, MavenSession mavenSession) {
        this.project = Objects.requireNonNull(project);
        this.repoSystem = Objects.requireNonNull(repoSystem);
        this.mavenSession = Objects.requireNonNull(mavenSession);
    }

    public void execute() throws EnforcerRuleException {
        DefaultRepositorySystemSession newRepoSession = new DefaultRepositorySystemSession(this.mavenSession.getRepositorySession());
        ArrayList<Object> depSelectors = new ArrayList<Object>();
        depSelectors.add(new ScopeDependencySelector(this.excludedScopes));
        if (this.excludeOptionals) {
            depSelectors.add(new OptionalDependencySelector());
        }
        newRepoSession.setDependencySelector((DependencySelector)new AndDependencySelector(depSelectors));
        Dependency rootDependency = RepositoryUtils.toDependency((Artifact)this.project.getArtifact(), null);
        try {
            int numViolations = this.emitDependenciesWithBannedDynamicVersions(rootDependency, (RepositorySystemSession)newRepoSession);
            if (numViolations > 0) {
                ChoiceFormat dependenciesFormat = new ChoiceFormat("1#dependency|1<dependencies");
                throw new EnforcerRuleException("Found " + numViolations + " " + dependenciesFormat.format(numViolations) + " with dynamic versions. Look at the warnings emitted above for the details.");
            }
        }
        catch (DependencyCollectionException e) {
            throw new EnforcerRuleException("Could not retrieve dependency metadata for project", (Exception)((Object)e));
        }
    }

    private static String dumpIntermediatePath(Collection<DependencyNode> path) {
        if (path.isEmpty()) {
            return "";
        }
        return " via " + path.stream().map(n -> n.getArtifact().toString()).collect(Collectors.joining(" -> "));
    }

    private int emitDependenciesWithBannedDynamicVersions(Dependency rootDependency, RepositorySystemSession repoSession) throws DependencyCollectionException {
        CollectRequest collectRequest = new CollectRequest(rootDependency, this.project.getRemoteProjectRepositories());
        CollectResult collectResult = this.repoSystem.collectDependencies(repoSession, collectRequest);
        ExcludeArtifactPatternsPredicate predicate = this.ignores != null && !this.ignores.isEmpty() ? new ExcludeArtifactPatternsPredicate(this.ignores) : d -> true;
        BannedDynamicVersionCollector bannedDynamicVersionCollector = new BannedDynamicVersionCollector(predicate);
        TreeDependencyVisitor depVisitor = new TreeDependencyVisitor((DependencyVisitor)bannedDynamicVersionCollector);
        collectResult.getRoot().accept((DependencyVisitor)depVisitor);
        return bannedDynamicVersionCollector.getNumViolations();
    }

    public String toString() {
        return String.format("BanDynamicVersions[allowSnapshots=%b, allowLatest=%b, allowRelease=%b, allowRanges=%b, allowRangesWithIdenticalBounds=%b, excludeOptionals=%b, excludedScopes=%s, ignores=%s]", this.allowSnapshots, this.allowLatest, this.allowRelease, this.allowRanges, this.allowRangesWithIdenticalBounds, this.excludeOptionals, this.excludedScopes, this.ignores);
    }

    private static final class ExcludeArtifactPatternsPredicate
    implements Predicate<DependencyNode> {
        private final ArtifactMatcher artifactMatcher;

        ExcludeArtifactPatternsPredicate(List<String> excludes) {
            this.artifactMatcher = new ArtifactMatcher(excludes, Collections.emptyList());
        }

        @Override
        public boolean test(DependencyNode depNode) {
            return this.artifactMatcher.match(ArtifactUtils.toArtifact(depNode));
        }
    }

    private final class BannedDynamicVersionCollector
    implements DependencyVisitor {
        private final Deque<DependencyNode> nodeStack = new ArrayDeque<DependencyNode>();
        private boolean isRoot = true;
        private int numViolations;
        private final Predicate<DependencyNode> predicate;

        public int getNumViolations() {
            return this.numViolations;
        }

        BannedDynamicVersionCollector(Predicate<DependencyNode> predicate) {
            this.predicate = predicate;
            this.isRoot = true;
            this.numViolations = 0;
        }

        private boolean isBannedDynamicVersion(VersionConstraint versionConstraint) {
            if (versionConstraint.getVersion() != null) {
                if (versionConstraint.getVersion().toString().equals(BanDynamicVersions.LATEST)) {
                    return !BanDynamicVersions.this.allowLatest;
                }
                if (versionConstraint.getVersion().toString().equals(BanDynamicVersions.RELEASE)) {
                    return !BanDynamicVersions.this.allowRelease;
                }
                if (versionConstraint.getVersion().toString().endsWith(BanDynamicVersions.SNAPSHOT_SUFFIX)) {
                    return !BanDynamicVersions.this.allowSnapshots;
                }
            } else {
                if (versionConstraint.getRange() != null) {
                    if (BanDynamicVersions.this.allowRangesWithIdenticalBounds && Objects.equals(versionConstraint.getRange().getLowerBound(), versionConstraint.getRange().getUpperBound())) {
                        return false;
                    }
                    return !BanDynamicVersions.this.allowRanges;
                }
                BanDynamicVersions.this.getLog().warn((CharSequence)("Unexpected version constraint found: " + versionConstraint));
            }
            return false;
        }

        public boolean visitEnter(DependencyNode node) {
            if (this.isRoot) {
                this.isRoot = false;
            } else {
                BanDynamicVersions.this.getLog().debug((CharSequence)("Found node " + node + " with version constraint " + node.getVersionConstraint()));
                if (this.predicate.test(node) && this.isBannedDynamicVersion(node.getVersionConstraint())) {
                    BanDynamicVersions.this.getLog().warnOrError(() -> new StringBuilder().append("Dependency ").append(node.getDependency()).append(BanDynamicVersions.dumpIntermediatePath(this.nodeStack)).append(" is referenced with a banned dynamic version ").append(node.getVersionConstraint()));
                    ++this.numViolations;
                    return false;
                }
                this.nodeStack.addLast(node);
            }
            return true;
        }

        public boolean visitLeave(DependencyNode node) {
            if (!this.nodeStack.isEmpty()) {
                this.nodeStack.removeLast();
            }
            return true;
        }
    }
}

