/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.dependency;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.enforcer.rules.dependency.ResolveUtil;
import org.apache.maven.enforcer.rules.utils.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.DependencyNode;

abstract class BannedDependenciesBase
extends AbstractStandardEnforcerRule {
    private List<String> excludes = null;
    private List<String> includes = null;
    private boolean searchTransitive = true;
    private final MavenSession session;
    private final ResolveUtil resolveUtil;

    BannedDependenciesBase(MavenSession session, ResolveUtil resolveUtil) {
        this.session = Objects.requireNonNull(session);
        this.resolveUtil = Objects.requireNonNull(resolveUtil);
    }

    protected MavenSession getSession() {
        return this.session;
    }

    public void execute() throws EnforcerRuleException {
        if (!this.searchTransitive) {
            String result = this.session.getCurrentProject().getDependencyArtifacts().stream().filter(a -> !this.validate((Artifact)a)).collect(StringBuilder::new, (messageBuilder, node) -> messageBuilder.append(System.lineSeparator()).append(node.getId()).append(" <--- ").append(this.getErrorMessage()), (m1, m2) -> m1.append(m2.toString())).toString();
            if (!result.isEmpty()) {
                String message = "";
                if (this.getMessage() != null) {
                    message = this.getMessage() + System.lineSeparator();
                }
                throw new EnforcerRuleException(message + result);
            }
        } else {
            StringBuilder messageBuilder2 = new StringBuilder();
            DependencyNode rootNode = this.resolveUtil.resolveTransitiveDependencies(new DependencySelector[0]);
            if (!this.validate(rootNode, 0, messageBuilder2)) {
                String message = "";
                if (this.getMessage() != null) {
                    message = this.getMessage() + System.lineSeparator();
                }
                throw new EnforcerRuleException(message + messageBuilder2);
            }
        }
    }

    protected boolean validate(DependencyNode node, int level, StringBuilder messageBuilder) {
        boolean rootFailed = level > 0 && !this.validate(ArtifactUtils.toArtifact(node));
        StringBuilder childMessageBuilder = new StringBuilder();
        if (rootFailed || !node.getChildren().stream().map(childNode -> this.validate((DependencyNode)childNode, level + 1, childMessageBuilder)).reduce(true, Boolean::logicalAnd).booleanValue()) {
            messageBuilder.append(StringUtils.repeat((String)"   ", (int)level)).append(ArtifactUtils.toArtifact(node).getId());
            if (rootFailed) {
                messageBuilder.append(" <--- ").append(this.getErrorMessage());
            }
            messageBuilder.append(System.lineSeparator()).append((CharSequence)childMessageBuilder);
            return false;
        }
        return true;
    }

    protected abstract String getErrorMessage();

    protected abstract boolean validate(Artifact var1);

    public void setSearchTransitive(boolean theSearchTransitive) {
        this.searchTransitive = theSearchTransitive;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> theExcludes) {
        this.excludes = theExcludes;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> theIncludes) {
        this.includes = theIncludes;
    }

    public boolean isSearchTransitive() {
        return this.searchTransitive;
    }
}

