/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.dependency;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.dependency.BannedDependenciesBase;
import org.apache.maven.enforcer.rules.dependency.ResolveUtil;
import org.apache.maven.enforcer.rules.utils.ArtifactUtils;
import org.apache.maven.execution.MavenSession;

@Named(value="requireReleaseDeps")
public final class RequireReleaseDeps
extends BannedDependenciesBase {
    private boolean onlyWhenRelease = false;
    private boolean failWhenParentIsSnapshot = true;

    @Inject
    public RequireReleaseDeps(MavenSession session, ResolveUtil resolveUtil) {
        super(session, resolveUtil);
    }

    @Override
    public void execute() throws EnforcerRuleException {
        boolean callSuper = this.onlyWhenRelease ? !this.getSession().getCurrentProject().getArtifact().isSnapshot() : true;
        if (callSuper) {
            super.execute();
            if (this.failWhenParentIsSnapshot) {
                Artifact parentArtifact = this.getSession().getCurrentProject().getParentArtifact();
                if (parentArtifact != null) {
                    HashSet<Artifact> singletonArtifact = new HashSet<Artifact>();
                    singletonArtifact.add(parentArtifact);
                    Set<Artifact> artifacts = this.filterArtifacts(singletonArtifact);
                    parentArtifact = Optional.ofNullable(artifacts).flatMap(s -> s.stream().findFirst()).orElse(null);
                }
                if (parentArtifact != null && parentArtifact.isSnapshot()) {
                    throw new EnforcerRuleException("Parent Cannot be a snapshot: " + parentArtifact.getId());
                }
            }
        }
    }

    @Override
    protected String getErrorMessage() {
        return "is not a release dependency";
    }

    @Override
    protected boolean validate(Artifact artifact) {
        return ArtifactUtils.matchDependencyArtifact(artifact, this.getExcludes()) && !ArtifactUtils.matchDependencyArtifact(artifact, this.getIncludes()) || !artifact.isSnapshot();
    }

    private Set<Artifact> filterArtifacts(Set<Artifact> dependencies) throws EnforcerRuleException {
        if (this.getIncludes() != null) {
            dependencies = ArtifactUtils.filterDependencyArtifacts(dependencies, this.getIncludes());
        }
        if (dependencies != null && this.getExcludes() != null) {
            Optional.ofNullable(ArtifactUtils.filterDependencyArtifacts(dependencies, this.getExcludes())).ifPresent(dependencies::removeAll);
        }
        return dependencies;
    }

    public void setOnlyWhenRelease(boolean onlyWhenRelease) {
        this.onlyWhenRelease = onlyWhenRelease;
    }

    public void setFailWhenParentIsSnapshot(boolean failWhenParentIsSnapshot) {
        this.failWhenParentIsSnapshot = failWhenParentIsSnapshot;
    }

    public String toString() {
        return String.format("RequireReleaseDeps[message=%s, excludes=%s, includes=%s, searchTransitive=%b, onlyWhenRelease=%b, failWhenParentIsSnapshot=%b]", this.getMessage(), this.getExcludes(), this.getIncludes(), this.isSearchTransitive(), this.onlyWhenRelease, this.failWhenParentIsSnapshot);
    }
}

