/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.property;

import javax.inject.Named;
import org.apache.maven.enforcer.rules.property.AbstractPropertyEnforcerRule;

@Named(value="requireEnvironmentVariable")
public final class RequireEnvironmentVariable
extends AbstractPropertyEnforcerRule {
    private String variableName = null;

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    @Override
    public String resolveValue() {
        return System.getenv(this.variableName);
    }

    public String getCacheId() {
        return String.valueOf(this.toString().hashCode());
    }

    @Override
    public String getPropertyName() {
        return this.variableName;
    }

    @Override
    public String getName() {
        return "Environment variable";
    }

    public String toString() {
        return String.format("RequireEnvironmentVariable[message=%s, variableName=%s, regex=%s, regexMessage=%s]", this.getMessage(), this.variableName, this.getRegex(), this.getRegexMessage());
    }
}

