/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.AbstractEnforcerRuleConfigProvider;
import org.apache.maven.enforcer.rule.api.EnforcerRuleError;
import org.apache.maven.enforcer.rules.utils.ExpressionEvaluator;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Named(value="externalRules")
public final class ExternalRules
extends AbstractEnforcerRuleConfigProvider {
    private static final String LOCATION_PREFIX_CLASSPATH = "classpath:";
    private String location;
    private final MojoExecution mojoExecution;
    private final ExpressionEvaluator evaluator;

    @Inject
    public ExternalRules(MojoExecution mojoExecution, ExpressionEvaluator evaluator) {
        this.mojoExecution = Objects.requireNonNull(mojoExecution);
        this.evaluator = Objects.requireNonNull(evaluator);
    }

    public void setLocation(String location) {
        this.location = location;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Xpp3Dom getRulesConfig() throws EnforcerRuleError {
        try (InputStream descriptorStream = this.resolveDescriptor();){
            Xpp3Dom enforcerRules = Xpp3DomBuilder.build((InputStream)descriptorStream, (String)"UTF-8");
            if (enforcerRules.getChildCount() != 1) throw new EnforcerRuleError("Enforcer rules configuration not found in: " + this.location);
            if (!"enforcer".equals(enforcerRules.getName())) throw new EnforcerRuleError("Enforcer rules configuration not found in: " + this.location);
            Xpp3Dom xpp3Dom = enforcerRules.getChild(0);
            return xpp3Dom;
        }
        catch (IOException | XmlPullParserException e) {
            throw new EnforcerRuleError(e);
        }
    }

    private InputStream resolveDescriptor() throws EnforcerRuleError {
        InputStream descriptorStream;
        if (this.location != null) {
            if (this.location.startsWith(LOCATION_PREFIX_CLASSPATH)) {
                String classpathLocation = this.location.substring(LOCATION_PREFIX_CLASSPATH.length());
                this.getLog().debug((CharSequence)("Read rules form classpath location: " + classpathLocation));
                ClassRealm classRealm = this.mojoExecution.getMojoDescriptor().getRealm();
                descriptorStream = classRealm.getResourceAsStream(classpathLocation);
                if (descriptorStream == null) {
                    throw new EnforcerRuleError("Location '" + classpathLocation + "' not found in classpath");
                }
            } else {
                File descriptorFile = this.evaluator.alignToBaseDirectory(new File(this.location));
                this.getLog().debug((CharSequence)("Read rules form file location: " + descriptorFile));
                try {
                    descriptorStream = Files.newInputStream(descriptorFile.toPath(), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new EnforcerRuleError("Could not read descriptor in " + descriptorFile, (Throwable)e);
                }
            }
        } else {
            throw new EnforcerRuleError("No location provided");
        }
        return descriptorStream;
    }

    public String toString() {
        return String.format("ExternalRules[location=%s]", this.location);
    }
}

