/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.enforcer.rules.utils.ArtifactUtils;
import org.apache.maven.execution.MavenSession;

@Named(value="bannedPlugins")
public final class BannedPlugins
extends AbstractStandardEnforcerRule {
    private List<String> excludes = null;
    private List<String> includes = null;
    private final MavenSession session;

    @Inject
    public BannedPlugins(MavenSession session) {
        this.session = Objects.requireNonNull(session);
    }

    public void execute() throws EnforcerRuleException {
        Predicate<Artifact> shouldExclude = ArtifactUtils.prepareDependencyArtifactMatcher(this.excludes);
        Predicate<Artifact> shouldInclude = ArtifactUtils.prepareDependencyArtifactMatcher(this.includes);
        String result = this.session.getCurrentProject().getPluginArtifacts().stream().filter(a -> shouldExclude.test((Artifact)a) && !shouldInclude.test((Artifact)a)).collect(StringBuilder::new, (messageBuilder, node) -> messageBuilder.append(node.getId()).append(" <--- banned plugin"), (m1, m2) -> m1.append(m2.toString())).toString();
        if (!result.isEmpty()) {
            throw new EnforcerRuleException(result);
        }
    }

    public String toString() {
        return String.format("BannedPlugins[excludes=%s, includes=%s]", this.excludes, this.includes);
    }
}

