/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;

@Named(value="requireSameVersions")
public final class RequireSameVersions
extends AbstractStandardEnforcerRule {
    private boolean uniqueVersions;
    private Set<String> dependencies = new HashSet<String>();
    private Set<String> plugins = new HashSet<String>();
    private Set<String> buildPlugins = new HashSet<String>();
    private Set<String> reportPlugins = new HashSet<String>();
    private boolean sameModuleVersions;
    private final MavenProject project;
    private final MavenSession session;

    @Inject
    public RequireSameVersions(MavenProject project, MavenSession session) {
        this.project = Objects.requireNonNull(project);
        this.session = Objects.requireNonNull(session);
    }

    public void execute() throws EnforcerRuleException {
        MavenProject topLevelProject;
        LinkedHashMap<String, List<String>> versionMembers = new LinkedHashMap<String, List<String>>();
        HashSet<String> allBuildPlugins = new HashSet<String>(this.buildPlugins);
        allBuildPlugins.addAll(this.plugins);
        HashSet<String> allReportPlugins = new HashSet<String>(this.reportPlugins);
        allReportPlugins.addAll(this.plugins);
        versionMembers.putAll(this.collectVersionMembers(this.project.getArtifacts(), this.dependencies, " (dependency)"));
        versionMembers.putAll(this.collectVersionMembers(this.project.getPluginArtifacts(), allBuildPlugins, " (buildPlugin)"));
        versionMembers.putAll(this.collectVersionMembers(this.project.getReportArtifacts(), allReportPlugins, " (reportPlugin)"));
        if (versionMembers.size() > 1) {
            StringBuilder builder = new StringBuilder("Found entries with different versions" + System.lineSeparator());
            for (Map.Entry entry : versionMembers.entrySet()) {
                builder.append("Entries with version ").append((String)entry.getKey()).append(System.lineSeparator());
                for (String conflictId : (List)entry.getValue()) {
                    builder.append("- ").append(conflictId).append(System.lineSeparator());
                }
            }
            throw new EnforcerRuleException(builder.toString());
        }
        if (this.sameModuleVersions && !Objects.equals((topLevelProject = this.session.getTopLevelProject()).getVersion(), this.project.getVersion())) {
            throw new EnforcerRuleException("Top level project has version " + topLevelProject.getVersion() + " but current module has different version " + this.project.getVersion());
        }
    }

    private Map<String, List<String>> collectVersionMembers(Set<Artifact> artifacts, Collection<String> patterns, String source) {
        LinkedHashMap<String, List<String>> versionMembers = new LinkedHashMap<String, List<String>>();
        ArrayList<Pattern> regExs = new ArrayList<Pattern>();
        for (String pattern : patterns) {
            String regex = pattern.replace(".", "\\.").replace("*", ".*").replace(":", "\\:").replace('?', '.');
            regExs.add(Pattern.compile(regex + "(\\:.+)?"));
        }
        for (Artifact artifact : artifacts) {
            for (Pattern regEx : regExs) {
                if (!regEx.matcher(artifact.getDependencyConflictId()).matches()) continue;
                String version = this.uniqueVersions ? artifact.getVersion() : artifact.getBaseVersion();
                versionMembers.computeIfAbsent(version, unused -> new ArrayList()).add(artifact.getDependencyConflictId() + source);
            }
        }
        return versionMembers;
    }

    void addDependency(String dependency) {
        this.dependencies.add(dependency);
    }

    void addPlugin(String plugin) {
        this.plugins.add(plugin);
    }

    void addBuildPlugin(String buildPlugin) {
        this.buildPlugins.add(buildPlugin);
    }

    void addReportPlugin(String reportPlugin) {
        this.reportPlugins.add(reportPlugin);
    }

    public String toString() {
        return String.format("RequireSameVersions[dependencies=%s, buildPlugins=%s, reportPlugins=%s, plugins=%s, uniqueVersions=%b, sameModuleVersions=%b]", this.dependencies, this.buildPlugins, this.reportPlugins, this.plugins, this.uniqueVersions, this.sameModuleVersions);
    }
}

