/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.utils;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.utils.ArtifactMatcher;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;

public final class ArtifactUtils {
    public static org.apache.maven.artifact.Artifact toArtifact(DependencyNode node) {
        org.apache.maven.artifact.Artifact artifact = RepositoryUtils.toArtifact((Artifact)node.getArtifact());
        Optional.ofNullable(node.getDependency()).ifPresent(dependency -> {
            Optional.ofNullable(dependency.getScope()).ifPresent(arg_0 -> ((org.apache.maven.artifact.Artifact)artifact).setScope(arg_0));
            artifact.setOptional(dependency.isOptional());
        });
        return artifact;
    }

    public static Set<org.apache.maven.artifact.Artifact> filterDependencyArtifacts(Set<org.apache.maven.artifact.Artifact> dependencies, Collection<String> patterns) throws EnforcerRuleException {
        try {
            return Optional.ofNullable(patterns).map(collection -> collection.stream().map(p -> p.split(":")).map(StringUtils::stripAll).map(arr -> String.join((CharSequence)":", arr)).flatMap(pattern -> dependencies.stream().filter(artifact -> ArtifactUtils.compareDependency(pattern, artifact))).collect(Collectors.toSet())).orElse(null);
        }
        catch (IllegalArgumentException e) {
            if (e.getCause() instanceof InvalidVersionSpecificationException) {
                throw new EnforcerRuleException(e.getMessage());
            }
            throw e;
        }
    }

    public static Predicate<org.apache.maven.artifact.Artifact> prepareDependencyArtifactMatcher(Collection<String> patterns) {
        return ArtifactUtils.cleansePatterns(patterns).map(ArtifactMatcher.Pattern::new).map(pattern -> pattern::match).reduce(Predicate::or).orElse(test -> false);
    }

    private static Stream<String> cleansePatterns(Collection<String> patterns) {
        return Optional.ofNullable(patterns).map(collection -> collection.stream().map(p -> p.split(":")).map(StringUtils::stripAll).map(arr -> String.join((CharSequence)":", arr))).orElse(Stream.empty());
    }

    public static boolean compareDependency(String pattern, org.apache.maven.artifact.Artifact artifact) {
        return new ArtifactMatcher.Pattern(pattern).match(artifact);
    }
}

