/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.dependency;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.enforcer.rules.dependency.ResolverUtil;
import org.apache.maven.enforcer.rules.utils.ArtifactMatcher;
import org.apache.maven.enforcer.rules.utils.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.eclipse.aether.graph.DependencyNode;

abstract class BannedDependenciesBase
extends AbstractStandardEnforcerRule {
    private List<String> excludes = null;
    private List<String> includes = null;
    private boolean searchTransitive = true;
    private final MavenSession session;
    private final ResolverUtil resolverUtil;

    BannedDependenciesBase(MavenSession session, ResolverUtil resolverUtil) {
        this.session = Objects.requireNonNull(session);
        this.resolverUtil = Objects.requireNonNull(resolverUtil);
    }

    protected MavenSession getSession() {
        return this.session;
    }

    public void execute() throws EnforcerRuleException {
        if (!this.searchTransitive) {
            String result = this.session.getCurrentProject().getDependencyArtifacts().stream().filter(a -> !this.validate((Artifact)a)).collect(StringBuilder::new, (messageBuilder, node) -> messageBuilder.append(System.lineSeparator()).append(node.getId()).append(" <--- ").append(this.getErrorMessage()), (m1, m2) -> m1.append(m2.toString())).toString();
            if (!result.isEmpty()) {
                String message = "";
                if (this.getMessage() != null) {
                    message = this.getMessage() + System.lineSeparator();
                }
                throw new EnforcerRuleException(message + result);
            }
        } else {
            HashSet<ArtifactMatcher.MatchingArtifact> visitedArtifacts;
            StringBuilder messageBuilder2 = new StringBuilder();
            DependencyNode rootNode = this.resolverUtil.resolveTransitiveDependenciesVerbose(Collections.emptyList());
            if (!this.validate(rootNode, 0, messageBuilder2, visitedArtifacts = new HashSet<ArtifactMatcher.MatchingArtifact>())) {
                String message = "";
                if (this.getMessage() != null) {
                    message = this.getMessage() + System.lineSeparator();
                }
                throw new EnforcerRuleException(message + messageBuilder2);
            }
        }
    }

    protected boolean validate(DependencyNode node, int level, StringBuilder messageBuilder, Set<ArtifactMatcher.MatchingArtifact> visitedArtifacts) {
        Artifact artifact = ArtifactUtils.toArtifact(node);
        boolean rootFailed = false;
        if (level > 0 && visitedArtifacts.add(new ArtifactMatcher.MatchingArtifact(artifact))) {
            rootFailed = !this.validate(artifact);
        }
        StringBuilder childMessageBuilder = new StringBuilder();
        if (rootFailed || !node.getChildren().stream().map(childNode -> this.validate((DependencyNode)childNode, level + 1, childMessageBuilder, visitedArtifacts)).reduce(true, Boolean::logicalAnd).booleanValue()) {
            messageBuilder.append(StringUtils.repeat((String)"   ", (int)level)).append(ArtifactUtils.toArtifact(node).getId());
            if (rootFailed) {
                messageBuilder.append(" <--- ").append(this.getErrorMessage());
            }
            messageBuilder.append(System.lineSeparator()).append((CharSequence)childMessageBuilder);
            return false;
        }
        return true;
    }

    protected abstract String getErrorMessage();

    protected abstract boolean validate(Artifact var1);

    public void setSearchTransitive(boolean searchTransitive) {
        this.searchTransitive = searchTransitive;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public boolean isSearchTransitive() {
        return this.searchTransitive;
    }
}

