/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.dependency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.enforcer.rules.dependency.ResolverUtil;
import org.apache.maven.enforcer.rules.utils.ArtifactUtils;
import org.apache.maven.enforcer.rules.utils.ParentNodeProvider;
import org.apache.maven.enforcer.rules.utils.ParentsVisitor;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.util.graph.manager.DependencyManagerUtils;

@Named(value="requireUpperBoundDeps")
public final class RequireUpperBoundDeps
extends AbstractStandardEnforcerRule {
    private boolean uniqueVersions;
    private List<String> excludes = null;
    private List<String> includes = null;
    private List<String> excludedScopes = Arrays.asList("test", "provided");
    private RequireUpperBoundDepsVisitor upperBoundDepsVisitor;
    private final ResolverUtil resolverUtil;

    @Inject
    public RequireUpperBoundDeps(ResolverUtil resolverUtil) {
        this.resolverUtil = Objects.requireNonNull(resolverUtil);
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public void execute() throws EnforcerRuleException {
        DependencyNode node = this.resolverUtil.resolveTransitiveDependenciesVerbose(this.excludedScopes);
        this.upperBoundDepsVisitor = new RequireUpperBoundDepsVisitor().setUniqueVersions(this.uniqueVersions).setIncludes(this.includes);
        this.getLog().debug(() -> this.resolverUtil.dumpTree(node));
        node.accept((DependencyVisitor)this.upperBoundDepsVisitor);
        List<String> errorMessages = this.buildErrorMessages(this.upperBoundDepsVisitor.getConflicts());
        if (!errorMessages.isEmpty()) {
            throw new EnforcerRuleException("Failed while enforcing RequireUpperBoundDeps. The error(s) are " + errorMessages);
        }
    }

    private List<String> buildErrorMessages(List<List<DependencyNode>> conflicts) {
        ArrayList<String> errorMessages = new ArrayList<String>(conflicts.size());
        for (List<DependencyNode> conflict : conflicts) {
            Artifact artifact = conflict.get(0).getArtifact();
            String groupArt = artifact.getGroupId() + ":" + artifact.getArtifactId();
            if (this.excludes != null && this.excludes.contains(groupArt)) {
                this.getLog().info((CharSequence)("Ignoring requireUpperBoundDeps in " + groupArt));
                continue;
            }
            errorMessages.add(this.buildErrorMessage(conflict));
        }
        return errorMessages;
    }

    private String buildErrorMessage(List<DependencyNode> conflict) {
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append(System.lineSeparator()).append("Require upper bound dependencies error for ").append(this.getFullArtifactName(conflict.get(0), false)).append(". Paths to dependency are:").append(System.lineSeparator());
        if (conflict.size() > 0) {
            errorMessage.append((CharSequence)this.buildTreeString(conflict.get(0)));
        }
        for (DependencyNode node : conflict.subList(1, conflict.size())) {
            errorMessage.append("and").append(System.lineSeparator());
            errorMessage.append((CharSequence)this.buildTreeString(node));
        }
        return errorMessage.toString();
    }

    private StringBuilder buildTreeString(DependencyNode node) {
        ArrayList<String> loc = new ArrayList<String>();
        DependencyNode currentNode = node;
        while (currentNode != null) {
            StringBuilder line = new StringBuilder(this.getFullArtifactName(currentNode, false));
            if (DependencyManagerUtils.getPremanagedVersion((DependencyNode)currentNode) != null) {
                line.append(" (managed) <-- ");
                line.append(this.getFullArtifactName(currentNode, true));
            }
            loc.add(line.toString());
            currentNode = this.upperBoundDepsVisitor.getParent(currentNode);
        }
        Collections.reverse(loc);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < loc.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                builder.append("  ");
            }
            builder.append("+-").append((String)loc.get(i));
            builder.append(System.lineSeparator());
        }
        return builder;
    }

    private String getFullArtifactName(DependencyNode node, boolean usePremanaged) {
        String scope;
        org.apache.maven.artifact.Artifact artifact = ArtifactUtils.toArtifact(node);
        String version = DependencyManagerUtils.getPremanagedVersion((DependencyNode)node);
        if (!usePremanaged || version == null) {
            version = this.uniqueVersions ? artifact.getVersion() : artifact.getBaseVersion();
        }
        String result = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + version;
        String classifier = artifact.getClassifier();
        if (classifier != null && !classifier.isEmpty()) {
            result = result + ":" + classifier;
        }
        if ((scope = artifact.getScope()) != null && !"compile".equals(scope)) {
            result = result + " [" + scope + ']';
        }
        return result;
    }

    private static class RequireUpperBoundDepsVisitor
    implements DependencyVisitor,
    ParentNodeProvider {
        private final ParentsVisitor parentsVisitor = new ParentsVisitor();
        private boolean uniqueVersions;
        private List<String> includes = null;
        private final Map<String, List<DependencyNodeHopCountPair>> keyToPairsMap = new HashMap<String, List<DependencyNodeHopCountPair>>();

        private RequireUpperBoundDepsVisitor() {
        }

        public RequireUpperBoundDepsVisitor setUniqueVersions(boolean uniqueVersions) {
            this.uniqueVersions = uniqueVersions;
            return this;
        }

        public RequireUpperBoundDepsVisitor setIncludes(List<String> includes) {
            this.includes = includes;
            return this;
        }

        public boolean visitEnter(DependencyNode node) {
            this.parentsVisitor.visitEnter(node);
            DependencyNodeHopCountPair pair = new DependencyNodeHopCountPair(node, this);
            String key = pair.constructKey();
            if (this.includes != null && !this.includes.isEmpty() && !this.includes.contains(key)) {
                return true;
            }
            this.keyToPairsMap.computeIfAbsent(key, k1 -> new ArrayList()).add(pair);
            this.keyToPairsMap.get(key).sort(DependencyNodeHopCountPair::compareTo);
            return true;
        }

        public boolean visitLeave(DependencyNode node) {
            return this.parentsVisitor.visitLeave(node);
        }

        public List<List<DependencyNode>> getConflicts() {
            ArrayList<List<DependencyNode>> output = new ArrayList<List<DependencyNode>>();
            for (List<DependencyNodeHopCountPair> pairs : this.keyToPairsMap.values()) {
                if (!this.containsConflicts(pairs)) continue;
                ArrayList<DependencyNode> outputSubList = new ArrayList<DependencyNode>(pairs.size());
                for (DependencyNodeHopCountPair pair : pairs) {
                    outputSubList.add(pair.getNode());
                }
                output.add(outputSubList);
            }
            return output;
        }

        private boolean containsConflicts(List<DependencyNodeHopCountPair> pairs) {
            DependencyNodeHopCountPair resolvedPair = pairs.get(0);
            ArtifactVersion resolvedVersion = resolvedPair.extractArtifactVersion(this.uniqueVersions, false);
            for (DependencyNodeHopCountPair pair : pairs) {
                ArtifactVersion version = pair.extractArtifactVersion(this.uniqueVersions, true);
                if (resolvedVersion.compareTo((Object)version) >= 0) continue;
                return true;
            }
            return false;
        }

        @Override
        public DependencyNode getParent(DependencyNode node) {
            return this.parentsVisitor.getParent(node);
        }
    }

    private static class DependencyNodeHopCountPair
    implements Comparable<DependencyNodeHopCountPair> {
        private final DependencyNode node;
        private int hopCount;
        private final ParentNodeProvider parentNodeProvider;

        private DependencyNodeHopCountPair(DependencyNode node, ParentNodeProvider parentNodeProvider) {
            this.parentNodeProvider = parentNodeProvider;
            this.node = node;
            this.countHops();
        }

        private void countHops() {
            this.hopCount = 0;
            DependencyNode parent = this.parentNodeProvider.getParent(this.node);
            while (parent != null) {
                ++this.hopCount;
                parent = this.parentNodeProvider.getParent(parent);
            }
        }

        private String constructKey() {
            org.apache.maven.artifact.Artifact artifact = ArtifactUtils.toArtifact(this.node);
            return artifact.getGroupId() + ":" + artifact.getArtifactId();
        }

        public DependencyNode getNode() {
            return this.node;
        }

        private ArtifactVersion extractArtifactVersion(boolean uniqueVersions, boolean usePremanagedVersion) {
            String version;
            if (usePremanagedVersion && DependencyManagerUtils.getPremanagedVersion((DependencyNode)this.node) != null) {
                return new DefaultArtifactVersion(DependencyManagerUtils.getPremanagedVersion((DependencyNode)this.node));
            }
            org.apache.maven.artifact.Artifact artifact = ArtifactUtils.toArtifact(this.node);
            String string = version = uniqueVersions ? artifact.getVersion() : artifact.getBaseVersion();
            if (version != null) {
                return new DefaultArtifactVersion(version);
            }
            try {
                return artifact.getSelectedVersion();
            }
            catch (OverConstrainedVersionException e) {
                throw new RuntimeException("Version ranges problem with " + this.node.getArtifact(), e);
            }
        }

        public int getHopCount() {
            return this.hopCount;
        }

        @Override
        public int compareTo(DependencyNodeHopCountPair other) {
            return Integer.compare(this.hopCount, other.getHopCount());
        }
    }
}

