/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.enforcer.rules.utils.ArtifactMatcher;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;

@Named(value="banDependencyManagementScope")
public final class BanDependencyManagementScope
extends AbstractStandardEnforcerRule {
    private List<String> excludes = null;
    private boolean checkEffectivePom = false;
    private final MavenProject project;

    @Inject
    public BanDependencyManagementScope(MavenProject project) {
        this.project = Objects.requireNonNull(project);
    }

    public void execute() throws EnforcerRuleException {
        List<Dependency> violatingDependencies;
        DependencyManagement depMgmt;
        DependencyManagement dependencyManagement = depMgmt = this.checkEffectivePom ? this.project.getModel().getDependencyManagement() : this.project.getOriginalModel().getDependencyManagement();
        if (depMgmt != null && depMgmt.getDependencies() != null && !(violatingDependencies = this.getViolatingDependencies(depMgmt)).isEmpty()) {
            String message = this.getMessage();
            StringBuilder buf = new StringBuilder();
            if (message == null) {
                message = "Scope other than 'import' is not allowed in 'dependencyManagement'";
            }
            buf.append(message + System.lineSeparator());
            for (Dependency violatingDependency : violatingDependencies) {
                buf.append(BanDependencyManagementScope.getErrorMessage(this.project, violatingDependency));
            }
            throw new EnforcerRuleException(buf.toString());
        }
    }

    List<Dependency> getViolatingDependencies(DependencyManagement depMgmt) {
        ArtifactMatcher excludesMatcher = this.excludes != null ? new ArtifactMatcher(this.excludes, Collections.emptyList()) : null;
        ArrayList<Dependency> violatingDependencies = new ArrayList<Dependency>();
        for (Dependency dependency : depMgmt.getDependencies()) {
            if (dependency.getScope() == null || "import".equals(dependency.getScope())) continue;
            if (excludesMatcher != null && excludesMatcher.match(dependency)) {
                this.getLog().debug((CharSequence)("Skipping excluded dependency " + dependency + " with scope " + dependency.getScope()));
                continue;
            }
            violatingDependencies.add(dependency);
        }
        return violatingDependencies;
    }

    private static CharSequence getErrorMessage(MavenProject project, Dependency violatingDependency) {
        return "Banned scope '" + violatingDependency.getScope() + "' used on dependency '" + violatingDependency.getManagementKey() + "' @ " + BanDependencyManagementScope.formatLocation(project, violatingDependency.getLocation((Object)"")) + System.lineSeparator();
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public String toString() {
        return String.format("BanDependencyManagementScope[message=%s, excludes=%s, checkEffectivePom=%b]", this.getMessage(), this.excludes, this.checkEffectivePom);
    }
}

