/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

@Named(value="reactorModuleConvergence")
public final class ReactorModuleConvergence
extends AbstractStandardEnforcerRule {
    private static final String MODULE_TEXT = " module: ";
    private boolean ignoreModuleDependencies = false;
    private final MavenSession session;

    @Inject
    public ReactorModuleConvergence(MavenSession session) {
        this.session = Objects.requireNonNull(session);
    }

    public void execute() throws EnforcerRuleException {
        List sortedProjects = this.session.getProjectDependencyGraph().getSortedProjects();
        if (sortedProjects != null && !sortedProjects.isEmpty()) {
            this.checkReactor(sortedProjects);
            this.checkParentsInReactor(sortedProjects);
            this.checkMissingParentsInReactor(sortedProjects);
            this.checkParentsPartOfTheReactor(sortedProjects);
            if (!this.isIgnoreModuleDependencies()) {
                this.checkDependenciesWithinReactor(sortedProjects);
            }
        }
    }

    private void checkParentsPartOfTheReactor(List<MavenProject> sortedProjects) throws EnforcerRuleException {
        List<MavenProject> parentsWhichAreNotPartOfTheReactor = this.existParentsWhichAreNotPartOfTheReactor(sortedProjects);
        if (!parentsWhichAreNotPartOfTheReactor.isEmpty()) {
            StringBuilder sb = new StringBuilder().append(System.lineSeparator());
            this.addMessageIfExist(sb);
            for (MavenProject mavenProject : parentsWhichAreNotPartOfTheReactor) {
                sb.append(MODULE_TEXT);
                sb.append(mavenProject.getId());
                sb.append(System.lineSeparator());
            }
            throw new EnforcerRuleException("Module parents have been found which could not be found in the reactor." + sb);
        }
    }

    private void checkMissingParentsInReactor(List<MavenProject> sortedProjects) throws EnforcerRuleException {
        List<MavenProject> modulesWithoutParentsInReactor = this.existModulesWithoutParentsInReactor(sortedProjects);
        if (!modulesWithoutParentsInReactor.isEmpty()) {
            StringBuilder sb = new StringBuilder().append(System.lineSeparator());
            this.addMessageIfExist(sb);
            for (MavenProject mavenProject : modulesWithoutParentsInReactor) {
                sb.append(MODULE_TEXT);
                sb.append(mavenProject.getId());
                sb.append(System.lineSeparator());
            }
            throw new EnforcerRuleException("Reactor contains modules without parents." + sb);
        }
    }

    private void checkDependenciesWithinReactor(List<MavenProject> sortedProjects) throws EnforcerRuleException {
        String reactorVersion = sortedProjects.get(0).getVersion();
        Map<MavenProject, List<Dependency>> areThereDependenciesWhichAreNotPartOfTheReactor = this.areThereDependenciesWhichAreNotPartOfTheReactor(reactorVersion, sortedProjects);
        if (!areThereDependenciesWhichAreNotPartOfTheReactor.isEmpty()) {
            StringBuilder sb = new StringBuilder().append(System.lineSeparator());
            this.addMessageIfExist(sb);
            for (Map.Entry<MavenProject, List<Dependency>> item : areThereDependenciesWhichAreNotPartOfTheReactor.entrySet()) {
                sb.append(MODULE_TEXT);
                sb.append(item.getKey().getId());
                sb.append(System.lineSeparator());
                for (Dependency dependency : item.getValue()) {
                    String id = dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion();
                    sb.append("    dependency: ");
                    sb.append(id);
                    sb.append(System.lineSeparator());
                }
            }
            throw new EnforcerRuleException("Reactor modules contains dependencies which do not reference the reactor." + sb);
        }
    }

    private void checkParentsInReactor(List<MavenProject> sortedProjects) throws EnforcerRuleException {
        String reactorVersion = sortedProjects.get(0).getVersion();
        List<MavenProject> areParentsFromTheReactor = this.areParentsFromTheReactor(reactorVersion, sortedProjects);
        if (!areParentsFromTheReactor.isEmpty()) {
            StringBuilder sb = new StringBuilder().append(System.lineSeparator());
            this.addMessageIfExist(sb);
            for (MavenProject mavenProject : areParentsFromTheReactor) {
                sb.append(" --> ");
                sb.append(mavenProject.getId());
                sb.append(" parent:");
                sb.append(mavenProject.getParent().getId());
                sb.append(System.lineSeparator());
            }
            throw new EnforcerRuleException("Reactor modules have parents which contain a wrong version." + sb);
        }
    }

    private void checkReactor(List<MavenProject> sortedProjects) throws EnforcerRuleException {
        List<MavenProject> consistenceCheckResult = this.isReactorVersionConsistent(sortedProjects);
        if (!consistenceCheckResult.isEmpty()) {
            StringBuilder sb = new StringBuilder().append(System.lineSeparator());
            this.addMessageIfExist(sb);
            for (MavenProject mavenProject : consistenceCheckResult) {
                sb.append(" --> ");
                sb.append(mavenProject.getId());
                sb.append(System.lineSeparator());
            }
            throw new EnforcerRuleException("The reactor contains different versions." + sb);
        }
    }

    private List<MavenProject> areParentsFromTheReactor(String reactorVersion, List<MavenProject> sortedProjects) {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (MavenProject mavenProject : sortedProjects) {
            MavenProject parent;
            this.getLog().debug((CharSequence)("Project: " + mavenProject.getId()));
            if (!this.hasParent(mavenProject) || mavenProject.isExecutionRoot() || reactorVersion.equals((parent = mavenProject.getParent()).getVersion())) continue;
            this.getLog().debug((CharSequence)("The project: " + mavenProject.getId() + " has a parent which version does not match the other elements in reactor"));
            result.add(mavenProject);
        }
        return result;
    }

    private List<MavenProject> existParentsWhichAreNotPartOfTheReactor(List<MavenProject> sortedProjects) {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (MavenProject mavenProject : sortedProjects) {
            MavenProject parent;
            this.getLog().debug((CharSequence)("Project: " + mavenProject.getId()));
            if (!this.hasParent(mavenProject) || mavenProject.isExecutionRoot() || this.isProjectPartOfTheReactor(parent = mavenProject.getParent(), sortedProjects)) continue;
            result.add(mavenProject);
        }
        return result;
    }

    private boolean isProjectPartOfTheReactor(MavenProject project, List<MavenProject> sortedProjects) {
        return this.isGAPartOfTheReactor(project.getGroupId(), project.getArtifactId(), sortedProjects);
    }

    private boolean isDependencyPartOfTheReactor(Dependency dependency, List<MavenProject> sortedProjects) {
        return this.isGAPartOfTheReactor(dependency.getGroupId(), dependency.getArtifactId(), sortedProjects);
    }

    private boolean isGAPartOfTheReactor(String groupId, String artifactId, List<MavenProject> sortedProjects) {
        boolean result = false;
        for (MavenProject mavenProject : sortedProjects) {
            String projectId;
            String parentId = groupId + ":" + artifactId;
            if (!parentId.equals(projectId = mavenProject.getGroupId() + ":" + mavenProject.getArtifactId())) continue;
            result = true;
        }
        return result;
    }

    private List<MavenProject> existModulesWithoutParentsInReactor(List<MavenProject> sortedProjects) {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (MavenProject mavenProject : sortedProjects) {
            this.getLog().debug((CharSequence)("Project: " + mavenProject.getId()));
            if (this.hasParent(mavenProject)) continue;
            if (mavenProject.isExecutionRoot()) {
                this.getLog().debug((CharSequence)"The root does not need having a parent.");
                continue;
            }
            this.getLog().debug((CharSequence)("The module: " + mavenProject.getId() + " has no parent."));
            result.add(mavenProject);
        }
        return result;
    }

    private void addDep(Map<MavenProject, List<Dependency>> result, MavenProject project, Dependency dependency) {
        if (result.containsKey(project)) {
            List<Dependency> list = result.get(project);
            if (list == null) {
                list = new ArrayList<Dependency>();
            }
            list.add(dependency);
            result.put(project, list);
        } else {
            ArrayList<Dependency> list = new ArrayList<Dependency>();
            list.add(dependency);
            result.put(project, list);
        }
    }

    private Map<MavenProject, List<Dependency>> areThereDependenciesWhichAreNotPartOfTheReactor(String reactorVersion, List<MavenProject> sortedProjects) {
        HashMap<MavenProject, List<Dependency>> result = new HashMap<MavenProject, List<Dependency>>();
        for (MavenProject mavenProject : sortedProjects) {
            this.getLog().debug((CharSequence)("Project: " + mavenProject.getId()));
            List dependencies = mavenProject.getDependencies();
            if (!this.hasDependencies(dependencies)) continue;
            for (Dependency dependency : dependencies) {
                this.getLog().debug((CharSequence)(" -> Dep:" + dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion()));
                if (!this.isDependencyPartOfTheReactor(dependency, sortedProjects) || dependency.getVersion().equals(reactorVersion)) continue;
                this.addDep(result, mavenProject, dependency);
            }
        }
        return result;
    }

    private List<MavenProject> isReactorVersionConsistent(List<MavenProject> projectList) {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        if (projectList != null && !projectList.isEmpty()) {
            String version = projectList.get(0).getVersion();
            this.getLog().debug((CharSequence)("First version:" + version));
            for (MavenProject mavenProject : projectList) {
                this.getLog().debug((CharSequence)(" -> checking " + mavenProject.getId()));
                if (version.equals(mavenProject.getVersion())) continue;
                result.add(mavenProject);
            }
        }
        return result;
    }

    private boolean hasDependencies(List<Dependency> dependencies) {
        return dependencies != null && !dependencies.isEmpty();
    }

    private boolean hasParent(MavenProject mavenProject) {
        return mavenProject.getParent() != null;
    }

    public boolean isIgnoreModuleDependencies() {
        return this.ignoreModuleDependencies;
    }

    private void addMessageIfExist(StringBuilder sb) {
        if (!StringUtils.isEmpty((String)this.getMessage())) {
            sb.append(this.getMessage());
            sb.append(System.lineSeparator());
        }
    }

    public String getCacheId() {
        return String.valueOf(this.toString().hashCode());
    }

    public String toString() {
        return String.format("ReactorModuleConvergence[message=%s, ignoreModuleDependencies=%b]", this.getMessage(), this.ignoreModuleDependencies);
    }
}

