/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules;

import java.util.List;
import javax.inject.Named;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;

@Named(value="requireJavaVendor")
public final class RequireJavaVendor
extends AbstractStandardEnforcerRule {
    private List<String> includes;
    private List<String> excludes;

    public String getCacheId() {
        String result = "";
        if (this.includes != null) {
            result = result + "" + this.includes.hashCode();
        }
        if (this.excludes != null) {
            result = result + "" + this.excludes.hashCode();
        }
        if (this.getMessage() != null) {
            result = result + "" + this.getMessage().hashCode();
        }
        return result;
    }

    public void execute() throws EnforcerRuleException {
        if (this.excludes != null && this.excludes.contains(SystemUtils.JAVA_VENDOR)) {
            String message = this.getMessage();
            if (message == null) {
                message = String.format("%s is an excluded Required Java Vendor (detected JDK: %s)", SystemUtils.JAVA_VENDOR, SystemUtils.JAVA_HOME);
            }
            throw new EnforcerRuleException(message);
        }
        if (this.includes != null && !this.includes.contains(SystemUtils.JAVA_VENDOR)) {
            String message = this.getMessage();
            if (message == null) {
                message = String.format("%s is not an included Required Java Vendor (detected JDK: %s)", SystemUtils.JAVA_VENDOR, SystemUtils.JAVA_HOME);
            }
            throw new EnforcerRuleException(message);
        }
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public String toString() {
        return String.format("RequireJavaVendor[message=%s, includes=%s, excludes=%s]", this.getMessage(), this.includes, this.excludes);
    }
}

