/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.files;

import java.io.File;
import java.util.Collections;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.files.AbstractRequireFiles;
import org.apache.maven.project.MavenProject;

@Named(value="requireFilesSize")
public final class RequireFilesSize
extends AbstractRequireFiles {
    private static final long MAXSIZE = 10000L;
    private long maxsize = 10000L;
    private long minsize = 0L;
    private boolean recursive = false;
    private String errorMsg;
    private final MavenProject project;

    @Inject
    public RequireFilesSize(MavenProject project) {
        this.project = Objects.requireNonNull(project);
    }

    @Override
    public void execute() throws EnforcerRuleException {
        if (this.getFiles().isEmpty()) {
            this.setFilesList(Collections.singletonList(this.project.getArtifact().getFile()));
            super.execute();
        } else {
            super.execute();
        }
    }

    @Override
    public String getCacheId() {
        return null;
    }

    @Override
    boolean checkFile(File file) {
        if (file == null) {
            return true;
        }
        if (file.exists()) {
            long length = this.computeLength(file);
            if (length < this.minsize) {
                this.errorMsg = file + " size (" + length + ") too small. Min. is " + this.minsize;
                return false;
            }
            if (length > this.maxsize) {
                this.errorMsg = file + " size (" + length + ") too large. Max. is " + this.maxsize;
                return false;
            }
            this.getLog().debug(() -> file + " size (" + length + ") is OK (" + (this.minsize == this.maxsize || this.minsize == 0L ? "max. " + this.maxsize : "between " + this.minsize + " and " + this.maxsize) + " byte).");
            return true;
        }
        this.errorMsg = file + " does not exist!";
        return false;
    }

    private long computeLength(File file) {
        File[] files = file.listFiles();
        long length = file.length();
        if (files == null || !this.recursive) {
            return length;
        }
        for (File child : files) {
            length += this.computeLength(child);
        }
        return length;
    }

    @Override
    String getErrorMsg() {
        return this.errorMsg;
    }

    public void setMaxsize(long maxsize) {
        this.maxsize = maxsize;
    }

    public void setMinsize(long minsize) {
        this.minsize = minsize;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }
}

