/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.version;

import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;
import org.apache.maven.enforcer.rules.utils.ArtifactMatcher;

abstract class AbstractVersionEnforcer
extends AbstractStandardEnforcerRule {
    private String version;

    AbstractVersionEnforcer() {
    }

    public void enforceVersion(String variableName, String requiredVersionRange, ArtifactVersion actualVersion) throws EnforcerRuleException {
        if (requiredVersionRange == null || requiredVersionRange.isEmpty()) {
            throw new EnforcerRuleException(variableName + " version can't be empty.");
        }
        String msg = "Detected " + variableName + " Version: " + actualVersion;
        if (actualVersion.toString().equals(requiredVersionRange)) {
            this.getLog().debug((CharSequence)(msg + " is allowed in the range " + requiredVersionRange + "."));
        } else {
            try {
                VersionRange versionRange = VersionRange.createFromVersionSpec((String)requiredVersionRange);
                if (!ArtifactMatcher.containsVersion(versionRange, actualVersion)) {
                    String message = this.getMessage();
                    if (message == null || message.isEmpty()) {
                        message = msg + " is not in the allowed range " + AbstractVersionEnforcer.toString(versionRange) + ".";
                    }
                    throw new EnforcerRuleException(message);
                }
                this.getLog().debug((CharSequence)(msg + " is allowed in the range " + AbstractVersionEnforcer.toString(versionRange) + "."));
            }
            catch (InvalidVersionSpecificationException e) {
                throw new EnforcerRuleException("The requested " + variableName + " version " + requiredVersionRange + " is invalid.", (Exception)((Object)e));
            }
        }
    }

    protected static String toString(VersionRange versionRange) {
        if (versionRange.getRecommendedVersion() != null) {
            return "[" + versionRange.getRecommendedVersion().toString() + ",)";
        }
        return versionRange.toString();
    }

    public String getCacheId() {
        if (this.version != null && !this.version.isEmpty()) {
            return "" + this.version.hashCode();
        }
        return "0";
    }

    public final String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

