/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model;

import java.net.URI;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.services.model.ModelInterpolator;
import org.apache.maven.api.services.model.PathTranslator;
import org.apache.maven.api.services.model.RootLocator;
import org.apache.maven.api.services.model.UrlNormalizer;
import org.apache.maven.internal.impl.model.MavenBuildTimestamp;
import org.apache.maven.model.v4.MavenTransformer;
import org.codehaus.plexus.interpolation.AbstractDelegatingValueSource;
import org.codehaus.plexus.interpolation.AbstractValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedValueSourceWrapper;
import org.codehaus.plexus.interpolation.QueryEnabledValueSource;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.interpolation.reflection.ReflectionValueExtractor;
import org.codehaus.plexus.interpolation.util.ValueSourceUtils;

@Named
@Singleton
public class DefaultModelInterpolator
implements ModelInterpolator {
    private static final String PREFIX_PROJECT = "project.";
    private static final String PREFIX_POM = "pom.";
    private static final List<String> PROJECT_PREFIXES_3_1 = Arrays.asList("pom.", "project.");
    private static final List<String> PROJECT_PREFIXES_4_0 = Collections.singletonList("project.");
    private static final Collection<String> TRANSLATED_PATH_EXPRESSIONS;
    private final PathTranslator pathTranslator;
    private final UrlNormalizer urlNormalizer;
    private final RootLocator rootLocator;

    @Inject
    public DefaultModelInterpolator(PathTranslator pathTranslator, UrlNormalizer urlNormalizer, RootLocator rootLocator) {
        this.pathTranslator = pathTranslator;
        this.urlNormalizer = urlNormalizer;
        this.rootLocator = rootLocator;
    }

    @Override
    public Model interpolateModel(Model model, Path projectDir, ModelBuilderRequest request, ModelProblemCollector problems) {
        List<ValueSource> valueSources = this.createValueSources(model, projectDir, request, problems);
        List<? extends InterpolationPostProcessor> postProcessors = this.createPostProcessors(model, projectDir, request);
        InnerInterpolator innerInterpolator = this.createInterpolator(valueSources, postProcessors, request, problems);
        return new MavenTransformer(innerInterpolator::interpolate).visit(model);
    }

    private InnerInterpolator createInterpolator(List<? extends ValueSource> valueSources, List<? extends InterpolationPostProcessor> postProcessors, ModelBuilderRequest request, ModelProblemCollector problems) {
        HashMap cache = new HashMap();
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.setCacheAnswers(true);
        for (ValueSource valueSource : valueSources) {
            interpolator.addValueSource(valueSource);
        }
        for (InterpolationPostProcessor interpolationPostProcessor : postProcessors) {
            interpolator.addPostProcessor(interpolationPostProcessor);
        }
        RecursionInterceptor recursionInterceptor = this.createRecursionInterceptor(request);
        return value -> {
            if (value != null && value.contains("${")) {
                String c = (String)cache.get(value);
                if (c == null) {
                    try {
                        c = interpolator.interpolate(value, recursionInterceptor);
                    }
                    catch (InterpolationException e) {
                        problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, e.getMessage(), (Exception)((Object)e));
                    }
                    cache.put(value, c);
                }
                return c;
            }
            return value;
        };
    }

    protected List<String> getProjectPrefixes(ModelBuilderRequest request) {
        return request.getValidationLevel() >= 40 ? PROJECT_PREFIXES_4_0 : PROJECT_PREFIXES_3_1;
    }

    protected List<ValueSource> createValueSources(Model model, final Path projectDir, final ModelBuilderRequest request, ModelProblemCollector problems) {
        Object prefixlessObjectBasedValueSource;
        Object projectPrefixValueSource;
        Map modelProperties = model.getProperties();
        if (request.getValidationLevel() >= 40) {
            projectPrefixValueSource = new PrefixedObjectValueSource(PROJECT_PREFIXES_4_0, model, false);
            prefixlessObjectBasedValueSource = new ObjectBasedValueSource(model);
        } else {
            projectPrefixValueSource = new PrefixedObjectValueSource(PROJECT_PREFIXES_3_1, model, false);
            if (request.getValidationLevel() >= 20) {
                projectPrefixValueSource = new ProblemDetectingValueSource((ValueSource)projectPrefixValueSource, PREFIX_POM, PREFIX_PROJECT, problems);
            }
            prefixlessObjectBasedValueSource = new ObjectBasedValueSource(model);
            if (request.getValidationLevel() >= 20) {
                prefixlessObjectBasedValueSource = new ProblemDetectingValueSource((ValueSource)prefixlessObjectBasedValueSource, "", PREFIX_PROJECT, problems);
            }
        }
        ArrayList<ValueSource> valueSources = new ArrayList<ValueSource>(9);
        if (projectDir != null) {
            PrefixedValueSourceWrapper basedirValueSource = new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

                public Object getValue(String expression) {
                    if ("basedir".equals(expression)) {
                        return projectDir.toAbsolutePath().toString();
                    }
                    if (expression.startsWith("basedir.")) {
                        Path basedir = projectDir.toAbsolutePath();
                        return new ObjectBasedValueSource(basedir).getValue(expression.substring("basedir.".length()));
                    }
                    return null;
                }
            }, this.getProjectPrefixes(request), true);
            valueSources.add((ValueSource)basedirValueSource);
            PrefixedValueSourceWrapper baseUriValueSource = new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

                public Object getValue(String expression) {
                    if ("baseUri".equals(expression)) {
                        return projectDir.toAbsolutePath().toUri().toASCIIString();
                    }
                    if (expression.startsWith("baseUri.")) {
                        URI baseUri = projectDir.toAbsolutePath().toUri();
                        return new ObjectBasedValueSource(baseUri).getValue(expression.substring("baseUri.".length()));
                    }
                    return null;
                }
            }, this.getProjectPrefixes(request), false);
            valueSources.add((ValueSource)baseUriValueSource);
            valueSources.add((ValueSource)new BuildTimestampValueSource(request.getSession().getStartTime(), modelProperties));
        }
        valueSources.add((ValueSource)new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                if ("rootDirectory".equals(expression)) {
                    Path root = DefaultModelInterpolator.this.rootLocator.findMandatoryRoot(projectDir);
                    return root.toFile().getPath();
                }
                if (expression.startsWith("rootDirectory.")) {
                    Path root = DefaultModelInterpolator.this.rootLocator.findMandatoryRoot(projectDir);
                    return new ObjectBasedValueSource(root).getValue(expression.substring("rootDirectory.".length()));
                }
                return null;
            }
        }, this.getProjectPrefixes(request)));
        valueSources.add((ValueSource)projectPrefixValueSource);
        valueSources.add((ValueSource)new MapBasedValueSource(request.getUserProperties()));
        valueSources.add((ValueSource)new MapBasedValueSource(modelProperties));
        valueSources.add((ValueSource)new MapBasedValueSource(request.getSystemProperties()));
        valueSources.add((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                return request.getSystemProperties().get("env." + expression);
            }
        });
        valueSources.add((ValueSource)prefixlessObjectBasedValueSource);
        return valueSources;
    }

    protected List<? extends InterpolationPostProcessor> createPostProcessors(Model model, Path projectDir, ModelBuilderRequest request) {
        ArrayList<Object> processors = new ArrayList<Object>(2);
        if (projectDir != null) {
            processors.add(new PathTranslatingPostProcessor(this.getProjectPrefixes(request), TRANSLATED_PATH_EXPRESSIONS, projectDir, this.pathTranslator));
        }
        processors.add(new UrlNormalizingPostProcessor(this.urlNormalizer));
        return processors;
    }

    protected RecursionInterceptor createRecursionInterceptor(ModelBuilderRequest request) {
        return new PrefixAwareRecursionInterceptor(this.getProjectPrefixes(request));
    }

    static {
        HashSet<String> translatedPrefixes = new HashSet<String>();
        translatedPrefixes.add("build.directory");
        translatedPrefixes.add("build.outputDirectory");
        translatedPrefixes.add("build.testOutputDirectory");
        translatedPrefixes.add("build.sourceDirectory");
        translatedPrefixes.add("build.testSourceDirectory");
        translatedPrefixes.add("build.scriptSourceDirectory");
        translatedPrefixes.add("reporting.outputDirectory");
        TRANSLATED_PATH_EXPRESSIONS = translatedPrefixes;
    }

    static interface InnerInterpolator {
        public String interpolate(String var1);
    }

    public static class PrefixedObjectValueSource
    extends AbstractDelegatingValueSource
    implements QueryEnabledValueSource {
        public PrefixedObjectValueSource(String prefix, Object root) {
            super((ValueSource)new PrefixedValueSourceWrapper((ValueSource)new ObjectBasedValueSource(root), prefix));
        }

        public PrefixedObjectValueSource(List<String> possiblePrefixes, Object root, boolean allowUnprefixedExpressions) {
            super((ValueSource)new PrefixedValueSourceWrapper((ValueSource)new ObjectBasedValueSource(root), possiblePrefixes, allowUnprefixedExpressions));
        }

        public String getLastExpression() {
            return ((QueryEnabledValueSource)this.getDelegate()).getLastExpression();
        }
    }

    public static class ObjectBasedValueSource
    extends AbstractValueSource {
        private final Object root;

        public ObjectBasedValueSource(Object root) {
            super(true);
            this.root = root;
        }

        public Object getValue(String expression) {
            if (expression == null || expression.trim().isEmpty()) {
                return null;
            }
            try {
                return ReflectionValueExtractor.evaluate((String)expression, (Object)this.root, (boolean)false);
            }
            catch (Exception e) {
                this.addFeedback("Failed to extract '" + expression + "' from: " + this.root, e);
                return null;
            }
        }
    }

    static class ProblemDetectingValueSource
    implements ValueSource {
        private final ValueSource valueSource;
        private final String bannedPrefix;
        private final String newPrefix;
        private final ModelProblemCollector problems;

        ProblemDetectingValueSource(ValueSource valueSource, String bannedPrefix, String newPrefix, ModelProblemCollector problems) {
            this.valueSource = valueSource;
            this.bannedPrefix = bannedPrefix;
            this.newPrefix = newPrefix;
            this.problems = problems;
        }

        public Object getValue(String expression) {
            Object value = this.valueSource.getValue(expression);
            if (value != null && expression.startsWith(this.bannedPrefix)) {
                String msg = "The expression ${" + expression + "} is deprecated.";
                if (this.newPrefix != null && !this.newPrefix.isEmpty()) {
                    msg = msg + " Please use ${" + this.newPrefix + expression.substring(this.bannedPrefix.length()) + "} instead.";
                }
                this.problems.add(BuilderProblem.Severity.WARNING, ModelProblem.Version.V20, msg);
            }
            return value;
        }

        public List getFeedback() {
            return this.valueSource.getFeedback();
        }

        public void clearFeedback() {
            this.valueSource.clearFeedback();
        }
    }

    static class BuildTimestampValueSource
    extends AbstractValueSource {
        private final Instant startTime;
        private final Map<String, String> properties;

        BuildTimestampValueSource(Instant startTime, Map<String, String> properties) {
            super(false);
            this.startTime = startTime;
            this.properties = properties;
        }

        public Object getValue(String expression) {
            if ("build.timestamp".equals(expression) || "maven.build.timestamp".equals(expression)) {
                return new MavenBuildTimestamp(this.startTime, this.properties).formattedTimestamp();
            }
            return null;
        }
    }

    static class PathTranslatingPostProcessor
    implements InterpolationPostProcessor {
        private final Collection<String> unprefixedPathKeys;
        private final Path projectDir;
        private final PathTranslator pathTranslator;
        private final List<String> expressionPrefixes;

        PathTranslatingPostProcessor(List<String> expressionPrefixes, Collection<String> unprefixedPathKeys, Path projectDir, PathTranslator pathTranslator) {
            this.expressionPrefixes = expressionPrefixes;
            this.unprefixedPathKeys = unprefixedPathKeys;
            this.projectDir = projectDir;
            this.pathTranslator = pathTranslator;
        }

        public Object execute(String expression, Object value) {
            if (value != null && this.unprefixedPathKeys.contains(expression = ValueSourceUtils.trimPrefix((String)expression, this.expressionPrefixes, (boolean)true))) {
                return this.pathTranslator.alignToBaseDirectory(String.valueOf(value), this.projectDir);
            }
            return null;
        }
    }

    static class UrlNormalizingPostProcessor
    implements InterpolationPostProcessor {
        private static final Set<String> URL_EXPRESSIONS;
        private final UrlNormalizer normalizer;

        UrlNormalizingPostProcessor(UrlNormalizer normalizer) {
            this.normalizer = normalizer;
        }

        public Object execute(String expression, Object value) {
            if (value != null && URL_EXPRESSIONS.contains(expression)) {
                return this.normalizer.normalize(value.toString());
            }
            return null;
        }

        static {
            HashSet<String> expressions = new HashSet<String>();
            expressions.add("project.url");
            expressions.add("project.scm.url");
            expressions.add("project.scm.connection");
            expressions.add("project.scm.developerConnection");
            expressions.add("project.distributionManagement.site.url");
            URL_EXPRESSIONS = expressions;
        }
    }
}

