/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.v4;

import com.ctc.wstx.stax.WstxOutputFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.ActivationFile;
import org.apache.maven.api.model.ActivationOS;
import org.apache.maven.api.model.ActivationProperty;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.BuildBase;
import org.apache.maven.api.model.CiManagement;
import org.apache.maven.api.model.ConfigurationContainer;
import org.apache.maven.api.model.Contributor;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.DeploymentRepository;
import org.apache.maven.api.model.Developer;
import org.apache.maven.api.model.DistributionManagement;
import org.apache.maven.api.model.Exclusion;
import org.apache.maven.api.model.Extension;
import org.apache.maven.api.model.FileSet;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.IssueManagement;
import org.apache.maven.api.model.License;
import org.apache.maven.api.model.MailingList;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.ModelBase;
import org.apache.maven.api.model.Notifier;
import org.apache.maven.api.model.Organization;
import org.apache.maven.api.model.Parent;
import org.apache.maven.api.model.PatternSet;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginConfiguration;
import org.apache.maven.api.model.PluginContainer;
import org.apache.maven.api.model.PluginExecution;
import org.apache.maven.api.model.PluginManagement;
import org.apache.maven.api.model.Prerequisites;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.model.Relocation;
import org.apache.maven.api.model.ReportPlugin;
import org.apache.maven.api.model.ReportSet;
import org.apache.maven.api.model.Reporting;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.model.RepositoryBase;
import org.apache.maven.api.model.RepositoryPolicy;
import org.apache.maven.api.model.Resource;
import org.apache.maven.api.model.Scm;
import org.apache.maven.api.model.Site;
import org.apache.maven.api.xml.XmlNode;
import org.codehaus.stax2.util.StreamWriterDelegate;

@Generated
public class MavenStaxWriter {
    private static final String NAMESPACE = "http://maven.apache.org/POM/4.0.0";
    private static final String SCHEMA_LOCATION = "https://maven.apache.org/xsd/maven-4.0.0.xsd";
    private String namespace = "http://maven.apache.org/POM/4.0.0";
    private String schemaLocation = "https://maven.apache.org/xsd/maven-4.0.0.xsd";
    private String fileComment = null;
    private boolean addLocationInformation = true;
    protected Function<InputLocation, String> stringFormatter;

    public void setNamespace(String namespace) {
        this.namespace = Objects.requireNonNull(namespace);
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = Objects.requireNonNull(schemaLocation);
    }

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void setAddLocationInformation(boolean addLocationInformation) {
        this.addLocationInformation = addLocationInformation;
    }

    public void setStringFormatter(Function<InputLocation, String> stringFormatter) {
        this.stringFormatter = stringFormatter;
    }

    public void write(Writer writer, Model model) throws IOException, XMLStreamException {
        WstxOutputFactory factory = new WstxOutputFactory();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", false);
        factory.setProperty("com.ctc.wstx.useDoubleQuotesInXmlDecl", true);
        factory.setProperty("com.ctc.wstx.addSpaceAfterEmptyElem", true);
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        serializer.writeStartDocument(model.getModelEncoding(), null);
        this.writeModel("project", model, (XMLStreamWriter)((Object)serializer));
        serializer.writeEndDocument();
    }

    public void write(OutputStream stream, Model model) throws IOException, XMLStreamException {
        WstxOutputFactory factory = new WstxOutputFactory();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", false);
        factory.setProperty("com.ctc.wstx.useDoubleQuotesInXmlDecl", true);
        factory.setProperty("com.ctc.wstx.addSpaceAfterEmptyElem", true);
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(stream, model.getModelEncoding()));
        serializer.writeStartDocument(model.getModelEncoding(), null);
        this.writeModel("project", model, (XMLStreamWriter)((Object)serializer));
        serializer.writeEndDocument();
    }

    private void writeModel(String tagName, Model model, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (model != null) {
            if (this.fileComment != null) {
                serializer.writeCharacters("\n");
                serializer.writeComment(this.fileComment);
                serializer.writeCharacters("\n");
            }
            serializer.writeStartElement("", tagName, this.namespace);
            serializer.writeNamespace("", this.namespace);
            serializer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", this.namespace + " " + this.schemaLocation);
            this.writeAttr("child.project.url.inherit.append.path", model.getChildProjectUrlInheritAppendPath(), serializer);
            this.writeAttr("root", model.isRoot() ? "true" : null, serializer);
            this.writeAttr("preserve.model.version", model.isPreserveModelVersion() ? "true" : null, serializer);
            this.writeTag("modelVersion", null, model.getModelVersion(), serializer, (InputLocationTracker)model);
            this.writeParent("parent", model.getParent(), serializer);
            this.writeTag("groupId", null, model.getGroupId(), serializer, (InputLocationTracker)model);
            this.writeTag("artifactId", null, model.getArtifactId(), serializer, (InputLocationTracker)model);
            this.writeTag("version", null, model.getVersion(), serializer, (InputLocationTracker)model);
            this.writeTag("packaging", "jar", model.getPackaging(), serializer, (InputLocationTracker)model);
            this.writeTag("name", null, model.getName(), serializer, (InputLocationTracker)model);
            this.writeTag("description", null, model.getDescription(), serializer, (InputLocationTracker)model);
            this.writeTag("url", null, model.getUrl(), serializer, (InputLocationTracker)model);
            this.writeTag("inceptionYear", null, model.getInceptionYear(), serializer, (InputLocationTracker)model);
            this.writeOrganization("organization", model.getOrganization(), serializer);
            this.writeList("licenses", false, model.getLicenses(), serializer, (InputLocationTracker)model, t -> this.writeLicense("license", (License)t, serializer));
            this.writeList("developers", false, model.getDevelopers(), serializer, (InputLocationTracker)model, t -> this.writeDeveloper("developer", (Developer)t, serializer));
            this.writeList("contributors", false, model.getContributors(), serializer, (InputLocationTracker)model, t -> this.writeContributor("contributor", (Contributor)t, serializer));
            this.writeList("mailingLists", false, model.getMailingLists(), serializer, (InputLocationTracker)model, t -> this.writeMailingList("mailingList", (MailingList)t, serializer));
            this.writePrerequisites("prerequisites", model.getPrerequisites(), serializer);
            this.writeList("modules", model.getModules(), serializer, (InputLocationTracker)model, t -> this.writeTag("module", null, (String)t, serializer, null));
            this.writeScm("scm", model.getScm(), serializer);
            this.writeIssueManagement("issueManagement", model.getIssueManagement(), serializer);
            this.writeCiManagement("ciManagement", model.getCiManagement(), serializer);
            this.writeDistributionManagement("distributionManagement", model.getDistributionManagement(), serializer);
            this.writeProperties("properties", model.getProperties(), serializer, (InputLocationTracker)model);
            this.writeDependencyManagement("dependencyManagement", model.getDependencyManagement(), serializer);
            this.writeList("dependencies", false, model.getDependencies(), serializer, (InputLocationTracker)model, t -> this.writeDependency("dependency", (Dependency)t, serializer));
            this.writeList("repositories", false, model.getRepositories(), serializer, (InputLocationTracker)model, t -> this.writeRepository("repository", (Repository)t, serializer));
            this.writeList("pluginRepositories", false, model.getPluginRepositories(), serializer, (InputLocationTracker)model, t -> this.writeRepository("pluginRepository", (Repository)t, serializer));
            this.writeBuild("build", model.getBuild(), serializer);
            this.writeReporting("reporting", model.getReporting(), serializer);
            this.writeList("profiles", false, model.getProfiles(), serializer, (InputLocationTracker)model, t -> this.writeProfile("profile", (Profile)t, serializer));
            serializer.writeEndElement();
        }
    }

    private void writeModelBase(String tagName, ModelBase modelBase, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (modelBase != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeList("modules", modelBase.getModules(), serializer, (InputLocationTracker)modelBase, t -> this.writeTag("module", null, (String)t, serializer, null));
            this.writeDistributionManagement("distributionManagement", modelBase.getDistributionManagement(), serializer);
            this.writeProperties("properties", modelBase.getProperties(), serializer, (InputLocationTracker)modelBase);
            this.writeDependencyManagement("dependencyManagement", modelBase.getDependencyManagement(), serializer);
            this.writeList("dependencies", false, modelBase.getDependencies(), serializer, (InputLocationTracker)modelBase, t -> this.writeDependency("dependency", (Dependency)t, serializer));
            this.writeList("repositories", false, modelBase.getRepositories(), serializer, (InputLocationTracker)modelBase, t -> this.writeRepository("repository", (Repository)t, serializer));
            this.writeList("pluginRepositories", false, modelBase.getPluginRepositories(), serializer, (InputLocationTracker)modelBase, t -> this.writeRepository("pluginRepository", (Repository)t, serializer));
            this.writeReporting("reporting", modelBase.getReporting(), serializer);
            serializer.writeEndElement();
        }
    }

    private void writePluginContainer(String tagName, PluginContainer pluginContainer, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (pluginContainer != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeList("plugins", false, pluginContainer.getPlugins(), serializer, (InputLocationTracker)pluginContainer, t -> this.writePlugin("plugin", (Plugin)t, serializer));
            serializer.writeEndElement();
        }
    }

    private void writePluginConfiguration(String tagName, PluginConfiguration pluginConfiguration, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (pluginConfiguration != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writePluginManagement("pluginManagement", pluginConfiguration.getPluginManagement(), serializer);
            this.writeList("plugins", false, pluginConfiguration.getPlugins(), serializer, (InputLocationTracker)pluginConfiguration, t -> this.writePlugin("plugin", (Plugin)t, serializer));
            serializer.writeEndElement();
        }
    }

    private void writeBuildBase(String tagName, BuildBase buildBase, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (buildBase != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("defaultGoal", null, buildBase.getDefaultGoal(), serializer, (InputLocationTracker)buildBase);
            this.writeList("resources", false, buildBase.getResources(), serializer, (InputLocationTracker)buildBase, t -> this.writeResource("resource", (Resource)t, serializer));
            this.writeList("testResources", false, buildBase.getTestResources(), serializer, (InputLocationTracker)buildBase, t -> this.writeResource("testResource", (Resource)t, serializer));
            this.writeTag("directory", null, buildBase.getDirectory(), serializer, (InputLocationTracker)buildBase);
            this.writeTag("finalName", null, buildBase.getFinalName(), serializer, (InputLocationTracker)buildBase);
            this.writeList("filters", buildBase.getFilters(), serializer, (InputLocationTracker)buildBase, t -> this.writeTag("filter", null, (String)t, serializer, null));
            this.writePluginManagement("pluginManagement", buildBase.getPluginManagement(), serializer);
            this.writeList("plugins", false, buildBase.getPlugins(), serializer, (InputLocationTracker)buildBase, t -> this.writePlugin("plugin", (Plugin)t, serializer));
            serializer.writeEndElement();
        }
    }

    private void writeBuild(String tagName, Build build, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (build != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("sourceDirectory", null, build.getSourceDirectory(), serializer, (InputLocationTracker)build);
            this.writeTag("scriptSourceDirectory", null, build.getScriptSourceDirectory(), serializer, (InputLocationTracker)build);
            this.writeTag("testSourceDirectory", null, build.getTestSourceDirectory(), serializer, (InputLocationTracker)build);
            this.writeTag("outputDirectory", null, build.getOutputDirectory(), serializer, (InputLocationTracker)build);
            this.writeTag("testOutputDirectory", null, build.getTestOutputDirectory(), serializer, (InputLocationTracker)build);
            this.writeList("extensions", false, build.getExtensions(), serializer, (InputLocationTracker)build, t -> this.writeExtension("extension", (Extension)t, serializer));
            this.writeTag("defaultGoal", null, build.getDefaultGoal(), serializer, (InputLocationTracker)build);
            this.writeList("resources", false, build.getResources(), serializer, (InputLocationTracker)build, t -> this.writeResource("resource", (Resource)t, serializer));
            this.writeList("testResources", false, build.getTestResources(), serializer, (InputLocationTracker)build, t -> this.writeResource("testResource", (Resource)t, serializer));
            this.writeTag("directory", null, build.getDirectory(), serializer, (InputLocationTracker)build);
            this.writeTag("finalName", null, build.getFinalName(), serializer, (InputLocationTracker)build);
            this.writeList("filters", build.getFilters(), serializer, (InputLocationTracker)build, t -> this.writeTag("filter", null, (String)t, serializer, null));
            this.writePluginManagement("pluginManagement", build.getPluginManagement(), serializer);
            this.writeList("plugins", false, build.getPlugins(), serializer, (InputLocationTracker)build, t -> this.writePlugin("plugin", (Plugin)t, serializer));
            serializer.writeEndElement();
        }
    }

    private void writeCiManagement(String tagName, CiManagement ciManagement, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (ciManagement != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("system", null, ciManagement.getSystem(), serializer, (InputLocationTracker)ciManagement);
            this.writeTag("url", null, ciManagement.getUrl(), serializer, (InputLocationTracker)ciManagement);
            this.writeList("notifiers", false, ciManagement.getNotifiers(), serializer, (InputLocationTracker)ciManagement, t -> this.writeNotifier("notifier", (Notifier)t, serializer));
            serializer.writeEndElement();
        }
    }

    private void writeNotifier(String tagName, Notifier notifier, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (notifier != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("type", "mail", notifier.getType(), serializer, (InputLocationTracker)notifier);
            this.writeTag("sendOnError", "true", notifier.isSendOnError() ? null : "false", serializer, (InputLocationTracker)notifier);
            this.writeTag("sendOnFailure", "true", notifier.isSendOnFailure() ? null : "false", serializer, (InputLocationTracker)notifier);
            this.writeTag("sendOnSuccess", "true", notifier.isSendOnSuccess() ? null : "false", serializer, (InputLocationTracker)notifier);
            this.writeTag("sendOnWarning", "true", notifier.isSendOnWarning() ? null : "false", serializer, (InputLocationTracker)notifier);
            this.writeTag("address", null, notifier.getAddress(), serializer, (InputLocationTracker)notifier);
            this.writeProperties("configuration", notifier.getConfiguration(), serializer, (InputLocationTracker)notifier);
            serializer.writeEndElement();
        }
    }

    private void writeContributor(String tagName, Contributor contributor, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (contributor != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("name", null, contributor.getName(), serializer, (InputLocationTracker)contributor);
            this.writeTag("email", null, contributor.getEmail(), serializer, (InputLocationTracker)contributor);
            this.writeTag("url", null, contributor.getUrl(), serializer, (InputLocationTracker)contributor);
            this.writeTag("organization", null, contributor.getOrganization(), serializer, (InputLocationTracker)contributor);
            this.writeTag("organizationUrl", null, contributor.getOrganizationUrl(), serializer, (InputLocationTracker)contributor);
            this.writeList("roles", contributor.getRoles(), serializer, (InputLocationTracker)contributor, t -> this.writeTag("role", null, (String)t, serializer, null));
            this.writeTag("timezone", null, contributor.getTimezone(), serializer, (InputLocationTracker)contributor);
            this.writeProperties("properties", contributor.getProperties(), serializer, (InputLocationTracker)contributor);
            serializer.writeEndElement();
        }
    }

    private void writeDependency(String tagName, Dependency dependency, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (dependency != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("groupId", null, dependency.getGroupId(), serializer, (InputLocationTracker)dependency);
            this.writeTag("artifactId", null, dependency.getArtifactId(), serializer, (InputLocationTracker)dependency);
            this.writeTag("version", null, dependency.getVersion(), serializer, (InputLocationTracker)dependency);
            this.writeTag("type", "jar", dependency.getType(), serializer, (InputLocationTracker)dependency);
            this.writeTag("classifier", null, dependency.getClassifier(), serializer, (InputLocationTracker)dependency);
            this.writeTag("scope", null, dependency.getScope(), serializer, (InputLocationTracker)dependency);
            this.writeTag("systemPath", null, dependency.getSystemPath(), serializer, (InputLocationTracker)dependency);
            this.writeList("exclusions", false, dependency.getExclusions(), serializer, (InputLocationTracker)dependency, t -> this.writeExclusion("exclusion", (Exclusion)t, serializer));
            this.writeTag("optional", null, dependency.getOptional(), serializer, (InputLocationTracker)dependency);
            serializer.writeEndElement();
        }
    }

    private void writeDeveloper(String tagName, Developer developer, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (developer != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("id", null, developer.getId(), serializer, (InputLocationTracker)developer);
            this.writeTag("name", null, developer.getName(), serializer, (InputLocationTracker)developer);
            this.writeTag("email", null, developer.getEmail(), serializer, (InputLocationTracker)developer);
            this.writeTag("url", null, developer.getUrl(), serializer, (InputLocationTracker)developer);
            this.writeTag("organization", null, developer.getOrganization(), serializer, (InputLocationTracker)developer);
            this.writeTag("organizationUrl", null, developer.getOrganizationUrl(), serializer, (InputLocationTracker)developer);
            this.writeList("roles", developer.getRoles(), serializer, (InputLocationTracker)developer, t -> this.writeTag("role", null, (String)t, serializer, null));
            this.writeTag("timezone", null, developer.getTimezone(), serializer, (InputLocationTracker)developer);
            this.writeProperties("properties", developer.getProperties(), serializer, (InputLocationTracker)developer);
            serializer.writeEndElement();
        }
    }

    private void writeExclusion(String tagName, Exclusion exclusion, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (exclusion != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("groupId", null, exclusion.getGroupId(), serializer, (InputLocationTracker)exclusion);
            this.writeTag("artifactId", null, exclusion.getArtifactId(), serializer, (InputLocationTracker)exclusion);
            serializer.writeEndElement();
        }
    }

    private void writeIssueManagement(String tagName, IssueManagement issueManagement, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (issueManagement != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("system", null, issueManagement.getSystem(), serializer, (InputLocationTracker)issueManagement);
            this.writeTag("url", null, issueManagement.getUrl(), serializer, (InputLocationTracker)issueManagement);
            serializer.writeEndElement();
        }
    }

    private void writeDistributionManagement(String tagName, DistributionManagement distributionManagement, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (distributionManagement != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeDeploymentRepository("repository", distributionManagement.getRepository(), serializer);
            this.writeDeploymentRepository("snapshotRepository", distributionManagement.getSnapshotRepository(), serializer);
            this.writeSite("site", distributionManagement.getSite(), serializer);
            this.writeTag("downloadUrl", null, distributionManagement.getDownloadUrl(), serializer, (InputLocationTracker)distributionManagement);
            this.writeRelocation("relocation", distributionManagement.getRelocation(), serializer);
            this.writeTag("status", null, distributionManagement.getStatus(), serializer, (InputLocationTracker)distributionManagement);
            serializer.writeEndElement();
        }
    }

    private void writeLicense(String tagName, License license, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (license != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("name", null, license.getName(), serializer, (InputLocationTracker)license);
            this.writeTag("url", null, license.getUrl(), serializer, (InputLocationTracker)license);
            this.writeTag("distribution", null, license.getDistribution(), serializer, (InputLocationTracker)license);
            this.writeTag("comments", null, license.getComments(), serializer, (InputLocationTracker)license);
            serializer.writeEndElement();
        }
    }

    private void writeMailingList(String tagName, MailingList mailingList, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (mailingList != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("name", null, mailingList.getName(), serializer, (InputLocationTracker)mailingList);
            this.writeTag("subscribe", null, mailingList.getSubscribe(), serializer, (InputLocationTracker)mailingList);
            this.writeTag("unsubscribe", null, mailingList.getUnsubscribe(), serializer, (InputLocationTracker)mailingList);
            this.writeTag("post", null, mailingList.getPost(), serializer, (InputLocationTracker)mailingList);
            this.writeTag("archive", null, mailingList.getArchive(), serializer, (InputLocationTracker)mailingList);
            this.writeList("otherArchives", mailingList.getOtherArchives(), serializer, (InputLocationTracker)mailingList, t -> this.writeTag("otherArchive", null, (String)t, serializer, null));
            serializer.writeEndElement();
        }
    }

    private void writeOrganization(String tagName, Organization organization, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (organization != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("name", null, organization.getName(), serializer, (InputLocationTracker)organization);
            this.writeTag("url", null, organization.getUrl(), serializer, (InputLocationTracker)organization);
            serializer.writeEndElement();
        }
    }

    private void writePatternSet(String tagName, PatternSet patternSet, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (patternSet != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeList("includes", patternSet.getIncludes(), serializer, (InputLocationTracker)patternSet, t -> this.writeTag("include", null, (String)t, serializer, null));
            this.writeList("excludes", patternSet.getExcludes(), serializer, (InputLocationTracker)patternSet, t -> this.writeTag("exclude", null, (String)t, serializer, null));
            serializer.writeEndElement();
        }
    }

    private void writeParent(String tagName, Parent parent, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (parent != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("groupId", null, parent.getGroupId(), serializer, (InputLocationTracker)parent);
            this.writeTag("artifactId", null, parent.getArtifactId(), serializer, (InputLocationTracker)parent);
            this.writeTag("version", null, parent.getVersion(), serializer, (InputLocationTracker)parent);
            this.writeTag("relativePath", "..", parent.getRelativePath(), serializer, (InputLocationTracker)parent);
            serializer.writeEndElement();
        }
    }

    private void writeScm(String tagName, Scm scm, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (scm != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeAttr("child.scm.connection.inherit.append.path", scm.getChildScmConnectionInheritAppendPath(), serializer);
            this.writeAttr("child.scm.developerConnection.inherit.append.path", scm.getChildScmDeveloperConnectionInheritAppendPath(), serializer);
            this.writeAttr("child.scm.url.inherit.append.path", scm.getChildScmUrlInheritAppendPath(), serializer);
            this.writeTag("connection", null, scm.getConnection(), serializer, (InputLocationTracker)scm);
            this.writeTag("developerConnection", null, scm.getDeveloperConnection(), serializer, (InputLocationTracker)scm);
            this.writeTag("tag", "HEAD", scm.getTag(), serializer, (InputLocationTracker)scm);
            this.writeTag("url", null, scm.getUrl(), serializer, (InputLocationTracker)scm);
            serializer.writeEndElement();
        }
    }

    private void writeFileSet(String tagName, FileSet fileSet, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (fileSet != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("directory", null, fileSet.getDirectory(), serializer, (InputLocationTracker)fileSet);
            this.writeList("includes", fileSet.getIncludes(), serializer, (InputLocationTracker)fileSet, t -> this.writeTag("include", null, (String)t, serializer, null));
            this.writeList("excludes", fileSet.getExcludes(), serializer, (InputLocationTracker)fileSet, t -> this.writeTag("exclude", null, (String)t, serializer, null));
            serializer.writeEndElement();
        }
    }

    private void writeResource(String tagName, Resource resource, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (resource != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("targetPath", null, resource.getTargetPath(), serializer, (InputLocationTracker)resource);
            this.writeTag("filtering", null, resource.getFiltering(), serializer, (InputLocationTracker)resource);
            this.writeTag("directory", null, resource.getDirectory(), serializer, (InputLocationTracker)resource);
            this.writeList("includes", resource.getIncludes(), serializer, (InputLocationTracker)resource, t -> this.writeTag("include", null, (String)t, serializer, null));
            this.writeList("excludes", resource.getExcludes(), serializer, (InputLocationTracker)resource, t -> this.writeTag("exclude", null, (String)t, serializer, null));
            serializer.writeEndElement();
        }
    }

    private void writeRepositoryBase(String tagName, RepositoryBase repositoryBase, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (repositoryBase != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("id", null, repositoryBase.getId(), serializer, (InputLocationTracker)repositoryBase);
            this.writeTag("name", null, repositoryBase.getName(), serializer, (InputLocationTracker)repositoryBase);
            this.writeTag("url", null, repositoryBase.getUrl(), serializer, (InputLocationTracker)repositoryBase);
            this.writeTag("layout", "default", repositoryBase.getLayout(), serializer, (InputLocationTracker)repositoryBase);
            serializer.writeEndElement();
        }
    }

    private void writeRepository(String tagName, Repository repository, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (repository != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeRepositoryPolicy("releases", repository.getReleases(), serializer);
            this.writeRepositoryPolicy("snapshots", repository.getSnapshots(), serializer);
            this.writeTag("id", null, repository.getId(), serializer, (InputLocationTracker)repository);
            this.writeTag("name", null, repository.getName(), serializer, (InputLocationTracker)repository);
            this.writeTag("url", null, repository.getUrl(), serializer, (InputLocationTracker)repository);
            this.writeTag("layout", "default", repository.getLayout(), serializer, (InputLocationTracker)repository);
            serializer.writeEndElement();
        }
    }

    private void writeDeploymentRepository(String tagName, DeploymentRepository deploymentRepository, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (deploymentRepository != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("uniqueVersion", "true", deploymentRepository.isUniqueVersion() ? null : "false", serializer, (InputLocationTracker)deploymentRepository);
            this.writeRepositoryPolicy("releases", deploymentRepository.getReleases(), serializer);
            this.writeRepositoryPolicy("snapshots", deploymentRepository.getSnapshots(), serializer);
            this.writeTag("id", null, deploymentRepository.getId(), serializer, (InputLocationTracker)deploymentRepository);
            this.writeTag("name", null, deploymentRepository.getName(), serializer, (InputLocationTracker)deploymentRepository);
            this.writeTag("url", null, deploymentRepository.getUrl(), serializer, (InputLocationTracker)deploymentRepository);
            this.writeTag("layout", "default", deploymentRepository.getLayout(), serializer, (InputLocationTracker)deploymentRepository);
            serializer.writeEndElement();
        }
    }

    private void writeRepositoryPolicy(String tagName, RepositoryPolicy repositoryPolicy, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (repositoryPolicy != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("enabled", null, repositoryPolicy.getEnabled(), serializer, (InputLocationTracker)repositoryPolicy);
            this.writeTag("updatePolicy", null, repositoryPolicy.getUpdatePolicy(), serializer, (InputLocationTracker)repositoryPolicy);
            this.writeTag("checksumPolicy", null, repositoryPolicy.getChecksumPolicy(), serializer, (InputLocationTracker)repositoryPolicy);
            serializer.writeEndElement();
        }
    }

    private void writeSite(String tagName, Site site, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (site != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeAttr("child.site.url.inherit.append.path", site.getChildSiteUrlInheritAppendPath(), serializer);
            this.writeTag("id", null, site.getId(), serializer, (InputLocationTracker)site);
            this.writeTag("name", null, site.getName(), serializer, (InputLocationTracker)site);
            this.writeTag("url", null, site.getUrl(), serializer, (InputLocationTracker)site);
            serializer.writeEndElement();
        }
    }

    private void writeConfigurationContainer(String tagName, ConfigurationContainer configurationContainer, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (configurationContainer != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("inherited", null, configurationContainer.getInherited(), serializer, (InputLocationTracker)configurationContainer);
            this.writeDom(configurationContainer.getConfiguration(), serializer);
            serializer.writeEndElement();
        }
    }

    private void writePlugin(String tagName, Plugin plugin, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (plugin != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("groupId", "org.apache.maven.plugins", plugin.getGroupId(), serializer, (InputLocationTracker)plugin);
            this.writeTag("artifactId", null, plugin.getArtifactId(), serializer, (InputLocationTracker)plugin);
            this.writeTag("version", null, plugin.getVersion(), serializer, (InputLocationTracker)plugin);
            this.writeTag("extensions", null, plugin.getExtensions(), serializer, (InputLocationTracker)plugin);
            this.writeList("executions", false, plugin.getExecutions(), serializer, (InputLocationTracker)plugin, t -> this.writePluginExecution("execution", (PluginExecution)t, serializer));
            this.writeList("dependencies", false, plugin.getDependencies(), serializer, (InputLocationTracker)plugin, t -> this.writeDependency("dependency", (Dependency)t, serializer));
            this.writeTag("inherited", null, plugin.getInherited(), serializer, (InputLocationTracker)plugin);
            this.writeDom(plugin.getConfiguration(), serializer);
            serializer.writeEndElement();
        }
    }

    private void writePluginExecution(String tagName, PluginExecution pluginExecution, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (pluginExecution != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("id", "default", pluginExecution.getId(), serializer, (InputLocationTracker)pluginExecution);
            this.writeTag("phase", null, pluginExecution.getPhase(), serializer, (InputLocationTracker)pluginExecution);
            this.writeTag("priority", "0", Integer.toString(pluginExecution.getPriority()), serializer, (InputLocationTracker)pluginExecution);
            this.writeList("goals", pluginExecution.getGoals(), serializer, (InputLocationTracker)pluginExecution, t -> this.writeTag("goal", null, (String)t, serializer, null));
            this.writeTag("inherited", null, pluginExecution.getInherited(), serializer, (InputLocationTracker)pluginExecution);
            this.writeDom(pluginExecution.getConfiguration(), serializer);
            serializer.writeEndElement();
        }
    }

    private void writeDependencyManagement(String tagName, DependencyManagement dependencyManagement, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (dependencyManagement != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeList("dependencies", false, dependencyManagement.getDependencies(), serializer, (InputLocationTracker)dependencyManagement, t -> this.writeDependency("dependency", (Dependency)t, serializer));
            serializer.writeEndElement();
        }
    }

    private void writePluginManagement(String tagName, PluginManagement pluginManagement, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (pluginManagement != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeList("plugins", false, pluginManagement.getPlugins(), serializer, (InputLocationTracker)pluginManagement, t -> this.writePlugin("plugin", (Plugin)t, serializer));
            serializer.writeEndElement();
        }
    }

    private void writeReporting(String tagName, Reporting reporting, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (reporting != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("excludeDefaults", null, reporting.getExcludeDefaults(), serializer, (InputLocationTracker)reporting);
            this.writeTag("outputDirectory", null, reporting.getOutputDirectory(), serializer, (InputLocationTracker)reporting);
            this.writeList("plugins", false, reporting.getPlugins(), serializer, (InputLocationTracker)reporting, t -> this.writeReportPlugin("plugin", (ReportPlugin)t, serializer));
            serializer.writeEndElement();
        }
    }

    private void writeProfile(String tagName, Profile profile, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (profile != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("id", "default", profile.getId(), serializer, (InputLocationTracker)profile);
            this.writeActivation("activation", profile.getActivation(), serializer);
            this.writeBuildBase("build", profile.getBuild(), serializer);
            this.writeList("modules", profile.getModules(), serializer, (InputLocationTracker)profile, t -> this.writeTag("module", null, (String)t, serializer, null));
            this.writeDistributionManagement("distributionManagement", profile.getDistributionManagement(), serializer);
            this.writeProperties("properties", profile.getProperties(), serializer, (InputLocationTracker)profile);
            this.writeDependencyManagement("dependencyManagement", profile.getDependencyManagement(), serializer);
            this.writeList("dependencies", false, profile.getDependencies(), serializer, (InputLocationTracker)profile, t -> this.writeDependency("dependency", (Dependency)t, serializer));
            this.writeList("repositories", false, profile.getRepositories(), serializer, (InputLocationTracker)profile, t -> this.writeRepository("repository", (Repository)t, serializer));
            this.writeList("pluginRepositories", false, profile.getPluginRepositories(), serializer, (InputLocationTracker)profile, t -> this.writeRepository("pluginRepository", (Repository)t, serializer));
            this.writeReporting("reporting", profile.getReporting(), serializer);
            serializer.writeEndElement();
        }
    }

    private void writeActivation(String tagName, Activation activation, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (activation != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("activeByDefault", "false", activation.isActiveByDefault() ? "true" : null, serializer, (InputLocationTracker)activation);
            this.writeTag("jdk", null, activation.getJdk(), serializer, (InputLocationTracker)activation);
            this.writeActivationOS("os", activation.getOs(), serializer);
            this.writeActivationProperty("property", activation.getProperty(), serializer);
            this.writeActivationFile("file", activation.getFile(), serializer);
            this.writeTag("packaging", null, activation.getPackaging(), serializer, (InputLocationTracker)activation);
            serializer.writeEndElement();
        }
    }

    private void writeActivationProperty(String tagName, ActivationProperty activationProperty, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (activationProperty != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("name", null, activationProperty.getName(), serializer, (InputLocationTracker)activationProperty);
            this.writeTag("value", null, activationProperty.getValue(), serializer, (InputLocationTracker)activationProperty);
            serializer.writeEndElement();
        }
    }

    private void writeActivationOS(String tagName, ActivationOS activationOS, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (activationOS != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("name", null, activationOS.getName(), serializer, (InputLocationTracker)activationOS);
            this.writeTag("family", null, activationOS.getFamily(), serializer, (InputLocationTracker)activationOS);
            this.writeTag("arch", null, activationOS.getArch(), serializer, (InputLocationTracker)activationOS);
            this.writeTag("version", null, activationOS.getVersion(), serializer, (InputLocationTracker)activationOS);
            serializer.writeEndElement();
        }
    }

    private void writeActivationFile(String tagName, ActivationFile activationFile, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (activationFile != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("missing", null, activationFile.getMissing(), serializer, (InputLocationTracker)activationFile);
            this.writeTag("exists", null, activationFile.getExists(), serializer, (InputLocationTracker)activationFile);
            serializer.writeEndElement();
        }
    }

    private void writeReportPlugin(String tagName, ReportPlugin reportPlugin, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (reportPlugin != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("groupId", "org.apache.maven.plugins", reportPlugin.getGroupId(), serializer, (InputLocationTracker)reportPlugin);
            this.writeTag("artifactId", null, reportPlugin.getArtifactId(), serializer, (InputLocationTracker)reportPlugin);
            this.writeTag("version", null, reportPlugin.getVersion(), serializer, (InputLocationTracker)reportPlugin);
            this.writeList("reportSets", false, reportPlugin.getReportSets(), serializer, (InputLocationTracker)reportPlugin, t -> this.writeReportSet("reportSet", (ReportSet)t, serializer));
            this.writeTag("inherited", null, reportPlugin.getInherited(), serializer, (InputLocationTracker)reportPlugin);
            this.writeDom(reportPlugin.getConfiguration(), serializer);
            serializer.writeEndElement();
        }
    }

    private void writeReportSet(String tagName, ReportSet reportSet, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (reportSet != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("id", "default", reportSet.getId(), serializer, (InputLocationTracker)reportSet);
            this.writeList("reports", reportSet.getReports(), serializer, (InputLocationTracker)reportSet, t -> this.writeTag("report", null, (String)t, serializer, null));
            this.writeTag("inherited", null, reportSet.getInherited(), serializer, (InputLocationTracker)reportSet);
            this.writeDom(reportSet.getConfiguration(), serializer);
            serializer.writeEndElement();
        }
    }

    private void writePrerequisites(String tagName, Prerequisites prerequisites, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (prerequisites != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("maven", "2.0", prerequisites.getMaven(), serializer, (InputLocationTracker)prerequisites);
            serializer.writeEndElement();
        }
    }

    private void writeRelocation(String tagName, Relocation relocation, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (relocation != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("groupId", null, relocation.getGroupId(), serializer, (InputLocationTracker)relocation);
            this.writeTag("artifactId", null, relocation.getArtifactId(), serializer, (InputLocationTracker)relocation);
            this.writeTag("version", null, relocation.getVersion(), serializer, (InputLocationTracker)relocation);
            this.writeTag("message", null, relocation.getMessage(), serializer, (InputLocationTracker)relocation);
            serializer.writeEndElement();
        }
    }

    private void writeExtension(String tagName, Extension extension, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (extension != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("groupId", null, extension.getGroupId(), serializer, (InputLocationTracker)extension);
            this.writeTag("artifactId", null, extension.getArtifactId(), serializer, (InputLocationTracker)extension);
            this.writeTag("version", null, extension.getVersion(), serializer, (InputLocationTracker)extension);
            this.writeDom(extension.getConfiguration(), serializer);
            serializer.writeEndElement();
        }
    }

    private <T> void writeList(String tagName, List<T> list, XMLStreamWriter serializer, InputLocationTracker locationTracker, ElementWriter<T> writer) throws IOException, XMLStreamException {
        this.writeList(tagName, false, list, serializer, locationTracker, writer);
    }

    private <T> void writeList(String tagName, boolean flat, List<T> list, XMLStreamWriter serializer, InputLocationTracker locationTracker, ElementWriter<T> writer) throws IOException, XMLStreamException {
        if (list != null && !list.isEmpty()) {
            if (!flat) {
                serializer.writeStartElement(this.namespace, tagName);
            }
            int index = 0;
            InputLocation location = locationTracker != null ? locationTracker.getLocation((Object)tagName) : null;
            for (T t : list) {
                writer.write(t);
                this.writeLocationTracking((InputLocationTracker)location, index++, serializer);
            }
            if (!flat) {
                serializer.writeEndElement();
            }
        }
    }

    private <T> void writeProperties(String tagName, Map<String, String> props, XMLStreamWriter serializer, InputLocationTracker locationTracker) throws IOException, XMLStreamException {
        if (props != null && !props.isEmpty()) {
            serializer.writeStartElement(this.namespace, tagName);
            InputLocation location = locationTracker != null ? locationTracker.getLocation((Object)tagName) : null;
            for (Map.Entry<String, String> entry : props.entrySet()) {
                String key = entry.getKey();
                this.writeTag(key, null, entry.getValue(), serializer, null);
                this.writeLocationTracking((InputLocationTracker)location, key, serializer);
            }
            serializer.writeEndElement();
        }
    }

    private void writeDom(XmlNode dom, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (dom != null) {
            serializer.writeStartElement(this.namespace, dom.getName());
            for (Map.Entry attr : dom.getAttributes().entrySet()) {
                if (((String)attr.getKey()).startsWith("xml:")) {
                    serializer.writeAttribute("http://www.w3.org/XML/1998/namespace", ((String)attr.getKey()).substring(4), (String)attr.getValue());
                    continue;
                }
                serializer.writeAttribute((String)attr.getKey(), (String)attr.getValue());
            }
            for (XmlNode child : dom.getChildren()) {
                this.writeDom(child, serializer);
            }
            String value = dom.getValue();
            if (value != null) {
                serializer.writeCharacters(value);
            }
            serializer.writeEndElement();
            if (this.addLocationInformation && dom.getInputLocation() instanceof InputLocation && dom.getChildren().isEmpty()) {
                serializer.writeComment(this.toString((InputLocation)dom.getInputLocation()));
            }
        }
    }

    private void writeTag(String tagName, String defaultValue, String value, XMLStreamWriter serializer, InputLocationTracker locationTracker) throws IOException, XMLStreamException {
        if (value != null && !Objects.equals(defaultValue, value)) {
            serializer.writeStartElement(this.namespace, tagName);
            serializer.writeCharacters(value);
            serializer.writeEndElement();
            this.writeLocationTracking(locationTracker, tagName, serializer);
        }
    }

    private void writeAttr(String attrName, String value, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (value != null) {
            serializer.writeAttribute(attrName, value);
        }
    }

    protected void writeLocationTracking(InputLocationTracker locationTracker, Object key, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (this.addLocationInformation) {
            InputLocation location;
            InputLocation inputLocation = location = locationTracker == null ? null : locationTracker.getLocation(key);
            if (location != null) {
                serializer.writeComment(this.toString(location));
            }
        }
    }

    protected String toString(InputLocation location) {
        if (this.stringFormatter != null) {
            return this.stringFormatter.apply(location);
        }
        if (location.getSource() != null) {
            return " " + location.getSource().toString() + ":" + location.getLineNumber() + " ";
        }
        return " " + location.getLineNumber() + " ";
    }

    static class IndentingXMLStreamWriter
    extends StreamWriterDelegate {
        int depth = 0;
        boolean hasChildren = false;

        public IndentingXMLStreamWriter(XMLStreamWriter parent) {
            super(parent);
        }

        public void writeEmptyElement(String localName) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(localName);
            this.hasChildren = true;
        }

        public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(namespaceURI, localName);
            this.hasChildren = true;
        }

        public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(prefix, localName, namespaceURI);
            this.hasChildren = true;
        }

        public void writeStartElement(String localName) throws XMLStreamException {
            this.indent();
            super.writeStartElement(localName);
            ++this.depth;
            this.hasChildren = false;
        }

        public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
            this.indent();
            super.writeStartElement(namespaceURI, localName);
            ++this.depth;
            this.hasChildren = false;
        }

        public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.indent();
            super.writeStartElement(prefix, localName, namespaceURI);
            ++this.depth;
            this.hasChildren = false;
        }

        public void writeEndElement() throws XMLStreamException {
            --this.depth;
            if (this.hasChildren) {
                this.indent();
            }
            super.writeEndElement();
            this.hasChildren = true;
        }

        private void indent() throws XMLStreamException {
            super.writeCharacters("\n");
            for (int i = 0; i < this.depth; ++i) {
                super.writeCharacters("  ");
            }
        }
    }

    @FunctionalInterface
    private static interface ElementWriter<T> {
        public void write(T var1) throws IOException, XMLStreamException;
    }
}

