/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;
import org.apache.maven.api.Dependency;
import org.apache.maven.api.PathScope;
import org.apache.maven.api.Project;
import org.apache.maven.api.Session;
import org.apache.maven.api.services.DependencyResolver;
import org.apache.maven.archiver.ManifestConfiguration;
import org.apache.maven.archiver.ManifestSection;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiverException;
import org.apache.maven.archiver.PomPropertiesUtil;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PrefixedPropertiesValueSource;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

public class MavenArchiver {
    private static final String CREATED_BY = "Maven Archiver";
    public static final String SIMPLE_LAYOUT = "${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}";
    public static final String REPOSITORY_LAYOUT = "${artifact.groupIdPath}/${artifact.artifactId}/${artifact.baseVersion}/${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}";
    public static final String SIMPLE_LAYOUT_NONUNIQUE = "${artifact.artifactId}-${artifact.baseVersion}${dashClassifier?}.${artifact.extension}";
    public static final String REPOSITORY_LAYOUT_NONUNIQUE = "${artifact.groupIdPath}/${artifact.artifactId}/${artifact.baseVersion}/${artifact.artifactId}-${artifact.baseVersion}${dashClassifier?}.${artifact.extension}";
    private static final Instant DATE_MIN = Instant.parse("1980-01-01T00:00:02Z");
    private static final Instant DATE_MAX = Instant.parse("2099-12-31T23:59:59Z");
    private static final List<String> ARTIFACT_EXPRESSION_PREFIXES;
    private JarArchiver archiver;
    private File archiveFile;
    private String createdBy;
    private boolean buildJdkSpecDefaultEntry = true;

    static boolean isValidModuleName(String name) {
        return SourceVersion.isName(name);
    }

    public Manifest getManifest(Session session, Project project, MavenArchiveConfiguration config) throws MavenArchiverException {
        boolean hasManifestEntries = !config.isManifestEntriesEmpty();
        Map<String, String> entries = hasManifestEntries ? config.getManifestEntries() : Collections.emptyMap();
        Manifest manifest = this.getManifest(session, project, config.getManifest(), entries);
        try {
            if (hasManifestEntries) {
                for (Map.Entry entry : entries.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    Manifest.ExistingAttribute attr = manifest.getMainSection().getAttribute(key);
                    if (key.equals(Attributes.Name.CLASS_PATH.toString()) && attr != null) {
                        attr.setValue(value + " " + attr.getValue());
                        continue;
                    }
                    this.addManifestAttribute(manifest, key, value);
                }
            }
            if (!config.isManifestSectionsEmpty()) {
                for (ManifestSection manifestSection : config.getManifestSections()) {
                    Manifest.Section theSection = new Manifest.Section();
                    theSection.setName(manifestSection.getName());
                    if (!manifestSection.isManifestEntriesEmpty()) {
                        Map<String, String> sectionEntries = manifestSection.getManifestEntries();
                        for (Map.Entry<String, String> entry : sectionEntries.entrySet()) {
                            String key = entry.getKey();
                            String value = entry.getValue();
                            Manifest.Attribute attr = new Manifest.Attribute(key, value);
                            theSection.addConfiguredAttribute(attr);
                        }
                    }
                    manifest.addConfiguredSection(theSection);
                }
            }
        }
        catch (ManifestException e) {
            throw new MavenArchiverException("Unable to create manifest", e);
        }
        return manifest;
    }

    public Manifest getManifest(Project project, ManifestConfiguration config) throws MavenArchiverException {
        return this.getManifest(null, project, config, Collections.emptyMap());
    }

    public Manifest getManifest(Session session, Project project, ManifestConfiguration config) throws MavenArchiverException {
        return this.getManifest(session, project, config, Collections.emptyMap());
    }

    private void addManifestAttribute(Manifest manifest, Map<String, String> map, String key, String value) throws ManifestException {
        if (map.containsKey(key)) {
            return;
        }
        this.addManifestAttribute(manifest, key, value);
    }

    private void addManifestAttribute(Manifest manifest, String key, String value) throws ManifestException {
        if (value != null && !value.isEmpty()) {
            Manifest.Attribute attr = new Manifest.Attribute(key, value);
            manifest.addConfiguredAttribute(attr);
        } else {
            Manifest.Attribute attr = new Manifest.Attribute(key, "");
            manifest.addConfiguredAttribute(attr);
        }
    }

    protected Manifest getManifest(Session session, Project project, ManifestConfiguration config, Map<String, String> entries) throws MavenArchiverException {
        try {
            return this.doGetManifest(session, project, config, entries);
        }
        catch (ManifestException e) {
            throw new MavenArchiverException("Unable to create manifest", e);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected Manifest doGetManifest(Session session, Project project, ManifestConfiguration config, Map<String, String> entries) throws ManifestException {
        m = new Manifest();
        if (config.isAddDefaultEntries()) {
            this.handleDefaultEntries(m, entries);
        }
        if (config.isAddBuildEnvironmentEntries()) {
            this.handleBuildEnvironmentEntries(session, m, entries);
        }
        result = config.isAddClasspath() != false || config.isAddExtensions() != false ? ((DependencyResolver)session.getService(DependencyResolver.class)).resolve(session, project, PathScope.MAIN_RUNTIME) : null;
        if (config.isAddClasspath()) {
            classpath = new StringBuilder();
            classpathPrefix = config.getClasspathPrefix();
            layoutType = config.getClasspathLayoutType();
            layout = config.getCustomClasspathLayout();
            interpolator = new StringSearchInterpolator();
lbl13:
            // 9 sources

            for (Map.Entry<K, V> entry : result.getDependencies().entrySet()) {
                artifactFile = (Path)entry.getValue();
                dependency = (Dependency)entry.getKey();
                if (!Files.isRegularFile(artifactFile.toAbsolutePath(), new LinkOption[0])) continue;
                if (!classpath.isEmpty()) {
                    classpath.append(" ");
                }
                classpath.append(classpathPrefix);
                if (dependency == null || layoutType == null) {
                    classpath.append(artifactFile.getFileName().toString());
                    continue;
                }
                valueSources = new ArrayList<ValueSource>();
                this.handleExtraExpression(dependency, valueSources);
                for (Object vs : valueSources) {
                    interpolator.addValueSource((ValueSource)vs);
                }
                recursionInterceptor = new PrefixAwareRecursionInterceptor(MavenArchiver.ARTIFACT_EXPRESSION_PREFIXES);
                try {
                    vs = layoutType;
                    var19_20 = -1;
                    switch (vs.hashCode()) {
                        case -902286926: {
                            if (!vs.equals("simple")) break;
                            var19_20 = 0;
                            break;
                        }
                        case 1950800714: {
                            if (!vs.equals("repository")) break;
                            var19_20 = 1;
                            break;
                        }
                        case -1349088399: {
                            if (!vs.equals("custom")) break;
                            var19_20 = 2;
                        }
                    }
                    switch (var19_20) {
                        case 0: {
                            if (config.isUseUniqueVersions()) {
                                classpath.append(interpolator.interpolate("${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}", (RecursionInterceptor)recursionInterceptor));
                                ** break;
                            }
                            classpath.append(interpolator.interpolate("${artifact.artifactId}-${artifact.baseVersion}${dashClassifier?}.${artifact.extension}", (RecursionInterceptor)recursionInterceptor));
                            ** break;
                        }
                        case 1: {
                            if (config.isUseUniqueVersions()) {
                                classpath.append(interpolator.interpolate("${artifact.groupIdPath}/${artifact.artifactId}/${artifact.baseVersion}/${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}", (RecursionInterceptor)recursionInterceptor));
                                ** break;
                            }
                            classpath.append(interpolator.interpolate("${artifact.groupIdPath}/${artifact.artifactId}/${artifact.baseVersion}/${artifact.artifactId}-${artifact.baseVersion}${dashClassifier?}.${artifact.extension}", (RecursionInterceptor)recursionInterceptor));
                            ** break;
                        }
                        case 2: {
                            if (layout == null) {
                                throw new ManifestException("custom layout type was declared, but custom layout expression was not specified. Check your <archive><manifest><customLayout/> element.");
                            }
                            classpath.append(interpolator.interpolate(layout, (RecursionInterceptor)recursionInterceptor));
                            ** break;
                        }
                        default: {
                            throw new ManifestException("Unknown classpath layout type: '" + layoutType + "'. Check your <archive><manifest><layoutType/> element.");
                        }
                    }
                }
                catch (InterpolationException e) {
                    error = new ManifestException("Error interpolating artifact path for classpath entry: " + e.getMessage());
                    error.initCause((Throwable)e);
                    throw error;
                }
                finally {
                    for (ValueSource vs : valueSources) {
                        interpolator.removeValuesSource(vs);
                    }
                }
            }
            if (!classpath.isEmpty()) {
                this.addManifestAttribute(m, "Class-Path", classpath.toString());
            }
        }
        if (config.isAddDefaultSpecificationEntries()) {
            this.handleSpecificationEntries(project, entries, m);
        }
        if (config.isAddDefaultImplementationEntries()) {
            this.handleImplementationEntries(project, entries, m);
        }
        if ((mainClass = config.getMainClass()) != null && !mainClass.isEmpty()) {
            this.addManifestAttribute(m, entries, "Main-Class", mainClass);
        }
        this.addCustomEntries(m, entries, config);
        return m;
    }

    private void handleExtraExpression(Dependency dependency, List<ValueSource> valueSources) {
        valueSources.add((ValueSource)new PrefixedObjectValueSource(ARTIFACT_EXPRESSION_PREFIXES, (Object)dependency, true));
        valueSources.add((ValueSource)new PrefixedObjectValueSource(ARTIFACT_EXPRESSION_PREFIXES, (Object)dependency.getType(), true));
        Properties extraExpressions = new Properties();
        if (!dependency.isSnapshot()) {
            extraExpressions.setProperty("baseVersion", dependency.getVersion().toString());
        }
        extraExpressions.setProperty("groupIdPath", dependency.getGroupId().replace('.', '/'));
        String classifier = dependency.getClassifier();
        if (classifier != null && !classifier.isEmpty()) {
            extraExpressions.setProperty("dashClassifier", "-" + classifier);
            extraExpressions.setProperty("dashClassifier?", "-" + classifier);
        } else {
            extraExpressions.setProperty("dashClassifier", "");
            extraExpressions.setProperty("dashClassifier?", "");
        }
        valueSources.add((ValueSource)new PrefixedPropertiesValueSource(ARTIFACT_EXPRESSION_PREFIXES, extraExpressions, true));
    }

    private void handleImplementationEntries(Project project, Map<String, String> entries, Manifest m) throws ManifestException {
        this.addManifestAttribute(m, entries, "Implementation-Title", project.getModel().getName());
        this.addManifestAttribute(m, entries, "Implementation-Version", project.getVersion());
        if (project.getModel().getOrganization() != null) {
            this.addManifestAttribute(m, entries, "Implementation-Vendor", project.getModel().getOrganization().getName());
        }
    }

    private void handleSpecificationEntries(Project project, Map<String, String> entries, Manifest m) throws ManifestException {
        this.addManifestAttribute(m, entries, "Specification-Title", project.getModel().getName());
        String version = project.getPomArtifact().getVersion().toString();
        Matcher matcher = Pattern.compile("([0-9]+\\.[0-9]+)(.*?)").matcher(version);
        if (matcher.matches()) {
            String specVersion = matcher.group(1);
            this.addManifestAttribute(m, entries, "Specification-Version", specVersion);
        }
        if (project.getModel().getOrganization() != null) {
            this.addManifestAttribute(m, entries, "Specification-Vendor", project.getModel().getOrganization().getName());
        }
    }

    private void addCustomEntries(Manifest m, Map<String, String> entries, ManifestConfiguration config) throws ManifestException {
        if (config.getPackageName() != null) {
            this.addManifestAttribute(m, entries, "Package", config.getPackageName());
        }
    }

    public JarArchiver getArchiver() {
        return this.archiver;
    }

    public void setArchiver(JarArchiver archiver) {
        this.archiver = archiver;
    }

    public void setOutputFile(File outputFile) {
        this.archiveFile = outputFile;
    }

    public void createArchive(Session session, Project project, MavenArchiveConfiguration archiveConfiguration) throws MavenArchiverException {
        try {
            this.doCreateArchive(session, project, archiveConfiguration);
        }
        catch (IOException | ManifestException e) {
            throw new MavenArchiverException(e);
        }
    }

    public void doCreateArchive(Session session, Project project, MavenArchiveConfiguration archiveConfiguration) throws ManifestException, IOException {
        String automaticModuleName;
        boolean forced = archiveConfiguration.isForced();
        if (archiveConfiguration.isAddMavenDescriptor()) {
            String groupId = project.getGroupId();
            String artifactId = project.getArtifactId();
            String version = project.getPomArtifact().isSnapshot() ? project.getPomArtifact().getVersion().toString() : project.getVersion();
            this.archiver.addFile(project.getPomPath().toFile(), "META-INF/maven/" + groupId + "/" + artifactId + "/pom.xml");
            Path customPomPropertiesFile = archiveConfiguration.getPomPropertiesFile();
            Path dir = Paths.get(project.getBuild().getDirectory(), "maven-archiver");
            Path pomPropertiesFile = dir.resolve("pom.properties");
            new PomPropertiesUtil().createPomProperties(session, groupId, artifactId, version, (Archiver)this.archiver, customPomPropertiesFile, pomPropertiesFile, forced);
        }
        this.archiver.setMinimalDefaultManifest(true);
        Path manifestFile = archiveConfiguration.getManifestFile();
        if (manifestFile != null) {
            this.archiver.setManifest(manifestFile.toFile());
        }
        Manifest manifest = this.getManifest(session, project, archiveConfiguration);
        this.archiver.addConfiguredManifest(manifest);
        this.archiver.setCompress(archiveConfiguration.isCompress());
        this.archiver.setRecompressAddedZips(archiveConfiguration.isRecompressAddedZips());
        this.archiver.setDestFile(this.archiveFile);
        this.archiver.setForced(forced);
        if (archiveConfiguration.isForced() || this.archiver.isSupportingForced()) {
            // empty if block
        }
        if ((automaticModuleName = manifest.getMainSection().getAttributeValue("Automatic-Module-Name")) != null && !MavenArchiver.isValidModuleName(automaticModuleName)) {
            throw new ManifestException("Invalid automatic module name: '" + automaticModuleName + "'");
        }
        this.archiver.createArchive();
    }

    private void handleDefaultEntries(Manifest m, Map<String, String> entries) throws ManifestException {
        String createdBy = this.createdBy;
        if (createdBy == null) {
            createdBy = this.createdBy(CREATED_BY, "org.apache.maven", "maven-archiver");
        }
        this.addManifestAttribute(m, entries, "Created-By", createdBy);
        if (this.buildJdkSpecDefaultEntry) {
            this.addManifestAttribute(m, entries, "Build-Jdk-Spec", System.getProperty("java.specification.version"));
        }
    }

    private void handleBuildEnvironmentEntries(Session session, Manifest m, Map<String, String> entries) throws ManifestException {
        this.addManifestAttribute(m, entries, "Build-Tool", session != null ? (String)session.getSystemProperties().get("maven.build.version") : "Apache Maven");
        this.addManifestAttribute(m, entries, "Build-Jdk", String.format("%s (%s)", System.getProperty("java.version"), System.getProperty("java.vendor")));
        this.addManifestAttribute(m, entries, "Build-Os", String.format("%s (%s; %s)", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")));
    }

    private static String getCreatedByVersion(String groupId, String artifactId) {
        Properties properties = MavenArchiver.loadOptionalProperties(MavenArchiver.class.getResourceAsStream("/META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties"));
        return properties.getProperty("version");
    }

    private static Properties loadOptionalProperties(InputStream inputStream) {
        Properties properties = new Properties();
        if (inputStream != null) {
            try (InputStream in = inputStream;){
                properties.load(in);
            }
            catch (IOException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return properties;
    }

    public void setCreatedBy(String description, String groupId, String artifactId) {
        this.createdBy = this.createdBy(description, groupId, artifactId);
    }

    private String createdBy(String description, String groupId, String artifactId) {
        Object createdBy = description;
        String version = MavenArchiver.getCreatedByVersion(groupId, artifactId);
        if (version != null) {
            createdBy = (String)createdBy + " " + version;
        }
        return createdBy;
    }

    public void setBuildJdkSpecDefaultEntry(boolean buildJdkSpecDefaultEntry) {
        this.buildJdkSpecDefaultEntry = buildJdkSpecDefaultEntry;
    }

    public static Optional<Instant> parseBuildOutputTimestamp(String outputTimestamp) {
        if (outputTimestamp == null) {
            return Optional.empty();
        }
        if (MavenArchiver.isNumeric(outputTimestamp)) {
            return Optional.of(Instant.ofEpochSecond(Long.parseLong(outputTimestamp)));
        }
        if (outputTimestamp.length() < 2) {
            return Optional.empty();
        }
        try {
            Instant date = OffsetDateTime.parse(outputTimestamp).withOffsetSameInstant(ZoneOffset.UTC).truncatedTo(ChronoUnit.SECONDS).toInstant();
            if (date.isBefore(DATE_MIN) || date.isAfter(DATE_MAX)) {
                throw new IllegalArgumentException("'" + String.valueOf(date) + "' is not within the valid range " + String.valueOf(DATE_MIN) + " to " + String.valueOf(DATE_MAX));
            }
            return Optional.of(date);
        }
        catch (DateTimeParseException pe) {
            throw new IllegalArgumentException("Invalid project.build.outputTimestamp value '" + outputTimestamp + "'", pe);
        }
    }

    private static boolean isNumeric(String str) {
        if (str.isEmpty()) {
            return false;
        }
        for (char c : str.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public void configureReproducibleBuild(String outputTimestamp) {
        MavenArchiver.parseBuildOutputTimestamp(outputTimestamp).map(FileTime::from).ifPresent(modifiedTime -> this.getArchiver().configureReproducibleBuild(modifiedTime));
    }

    static {
        ArrayList<String> artifactExpressionPrefixes = new ArrayList<String>();
        artifactExpressionPrefixes.add("artifact.");
        ARTIFACT_EXPRESSION_PREFIXES = artifactExpressionPrefixes;
    }
}

