/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.deployer;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.transform.ArtifactTransformation;
import org.apache.maven.wagon.TransferFailedException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;

public class DefaultArtifactDeployer
extends AbstractLogEnabled
implements ArtifactDeployer {
    private WagonManager wagonManager;
    private List artifactTransformations;

    public void deploy(String basedir, String finalName, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        File source = null;
        String extension = artifact.getArtifactHandler().getExtension();
        source = new File(basedir, finalName + "." + extension);
        this.deploy(source, artifact, deploymentRepository, localRepository);
    }

    public void deploy(File source, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        try {
            Iterator i = this.artifactTransformations.iterator();
            while (i.hasNext()) {
                ArtifactTransformation transform = (ArtifactTransformation)i.next();
                transform.transformForDeployment(artifact, deploymentRepository);
            }
            File artifactFile = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
            if (!artifactFile.equals(source)) {
                FileUtils.copyFile((File)source, (File)artifactFile);
            }
            this.wagonManager.putArtifact(source, artifact, deploymentRepository);
            Iterator i2 = artifact.getMetadataList().iterator();
            while (i2.hasNext()) {
                ArtifactMetadata metadata = (ArtifactMetadata)i2.next();
                metadata.storeInLocalRepository(localRepository);
                File f = new File(localRepository.getBasedir(), localRepository.pathOfMetadata(metadata));
                this.wagonManager.putArtifactMetadata(f, metadata, deploymentRepository);
            }
        }
        catch (TransferFailedException e) {
            throw new ArtifactDeploymentException("Error deploying artifact: ", (Throwable)e);
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new ArtifactDeploymentException("Error deploying artifact: ", (Throwable)e);
        }
        catch (IOException e) {
            throw new ArtifactDeploymentException("Error deploying artifact: ", (Throwable)e);
        }
    }
}

