/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.metadata;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.AbstractVersionArtifactMetadata;
import org.codehaus.plexus.util.StringUtils;

public class SnapshotArtifactMetadata
extends AbstractVersionArtifactMetadata {
    private String timestamp = null;
    private int buildNumber = 0;
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final String UTC_TIMESTAMP_PATTERN = "yyyyMMdd.HHmmss";
    public static final Pattern VERSION_FILE_PATTERN = Pattern.compile("^(.*)-([0-9]{8}.[0-9]{6})-([0-9]+)$");
    private static String sessionTimestamp = null;

    public SnapshotArtifactMetadata(Artifact artifact) {
        super(artifact, artifact.getArtifactId() + "-" + artifact.getBaseVersion() + "." + "version.txt");
    }

    public String constructVersion() {
        String version = this.artifact.getBaseVersion();
        if (this.timestamp != null && this.buildNumber > 0) {
            String newVersion = this.timestamp + "-" + this.buildNumber;
            version = version != null ? StringUtils.replace((String)version, (String)"SNAPSHOT", (String)newVersion) : newVersion;
        }
        return version;
    }

    protected void setContent(String content) {
        Matcher matcher = VERSION_FILE_PATTERN.matcher(content);
        if (matcher.matches()) {
            this.timestamp = matcher.group(2);
            this.buildNumber = Integer.valueOf(matcher.group(3));
        } else {
            this.timestamp = null;
            this.buildNumber = 0;
        }
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public static DateFormat getUtcDateFormatter() {
        SimpleDateFormat utcDateFormatter = new SimpleDateFormat(UTC_TIMESTAMP_PATTERN);
        utcDateFormatter.setTimeZone(UTC_TIME_ZONE);
        return utcDateFormatter;
    }

    public void update() {
        ++this.buildNumber;
        this.timestamp = SnapshotArtifactMetadata.getSessionTimestamp();
    }

    private static String getSessionTimestamp() {
        if (sessionTimestamp == null) {
            sessionTimestamp = SnapshotArtifactMetadata.getUtcDateFormatter().format(new Date());
        }
        return sessionTimestamp;
    }

    public int compareTo(Object o) {
        SnapshotArtifactMetadata metadata = (SnapshotArtifactMetadata)((Object)o);
        if (this.buildNumber > metadata.buildNumber) {
            return 1;
        }
        if (this.timestamp == null) {
            if (metadata.timestamp == null) {
                return 0;
            }
            return -1;
        }
        if (metadata.timestamp == null) {
            return 1;
        }
        return this.timestamp.compareTo(metadata.timestamp);
    }

    public boolean newerThanFile(File file) {
        long fileTime = file.lastModified();
        if (this.timestamp != null) {
            String fileTimestamp = SnapshotArtifactMetadata.getUtcDateFormatter().format(new Date(fileTime));
            return fileTimestamp.compareTo(this.timestamp) < 0;
        }
        return false;
    }

    public String toString() {
        return "snapshot information for " + this.artifact.getArtifactId() + " " + this.artifact.getBaseVersion();
    }
}

