/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.wagon.repository.Repository;

public class DefaultArtifactRepository
extends Repository
implements ArtifactRepository {
    private final String snapshotPolicy;
    private final String checksumPolicy;
    private final ArtifactRepositoryLayout layout;

    public DefaultArtifactRepository(String id, String url, ArtifactRepositoryLayout layout) {
        this(id, url, layout, "never", "warn");
    }

    public DefaultArtifactRepository(String id, String url, ArtifactRepositoryLayout layout, String snapshotPolicy, String checksumPolicy) {
        super(id, url);
        this.layout = layout;
        this.snapshotPolicy = snapshotPolicy;
        this.checksumPolicy = checksumPolicy;
    }

    public String pathOf(Artifact artifact) {
        return this.layout.pathOf(artifact);
    }

    public String pathOfMetadata(ArtifactMetadata artifactMetadata) {
        return this.layout.pathOfMetadata(artifactMetadata);
    }

    public String getSnapshotPolicy() {
        return this.snapshotPolicy;
    }

    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public boolean failOnChecksumMismatch() {
        return "fail".equals(this.checksumPolicy);
    }
}

