/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository;

import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;

public class DefaultArtifactRepositoryFactory
implements ArtifactRepositoryFactory {
    private String globalSnapshotPolicy = null;
    private String globalChecksumPolicy = null;

    public ArtifactRepository createArtifactRepository(String id, String url, ArtifactRepositoryLayout repositoryLayout, String snapshotPolicy, String checksumPolicy) {
        DefaultArtifactRepository repo = null;
        String snapPolicy = snapshotPolicy;
        if (this.globalSnapshotPolicy != null) {
            snapPolicy = this.globalSnapshotPolicy;
        }
        if (snapPolicy == null) {
            snapPolicy = "never";
        }
        String csumPolicy = checksumPolicy;
        if (this.globalChecksumPolicy != null) {
            csumPolicy = this.globalChecksumPolicy;
        }
        if (csumPolicy == null) {
            csumPolicy = "warn";
        }
        repo = new DefaultArtifactRepository(id, url, repositoryLayout, snapPolicy, csumPolicy);
        return repo;
    }

    public void setGlobalSnapshotPolicy(String snapshotPolicy) {
        this.globalSnapshotPolicy = snapshotPolicy;
    }

    public void setGlobalChecksumPolicy(String checksumPolicy) {
        this.globalChecksumPolicy = checksumPolicy;
    }
}

