/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.DebugResolutionListener;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.transform.ArtifactTransformation;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class DefaultArtifactResolver
extends AbstractLogEnabled
implements ArtifactResolver {
    private WagonManager wagonManager;
    private List artifactTransformations;
    protected ArtifactFactory artifactFactory;
    private ArtifactCollector artifactCollector;

    public void resolve(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException {
        if (artifact == null) {
            return;
        }
        String localPath = localRepository.pathOf(artifact);
        artifact.setFile(new File(localRepository.getBasedir(), localPath));
        Iterator i = this.artifactTransformations.iterator();
        while (i.hasNext()) {
            ArtifactTransformation transform = (ArtifactTransformation)i.next();
            try {
                transform.transformForResolve(artifact, remoteRepositories, localRepository);
            }
            catch (ArtifactMetadataRetrievalException e) {
                throw new ArtifactResolutionException(e.getMessage(), artifact, remoteRepositories, (Throwable)e);
            }
        }
        File destination = artifact.getFile();
        if (!destination.exists()) {
            try {
                if (artifact.getRepository() != null) {
                    this.wagonManager.getArtifact(artifact, artifact.getRepository(), destination);
                } else {
                    this.wagonManager.getArtifact(artifact, remoteRepositories, destination);
                }
                Iterator i2 = artifact.getMetadataList().iterator();
                while (i2.hasNext()) {
                    ArtifactMetadata metadata = (ArtifactMetadata)i2.next();
                    metadata.storeInLocalRepository(localRepository);
                }
            }
            catch (ResourceDoesNotExistException e) {
                throw new ArtifactResolutionException(e.getMessage(), artifact, remoteRepositories, (Throwable)e);
            }
            catch (TransferFailedException e) {
                throw new ArtifactResolutionException(e.getMessage(), artifact, remoteRepositories, (Throwable)e);
            }
            catch (ArtifactMetadataRetrievalException e) {
                throw new ArtifactResolutionException(e.getMessage(), artifact, remoteRepositories, (Throwable)e);
            }
        }
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter) throws ArtifactResolutionException {
        return this.resolveTransitively(artifacts, originatingArtifact, Collections.EMPTY_MAP, localRepository, remoteRepositories, source, filter);
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source) throws ArtifactResolutionException {
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, null);
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter) throws ArtifactResolutionException {
        ArrayList<DebugResolutionListener> listeners = new ArrayList<DebugResolutionListener>();
        if (this.getLogger().isDebugEnabled()) {
            listeners.add(new DebugResolutionListener(this.getLogger()));
        }
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, filter, listeners);
    }

    private ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List listeners) throws ArtifactResolutionException {
        ArtifactResolutionResult artifactResolutionResult = this.artifactCollector.collect(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, filter, this.artifactFactory, listeners);
        Iterator i = artifactResolutionResult.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            this.resolve(artifact, remoteRepositories, localRepository);
        }
        return artifactResolutionResult;
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, List remoteRepositories, ArtifactRepository localRepository, ArtifactMetadataSource source) throws ArtifactResolutionException {
        return this.resolveTransitively(artifacts, originatingArtifact, localRepository, remoteRepositories, source, null);
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, List remoteRepositories, ArtifactRepository localRepository, ArtifactMetadataSource source, List listeners) throws ArtifactResolutionException {
        return this.resolveTransitively(artifacts, originatingArtifact, Collections.EMPTY_MAP, localRepository, remoteRepositories, source, null, listeners);
    }
}

