/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.transform;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.SnapshotArtifactMetadata;
import org.apache.maven.artifact.metadata.VersionArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.transform.AbstractVersionTransformation;
import org.apache.maven.wagon.ResourceDoesNotExistException;

public class SnapshotTransformation
extends AbstractVersionTransformation {
    public static final String SNAPSHOT_VERSION = "SNAPSHOT";

    public void transformForResolve(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactMetadataRetrievalException {
        Matcher m = SnapshotArtifactMetadata.VERSION_FILE_PATTERN.matcher(artifact.getBaseVersion());
        if (m.matches()) {
            artifact.setBaseVersion(m.group(1) + "-" + SNAPSHOT_VERSION);
        } else if (SnapshotTransformation.isSnapshot(artifact)) {
            String version = this.resolveVersion(artifact, localRepository, remoteRepositories);
            artifact.updateVersion(version, localRepository);
        }
    }

    public void transformForInstall(Artifact artifact, ArtifactRepository localRepository) throws ArtifactMetadataRetrievalException {
        Matcher m = SnapshotArtifactMetadata.VERSION_FILE_PATTERN.matcher(artifact.getBaseVersion());
        if (m.matches()) {
            artifact.setBaseVersion(m.group(1) + "-" + SNAPSHOT_VERSION);
        } else if (SnapshotTransformation.isSnapshot(artifact)) {
            SnapshotArtifactMetadata metadata = new SnapshotArtifactMetadata(artifact);
            metadata.storeInLocalRepository(localRepository);
        }
    }

    public void transformForDeployment(Artifact artifact, ArtifactRepository remoteRepository) throws ArtifactMetadataRetrievalException {
        Matcher m = SnapshotArtifactMetadata.VERSION_FILE_PATTERN.matcher(artifact.getBaseVersion());
        if (m.matches()) {
            artifact.setBaseVersion(m.group(1) + "-" + SNAPSHOT_VERSION);
        } else if (SnapshotTransformation.isSnapshot(artifact)) {
            SnapshotArtifactMetadata metadata = null;
            metadata = (SnapshotArtifactMetadata)this.retrieveFromRemoteRepository(artifact, remoteRepository, null);
            metadata.update();
            artifact.setVersion(metadata.constructVersion());
            artifact.addMetadata((ArtifactMetadata)metadata);
        }
    }

    private static boolean isSnapshot(Artifact artifact) {
        return artifact.getVersion().endsWith(SNAPSHOT_VERSION);
    }

    protected VersionArtifactMetadata retrieveFromRemoteRepository(Artifact artifact, ArtifactRepository remoteRepository, VersionArtifactMetadata localMetadata) throws ArtifactMetadataRetrievalException {
        SnapshotArtifactMetadata metadata = new SnapshotArtifactMetadata(artifact);
        try {
            metadata.retrieveFromRemoteRepository(remoteRepository, this.wagonManager);
        }
        catch (ResourceDoesNotExistException e) {
            // empty catch block
        }
        return metadata;
    }

    protected VersionArtifactMetadata readFromLocalRepository(Artifact artifact, ArtifactRepository localRepository) throws IOException {
        SnapshotArtifactMetadata metadata = new SnapshotArtifactMetadata(artifact);
        metadata.readFromLocalRepository(localRepository);
        return metadata;
    }
}

