package org.apache.maven.artifact.manager;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.maven.wagon.TransferFailedException;

/**
 * Occurs when a download checksum fails.
 *
 * @author <a href="mailto:brett@apache.org">Brett Porter</a>
 * @version $Id: ChecksumFailedException.java 191634 2005-06-21 06:49:49Z brett $
 */
public class ChecksumFailedException extends TransferFailedException
{
    public ChecksumFailedException( String s )
    {
        super( s );
    }
    
    public ChecksumFailedException( String message, Throwable cause )
    {
        super( message, cause );
    }
}
