/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.layout;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;

public class DefaultRepositoryLayout
implements ArtifactRepositoryLayout {
    public String pathOf(Artifact artifact) {
        ArtifactHandler artifactHandler = artifact.getArtifactHandler();
        StringBuffer path = new StringBuffer();
        path.append(artifact.getGroupId().replace('.', '/')).append('/');
        path.append(artifact.getArtifactId()).append('/');
        path.append(artifact.getBaseVersion()).append('/');
        path.append(artifact.getArtifactId()).append('-').append(artifact.getVersion());
        if (artifact.hasClassifier()) {
            path.append('-').append(artifact.getClassifier());
        }
        if (artifactHandler.getExtension() != null && artifactHandler.getExtension().length() > 0) {
            path.append('.').append(artifactHandler.getExtension());
        }
        return path.toString();
    }

    public String pathOfMetadata(ArtifactMetadata metadata) {
        StringBuffer path = new StringBuffer();
        path.append(metadata.getGroupId().replace('.', '/')).append('/');
        path.append(metadata.getArtifactId()).append('/');
        if (!metadata.getBaseVersion().equals("RELEASE")) {
            path.append(metadata.getBaseVersion()).append('/');
        }
        path.append(metadata.getFilename());
        return path.toString();
    }
}

