/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ReactorModelPool;
import org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;

class ProjectModelResolver
implements ModelResolver {
    private final RepositorySystemSession session;
    private final RequestTrace trace;
    private final String context = "project";
    private List<RemoteRepository> repositories;
    private List<RemoteRepository> pomRepositories;
    private final List<RemoteRepository> externalRepositories;
    private final RepositorySystem resolver;
    private final RemoteRepositoryManager remoteRepositoryManager;
    private final Set<String> repositoryIds;
    private final ReactorModelPool modelPool;
    private final ProjectBuildingRequest.RepositoryMerging repositoryMerging;

    public ProjectModelResolver(RepositorySystemSession session, RequestTrace trace, RepositorySystem resolver, RemoteRepositoryManager remoteRepositoryManager, List<RemoteRepository> repositories, ProjectBuildingRequest.RepositoryMerging repositoryMerging, ReactorModelPool modelPool) {
        this.session = session;
        this.trace = trace;
        this.resolver = resolver;
        this.remoteRepositoryManager = remoteRepositoryManager;
        this.pomRepositories = new ArrayList<RemoteRepository>();
        this.externalRepositories = repositories;
        this.repositories = repositories;
        this.repositoryMerging = repositoryMerging;
        this.repositoryIds = new HashSet<String>();
        this.modelPool = modelPool;
    }

    private ProjectModelResolver(ProjectModelResolver original) {
        this.session = original.session;
        this.trace = original.trace;
        this.resolver = original.resolver;
        this.remoteRepositoryManager = original.remoteRepositoryManager;
        this.pomRepositories = original.pomRepositories;
        this.externalRepositories = original.externalRepositories;
        this.repositories = original.repositories;
        this.repositoryMerging = original.repositoryMerging;
        this.repositoryIds = new HashSet<String>(original.repositoryIds);
        this.modelPool = original.modelPool;
    }

    public void addRepository(Repository repository) throws InvalidRepositoryException {
        if (!this.repositoryIds.add(repository.getId())) {
            return;
        }
        List<RemoteRepository> newRepositories = Collections.singletonList(ArtifactDescriptorUtils.toRemoteRepository((Repository)repository));
        if (ProjectBuildingRequest.RepositoryMerging.REQUEST_DOMINANT.equals((Object)this.repositoryMerging)) {
            this.repositories = this.remoteRepositoryManager.aggregateRepositories(this.session, this.repositories, newRepositories, true);
        } else {
            this.pomRepositories = this.remoteRepositoryManager.aggregateRepositories(this.session, this.pomRepositories, newRepositories, true);
            this.repositories = this.remoteRepositoryManager.aggregateRepositories(this.session, this.pomRepositories, this.externalRepositories, false);
        }
    }

    public ModelResolver newCopy() {
        return new ProjectModelResolver(this);
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        File pomFile = null;
        if (this.modelPool != null) {
            pomFile = this.modelPool.get(groupId, artifactId, version);
        }
        if (pomFile == null) {
            DefaultArtifact pomArtifact = new DefaultArtifact(groupId, artifactId, "", "pom", version);
            try {
                ArtifactRequest request = new ArtifactRequest((Artifact)pomArtifact, this.repositories, "project");
                request.setTrace(this.trace);
                pomArtifact = this.resolver.resolveArtifact(this.session, request).getArtifact();
            }
            catch (ArtifactResolutionException e) {
                throw new UnresolvableModelException(e.getMessage(), groupId, artifactId, version, (Throwable)e);
            }
            pomFile = pomArtifact.getFile();
        }
        return new FileModelSource(pomFile);
    }
}

