/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.model.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import org.apache.maven.lifecycle.model.BuildBinding;
import org.apache.maven.lifecycle.model.CleanBinding;
import org.apache.maven.lifecycle.model.LifecycleBinding;
import org.apache.maven.lifecycle.model.LifecycleBindings;
import org.apache.maven.lifecycle.model.MojoBinding;
import org.apache.maven.lifecycle.model.Phase;
import org.apache.maven.lifecycle.model.SiteBinding;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class LifecycleBindingsXpp3Reader {
    private boolean addDefaultEntities = true;

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    public boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    public boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    public byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, null);
                }
            }
        }
        return 0;
    }

    public char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    public Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    public Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            if (dateFormat == null) {
                return new Date(Long.valueOf(s));
            }
            SimpleDateFormat dateParser = new SimpleDateFormat(dateFormat, Locale.US);
            try {
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage());
            }
        }
        return null;
    }

    public double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, null);
                }
            }
        }
        return 0.0;
    }

    public float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, null);
                }
            }
        }
        return 0.0f;
    }

    public int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, null);
                }
            }
        }
        return 0;
    }

    public long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, null);
                }
            }
        }
        return 0L;
    }

    public String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    public short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, null);
                }
            }
        }
        return 0;
    }

    public String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private BuildBinding parseBuildBinding(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        BuildBinding buildBinding = new BuildBinding();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("validate")) {
                if (parsed.contains("validate")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("validate");
                buildBinding.setValidate(this.parsePhase("validate", parser, strict));
                continue;
            }
            if (parser.getName().equals("initialize")) {
                if (parsed.contains("initialize")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("initialize");
                buildBinding.setInitialize(this.parsePhase("initialize", parser, strict));
                continue;
            }
            if (parser.getName().equals("generate-sources")) {
                if (parsed.contains("generate-sources")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("generate-sources");
                buildBinding.setGenerateSources(this.parsePhase("generate-sources", parser, strict));
                continue;
            }
            if (parser.getName().equals("process-sources")) {
                if (parsed.contains("process-sources")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("process-sources");
                buildBinding.setProcessSources(this.parsePhase("process-sources", parser, strict));
                continue;
            }
            if (parser.getName().equals("generate-resources")) {
                if (parsed.contains("generate-resources")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("generate-resources");
                buildBinding.setGenerateResources(this.parsePhase("generate-resources", parser, strict));
                continue;
            }
            if (parser.getName().equals("process-resources")) {
                if (parsed.contains("process-resources")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("process-resources");
                buildBinding.setProcessResources(this.parsePhase("process-resources", parser, strict));
                continue;
            }
            if (parser.getName().equals("compile")) {
                if (parsed.contains("compile")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("compile");
                buildBinding.setCompile(this.parsePhase("compile", parser, strict));
                continue;
            }
            if (parser.getName().equals("process-classes")) {
                if (parsed.contains("process-classes")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("process-classes");
                buildBinding.setProcessClasses(this.parsePhase("process-classes", parser, strict));
                continue;
            }
            if (parser.getName().equals("generate-test-sources")) {
                if (parsed.contains("generate-test-sources")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("generate-test-sources");
                buildBinding.setGenerateTestSources(this.parsePhase("generate-test-sources", parser, strict));
                continue;
            }
            if (parser.getName().equals("process-test-sources")) {
                if (parsed.contains("process-test-sources")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("process-test-sources");
                buildBinding.setProcessTestSources(this.parsePhase("process-test-sources", parser, strict));
                continue;
            }
            if (parser.getName().equals("generate-test-resources")) {
                if (parsed.contains("generate-test-resources")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("generate-test-resources");
                buildBinding.setGenerateTestResources(this.parsePhase("generate-test-resources", parser, strict));
                continue;
            }
            if (parser.getName().equals("process-test-resources")) {
                if (parsed.contains("process-test-resources")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("process-test-resources");
                buildBinding.setProcessTestResources(this.parsePhase("process-test-resources", parser, strict));
                continue;
            }
            if (parser.getName().equals("test-compile")) {
                if (parsed.contains("test-compile")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("test-compile");
                buildBinding.setTestCompile(this.parsePhase("test-compile", parser, strict));
                continue;
            }
            if (parser.getName().equals("process-test-classes")) {
                if (parsed.contains("process-test-classes")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("process-test-classes");
                buildBinding.setProcessTestClasses(this.parsePhase("process-test-classes", parser, strict));
                continue;
            }
            if (parser.getName().equals("test")) {
                if (parsed.contains("test")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("test");
                buildBinding.setTest(this.parsePhase("test", parser, strict));
                continue;
            }
            if (parser.getName().equals("prepare-package")) {
                if (parsed.contains("prepare-package")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("prepare-package");
                buildBinding.setPreparePackage(this.parsePhase("prepare-package", parser, strict));
                continue;
            }
            if (parser.getName().equals("package")) {
                if (parsed.contains("package")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("package");
                buildBinding.setCreatePackage(this.parsePhase("package", parser, strict));
                continue;
            }
            if (parser.getName().equals("pre-integration-test")) {
                if (parsed.contains("pre-integration-test")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("pre-integration-test");
                buildBinding.setPreIntegrationTest(this.parsePhase("pre-integration-test", parser, strict));
                continue;
            }
            if (parser.getName().equals("integration-test")) {
                if (parsed.contains("integration-test")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("integration-test");
                buildBinding.setIntegrationTest(this.parsePhase("integration-test", parser, strict));
                continue;
            }
            if (parser.getName().equals("post-integration-test")) {
                if (parsed.contains("post-integration-test")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("post-integration-test");
                buildBinding.setPostIntegrationTest(this.parsePhase("post-integration-test", parser, strict));
                continue;
            }
            if (parser.getName().equals("verify")) {
                if (parsed.contains("verify")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("verify");
                buildBinding.setVerify(this.parsePhase("verify", parser, strict));
                continue;
            }
            if (parser.getName().equals("install")) {
                if (parsed.contains("install")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("install");
                buildBinding.setInstall(this.parsePhase("install", parser, strict));
                continue;
            }
            if (parser.getName().equals("deploy")) {
                if (parsed.contains("deploy")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("deploy");
                buildBinding.setDeploy(this.parsePhase("deploy", parser, strict));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return buildBinding;
    }

    private CleanBinding parseCleanBinding(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        CleanBinding cleanBinding = new CleanBinding();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("pre-clean")) {
                if (parsed.contains("pre-clean")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("pre-clean");
                cleanBinding.setPreClean(this.parsePhase("pre-clean", parser, strict));
                continue;
            }
            if (parser.getName().equals("clean")) {
                if (parsed.contains("clean")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("clean");
                cleanBinding.setClean(this.parsePhase("clean", parser, strict));
                continue;
            }
            if (parser.getName().equals("post-clean")) {
                if (parsed.contains("post-clean")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("post-clean");
                cleanBinding.setPostClean(this.parsePhase("post-clean", parser, strict));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return cleanBinding;
    }

    private LifecycleBinding parseLifecycleBinding(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        LifecycleBinding lifecycleBinding = new LifecycleBinding();
        HashSet parsed = new HashSet();
        while (parser.nextTag() == 2) {
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return lifecycleBinding;
    }

    private LifecycleBindings parseLifecycleBindings(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        LifecycleBindings lifecycleBindings = new LifecycleBindings();
        HashSet<String> parsed = new HashSet<String>();
        int eventType = parser.getEventType();
        boolean foundRoot = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (parser.getName().equals(tagName)) {
                    foundRoot = true;
                } else if (parser.getName().equals("packaging")) {
                    if (parsed.contains("packaging")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("packaging");
                    lifecycleBindings.setPackaging(this.getTrimmedValue(parser.nextText()));
                } else if (parser.getName().equals("clean")) {
                    if (parsed.contains("clean")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("clean");
                    lifecycleBindings.setCleanBinding(this.parseCleanBinding("clean", parser, strict));
                } else if (parser.getName().equals("build")) {
                    if (parsed.contains("build")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("build");
                    lifecycleBindings.setBuildBinding(this.parseBuildBinding("build", parser, strict));
                } else if (parser.getName().equals("site")) {
                    if (parsed.contains("site")) {
                        throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                    }
                    parsed.add("site");
                    lifecycleBindings.setSiteBinding(this.parseSiteBinding("site", parser, strict));
                } else if (strict) {
                    throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
                }
            }
            eventType = parser.next();
        }
        return lifecycleBindings;
    }

    private MojoBinding parseMojoBinding(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        MojoBinding mojoBinding = new MojoBinding();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("groupId")) {
                if (parsed.contains("groupId")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("groupId");
                mojoBinding.setGroupId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("artifactId")) {
                if (parsed.contains("artifactId")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("artifactId");
                mojoBinding.setArtifactId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("version")) {
                if (parsed.contains("version")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("version");
                mojoBinding.setVersion(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("goal")) {
                if (parsed.contains("goal")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("goal");
                mojoBinding.setGoal(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("executionId")) {
                if (parsed.contains("executionId")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("executionId");
                mojoBinding.setExecutionId(this.getTrimmedValue(parser.nextText()));
                continue;
            }
            if (parser.getName().equals("configuration")) {
                if (parsed.contains("configuration")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("configuration");
                mojoBinding.setConfiguration(Xpp3DomBuilder.build((XmlPullParser)parser));
                continue;
            }
            if (parser.getName().equals("optional")) {
                if (parsed.contains("optional")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("optional");
                mojoBinding.setOptional(this.getBooleanValue(this.getTrimmedValue(parser.nextText()), "optional", parser, "false"));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return mojoBinding;
    }

    private Phase parsePhase(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Phase phase = new Phase();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("bindings")) {
                if (parsed.contains("bindings")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("bindings");
                ArrayList<MojoBinding> bindings = new ArrayList<MojoBinding>();
                phase.setBindings(bindings);
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("binding")) {
                        bindings.add(this.parseMojoBinding("binding", parser, strict));
                        continue;
                    }
                    if (strict) {
                        throw new XmlPullParserException("Unrecognised association: '" + parser.getName() + "'", parser, null);
                    }
                    while (parser.next() != 3) {
                    }
                }
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return phase;
    }

    private SiteBinding parseSiteBinding(String tagName, XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        SiteBinding siteBinding = new SiteBinding();
        HashSet<String> parsed = new HashSet<String>();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("pre-site")) {
                if (parsed.contains("pre-site")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("pre-site");
                siteBinding.setPreSite(this.parsePhase("pre-site", parser, strict));
                continue;
            }
            if (parser.getName().equals("site")) {
                if (parsed.contains("site")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("site");
                siteBinding.setSite(this.parsePhase("site", parser, strict));
                continue;
            }
            if (parser.getName().equals("post-site")) {
                if (parsed.contains("post-site")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("post-site");
                siteBinding.setPostSite(this.parsePhase("post-site", parser, strict));
                continue;
            }
            if (parser.getName().equals("site-deploy")) {
                if (parsed.contains("site-deploy")) {
                    throw new XmlPullParserException("Duplicated tag: '" + parser.getName() + "'", parser, null);
                }
                parsed.add("site-deploy");
                siteBinding.setSiteDeploy(this.parsePhase("site-deploy", parser, strict));
                continue;
            }
            if (strict) {
                throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
            }
            while (parser.next() != 3) {
            }
        }
        return siteBinding;
    }

    public LifecycleBindings read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = new MXParser();
        parser.setInput(reader);
        if (this.addDefaultEntities) {
            parser.defineEntityReplacementText("nbsp", "\u00a0");
            parser.defineEntityReplacementText("iexcl", "\u00a1");
            parser.defineEntityReplacementText("cent", "\u00a2");
            parser.defineEntityReplacementText("pound", "\u00a3");
            parser.defineEntityReplacementText("curren", "\u00a4");
            parser.defineEntityReplacementText("yen", "\u00a5");
            parser.defineEntityReplacementText("brvbar", "\u00a6");
            parser.defineEntityReplacementText("sect", "\u00a7");
            parser.defineEntityReplacementText("uml", "\u00a8");
            parser.defineEntityReplacementText("copy", "\u00a9");
            parser.defineEntityReplacementText("ordf", "\u00aa");
            parser.defineEntityReplacementText("laquo", "\u00ab");
            parser.defineEntityReplacementText("not", "\u00ac");
            parser.defineEntityReplacementText("shy", "\u00ad");
            parser.defineEntityReplacementText("reg", "\u00ae");
            parser.defineEntityReplacementText("macr", "\u00af");
            parser.defineEntityReplacementText("deg", "\u00b0");
            parser.defineEntityReplacementText("plusmn", "\u00b1");
            parser.defineEntityReplacementText("sup2", "\u00b2");
            parser.defineEntityReplacementText("sup3", "\u00b3");
            parser.defineEntityReplacementText("acute", "\u00b4");
            parser.defineEntityReplacementText("micro", "\u00b5");
            parser.defineEntityReplacementText("para", "\u00b6");
            parser.defineEntityReplacementText("middot", "\u00b7");
            parser.defineEntityReplacementText("cedil", "\u00b8");
            parser.defineEntityReplacementText("sup1", "\u00b9");
            parser.defineEntityReplacementText("ordm", "\u00ba");
            parser.defineEntityReplacementText("raquo", "\u00bb");
            parser.defineEntityReplacementText("frac14", "\u00bc");
            parser.defineEntityReplacementText("frac12", "\u00bd");
            parser.defineEntityReplacementText("frac34", "\u00be");
            parser.defineEntityReplacementText("iquest", "\u00bf");
            parser.defineEntityReplacementText("Agrave", "\u00c0");
            parser.defineEntityReplacementText("Aacute", "\u00c1");
            parser.defineEntityReplacementText("Acirc", "\u00c2");
            parser.defineEntityReplacementText("Atilde", "\u00c3");
            parser.defineEntityReplacementText("Auml", "\u00c4");
            parser.defineEntityReplacementText("Aring", "\u00c5");
            parser.defineEntityReplacementText("AElig", "\u00c6");
            parser.defineEntityReplacementText("Ccedil", "\u00c7");
            parser.defineEntityReplacementText("Egrave", "\u00c8");
            parser.defineEntityReplacementText("Eacute", "\u00c9");
            parser.defineEntityReplacementText("Ecirc", "\u00ca");
            parser.defineEntityReplacementText("Euml", "\u00cb");
            parser.defineEntityReplacementText("Igrave", "\u00cc");
            parser.defineEntityReplacementText("Iacute", "\u00cd");
            parser.defineEntityReplacementText("Icirc", "\u00ce");
            parser.defineEntityReplacementText("Iuml", "\u00cf");
            parser.defineEntityReplacementText("ETH", "\u00d0");
            parser.defineEntityReplacementText("Ntilde", "\u00d1");
            parser.defineEntityReplacementText("Ograve", "\u00d2");
            parser.defineEntityReplacementText("Oacute", "\u00d3");
            parser.defineEntityReplacementText("Ocirc", "\u00d4");
            parser.defineEntityReplacementText("Otilde", "\u00d5");
            parser.defineEntityReplacementText("Ouml", "\u00d6");
            parser.defineEntityReplacementText("times", "\u00d7");
            parser.defineEntityReplacementText("Oslash", "\u00d8");
            parser.defineEntityReplacementText("Ugrave", "\u00d9");
            parser.defineEntityReplacementText("Uacute", "\u00da");
            parser.defineEntityReplacementText("Ucirc", "\u00db");
            parser.defineEntityReplacementText("Uuml", "\u00dc");
            parser.defineEntityReplacementText("Yacute", "\u00dd");
            parser.defineEntityReplacementText("THORN", "\u00de");
            parser.defineEntityReplacementText("szlig", "\u00df");
            parser.defineEntityReplacementText("agrave", "\u00e0");
            parser.defineEntityReplacementText("aacute", "\u00e1");
            parser.defineEntityReplacementText("acirc", "\u00e2");
            parser.defineEntityReplacementText("atilde", "\u00e3");
            parser.defineEntityReplacementText("auml", "\u00e4");
            parser.defineEntityReplacementText("aring", "\u00e5");
            parser.defineEntityReplacementText("aelig", "\u00e6");
            parser.defineEntityReplacementText("ccedil", "\u00e7");
            parser.defineEntityReplacementText("egrave", "\u00e8");
            parser.defineEntityReplacementText("eacute", "\u00e9");
            parser.defineEntityReplacementText("ecirc", "\u00ea");
            parser.defineEntityReplacementText("euml", "\u00eb");
            parser.defineEntityReplacementText("igrave", "\u00ec");
            parser.defineEntityReplacementText("iacute", "\u00ed");
            parser.defineEntityReplacementText("icirc", "\u00ee");
            parser.defineEntityReplacementText("iuml", "\u00ef");
            parser.defineEntityReplacementText("eth", "\u00f0");
            parser.defineEntityReplacementText("ntilde", "\u00f1");
            parser.defineEntityReplacementText("ograve", "\u00f2");
            parser.defineEntityReplacementText("oacute", "\u00f3");
            parser.defineEntityReplacementText("ocirc", "\u00f4");
            parser.defineEntityReplacementText("otilde", "\u00f5");
            parser.defineEntityReplacementText("ouml", "\u00f6");
            parser.defineEntityReplacementText("divide", "\u00f7");
            parser.defineEntityReplacementText("oslash", "\u00f8");
            parser.defineEntityReplacementText("ugrave", "\u00f9");
            parser.defineEntityReplacementText("uacute", "\u00fa");
            parser.defineEntityReplacementText("ucirc", "\u00fb");
            parser.defineEntityReplacementText("uuml", "\u00fc");
            parser.defineEntityReplacementText("yacute", "\u00fd");
            parser.defineEntityReplacementText("thorn", "\u00fe");
            parser.defineEntityReplacementText("yuml", "\u00ff");
            parser.defineEntityReplacementText("OElig", "\u0152");
            parser.defineEntityReplacementText("oelig", "\u0153");
            parser.defineEntityReplacementText("Scaron", "\u0160");
            parser.defineEntityReplacementText("scaron", "\u0161");
            parser.defineEntityReplacementText("Yuml", "\u0178");
            parser.defineEntityReplacementText("circ", "\u02c6");
            parser.defineEntityReplacementText("tilde", "\u02dc");
            parser.defineEntityReplacementText("ensp", "\u2002");
            parser.defineEntityReplacementText("emsp", "\u2003");
            parser.defineEntityReplacementText("thinsp", "\u2009");
            parser.defineEntityReplacementText("zwnj", "\u200c");
            parser.defineEntityReplacementText("zwj", "\u200d");
            parser.defineEntityReplacementText("lrm", "\u200e");
            parser.defineEntityReplacementText("rlm", "\u200f");
            parser.defineEntityReplacementText("ndash", "\u2013");
            parser.defineEntityReplacementText("mdash", "\u2014");
            parser.defineEntityReplacementText("lsquo", "\u2018");
            parser.defineEntityReplacementText("rsquo", "\u2019");
            parser.defineEntityReplacementText("sbquo", "\u201a");
            parser.defineEntityReplacementText("ldquo", "\u201c");
            parser.defineEntityReplacementText("rdquo", "\u201d");
            parser.defineEntityReplacementText("bdquo", "\u201e");
            parser.defineEntityReplacementText("dagger", "\u2020");
            parser.defineEntityReplacementText("Dagger", "\u2021");
            parser.defineEntityReplacementText("permil", "\u2030");
            parser.defineEntityReplacementText("lsaquo", "\u2039");
            parser.defineEntityReplacementText("rsaquo", "\u203a");
            parser.defineEntityReplacementText("euro", "\u20ac");
            parser.defineEntityReplacementText("fnof", "\u0192");
            parser.defineEntityReplacementText("Alpha", "\u0391");
            parser.defineEntityReplacementText("Beta", "\u0392");
            parser.defineEntityReplacementText("Gamma", "\u0393");
            parser.defineEntityReplacementText("Delta", "\u0394");
            parser.defineEntityReplacementText("Epsilon", "\u0395");
            parser.defineEntityReplacementText("Zeta", "\u0396");
            parser.defineEntityReplacementText("Eta", "\u0397");
            parser.defineEntityReplacementText("Theta", "\u0398");
            parser.defineEntityReplacementText("Iota", "\u0399");
            parser.defineEntityReplacementText("Kappa", "\u039a");
            parser.defineEntityReplacementText("Lambda", "\u039b");
            parser.defineEntityReplacementText("Mu", "\u039c");
            parser.defineEntityReplacementText("Nu", "\u039d");
            parser.defineEntityReplacementText("Xi", "\u039e");
            parser.defineEntityReplacementText("Omicron", "\u039f");
            parser.defineEntityReplacementText("Pi", "\u03a0");
            parser.defineEntityReplacementText("Rho", "\u03a1");
            parser.defineEntityReplacementText("Sigma", "\u03a3");
            parser.defineEntityReplacementText("Tau", "\u03a4");
            parser.defineEntityReplacementText("Upsilon", "\u03a5");
            parser.defineEntityReplacementText("Phi", "\u03a6");
            parser.defineEntityReplacementText("Chi", "\u03a7");
            parser.defineEntityReplacementText("Psi", "\u03a8");
            parser.defineEntityReplacementText("Omega", "\u03a9");
            parser.defineEntityReplacementText("alpha", "\u03b1");
            parser.defineEntityReplacementText("beta", "\u03b2");
            parser.defineEntityReplacementText("gamma", "\u03b3");
            parser.defineEntityReplacementText("delta", "\u03b4");
            parser.defineEntityReplacementText("epsilon", "\u03b5");
            parser.defineEntityReplacementText("zeta", "\u03b6");
            parser.defineEntityReplacementText("eta", "\u03b7");
            parser.defineEntityReplacementText("theta", "\u03b8");
            parser.defineEntityReplacementText("iota", "\u03b9");
            parser.defineEntityReplacementText("kappa", "\u03ba");
            parser.defineEntityReplacementText("lambda", "\u03bb");
            parser.defineEntityReplacementText("mu", "\u03bc");
            parser.defineEntityReplacementText("nu", "\u03bd");
            parser.defineEntityReplacementText("xi", "\u03be");
            parser.defineEntityReplacementText("omicron", "\u03bf");
            parser.defineEntityReplacementText("pi", "\u03c0");
            parser.defineEntityReplacementText("rho", "\u03c1");
            parser.defineEntityReplacementText("sigmaf", "\u03c2");
            parser.defineEntityReplacementText("sigma", "\u03c3");
            parser.defineEntityReplacementText("tau", "\u03c4");
            parser.defineEntityReplacementText("upsilon", "\u03c5");
            parser.defineEntityReplacementText("phi", "\u03c6");
            parser.defineEntityReplacementText("chi", "\u03c7");
            parser.defineEntityReplacementText("psi", "\u03c8");
            parser.defineEntityReplacementText("omega", "\u03c9");
            parser.defineEntityReplacementText("thetasym", "\u03d1");
            parser.defineEntityReplacementText("upsih", "\u03d2");
            parser.defineEntityReplacementText("piv", "\u03d6");
            parser.defineEntityReplacementText("bull", "\u2022");
            parser.defineEntityReplacementText("hellip", "\u2026");
            parser.defineEntityReplacementText("prime", "\u2032");
            parser.defineEntityReplacementText("Prime", "\u2033");
            parser.defineEntityReplacementText("oline", "\u203e");
            parser.defineEntityReplacementText("frasl", "\u2044");
            parser.defineEntityReplacementText("weierp", "\u2118");
            parser.defineEntityReplacementText("image", "\u2111");
            parser.defineEntityReplacementText("real", "\u211c");
            parser.defineEntityReplacementText("trade", "\u2122");
            parser.defineEntityReplacementText("alefsym", "\u2135");
            parser.defineEntityReplacementText("larr", "\u2190");
            parser.defineEntityReplacementText("uarr", "\u2191");
            parser.defineEntityReplacementText("rarr", "\u2192");
            parser.defineEntityReplacementText("darr", "\u2193");
            parser.defineEntityReplacementText("harr", "\u2194");
            parser.defineEntityReplacementText("crarr", "\u21b5");
            parser.defineEntityReplacementText("lArr", "\u21d0");
            parser.defineEntityReplacementText("uArr", "\u21d1");
            parser.defineEntityReplacementText("rArr", "\u21d2");
            parser.defineEntityReplacementText("dArr", "\u21d3");
            parser.defineEntityReplacementText("hArr", "\u21d4");
            parser.defineEntityReplacementText("forall", "\u2200");
            parser.defineEntityReplacementText("part", "\u2202");
            parser.defineEntityReplacementText("exist", "\u2203");
            parser.defineEntityReplacementText("empty", "\u2205");
            parser.defineEntityReplacementText("nabla", "\u2207");
            parser.defineEntityReplacementText("isin", "\u2208");
            parser.defineEntityReplacementText("notin", "\u2209");
            parser.defineEntityReplacementText("ni", "\u220b");
            parser.defineEntityReplacementText("prod", "\u220f");
            parser.defineEntityReplacementText("sum", "\u2211");
            parser.defineEntityReplacementText("minus", "\u2212");
            parser.defineEntityReplacementText("lowast", "\u2217");
            parser.defineEntityReplacementText("radic", "\u221a");
            parser.defineEntityReplacementText("prop", "\u221d");
            parser.defineEntityReplacementText("infin", "\u221e");
            parser.defineEntityReplacementText("ang", "\u2220");
            parser.defineEntityReplacementText("and", "\u2227");
            parser.defineEntityReplacementText("or", "\u2228");
            parser.defineEntityReplacementText("cap", "\u2229");
            parser.defineEntityReplacementText("cup", "\u222a");
            parser.defineEntityReplacementText("int", "\u222b");
            parser.defineEntityReplacementText("there4", "\u2234");
            parser.defineEntityReplacementText("sim", "\u223c");
            parser.defineEntityReplacementText("cong", "\u2245");
            parser.defineEntityReplacementText("asymp", "\u2248");
            parser.defineEntityReplacementText("ne", "\u2260");
            parser.defineEntityReplacementText("equiv", "\u2261");
            parser.defineEntityReplacementText("le", "\u2264");
            parser.defineEntityReplacementText("ge", "\u2265");
            parser.defineEntityReplacementText("sub", "\u2282");
            parser.defineEntityReplacementText("sup", "\u2283");
            parser.defineEntityReplacementText("nsub", "\u2284");
            parser.defineEntityReplacementText("sube", "\u2286");
            parser.defineEntityReplacementText("supe", "\u2287");
            parser.defineEntityReplacementText("oplus", "\u2295");
            parser.defineEntityReplacementText("otimes", "\u2297");
            parser.defineEntityReplacementText("perp", "\u22a5");
            parser.defineEntityReplacementText("sdot", "\u22c5");
            parser.defineEntityReplacementText("lceil", "\u2308");
            parser.defineEntityReplacementText("rceil", "\u2309");
            parser.defineEntityReplacementText("lfloor", "\u230a");
            parser.defineEntityReplacementText("rfloor", "\u230b");
            parser.defineEntityReplacementText("lang", "\u2329");
            parser.defineEntityReplacementText("rang", "\u232a");
            parser.defineEntityReplacementText("loz", "\u25ca");
            parser.defineEntityReplacementText("spades", "\u2660");
            parser.defineEntityReplacementText("clubs", "\u2663");
            parser.defineEntityReplacementText("hearts", "\u2665");
            parser.defineEntityReplacementText("diams", "\u2666");
        }
        parser.next();
        return this.parseLifecycleBindings("lifecycles", (XmlPullParser)parser, strict);
    }

    public LifecycleBindings read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public LifecycleBindings read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        XmlStreamReader reader = ReaderFactory.newXmlReader((InputStream)in);
        return this.read((Reader)reader, strict);
    }

    public LifecycleBindings read(InputStream in) throws IOException, XmlPullParserException {
        XmlStreamReader reader = ReaderFactory.newXmlReader((InputStream)in);
        return this.read((Reader)reader);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }
}

