/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.validation;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.ActivationFile;
import org.apache.maven.api.model.ActivationOS;
import org.apache.maven.api.model.ActivationProperty;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.BuildBase;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.DistributionManagement;
import org.apache.maven.api.model.Exclusion;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.Parent;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginExecution;
import org.apache.maven.api.model.PluginManagement;
import org.apache.maven.api.model.ReportPlugin;
import org.apache.maven.api.model.Reporting;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.model.Resource;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.interpolation.ModelVersionProcessor;
import org.apache.maven.model.v4.MavenModelVersion;
import org.apache.maven.model.v4.MavenTransformer;
import org.apache.maven.model.validation.ModelValidator;

@Named
@Singleton
public class DefaultModelValidator
implements ModelValidator {
    public static final List<String> VALID_MODEL_VERSIONS = Collections.unmodifiableList(Arrays.asList("4.0.0", "4.1.0"));
    private static final Pattern EXPRESSION_NAME_PATTERN = Pattern.compile("\\$\\{(.+?)}");
    private static final Pattern EXPRESSION_PROJECT_NAME_PATTERN = Pattern.compile("\\$\\{(project.+?)}");
    private static final String ILLEGAL_FS_CHARS = "\\/:\"<>|?*";
    private static final String ILLEGAL_VERSION_CHARS = "\\/:\"<>|?*";
    private static final String ILLEGAL_REPO_ID_CHARS = "\\/:\"<>|?*";
    private static final String EMPTY = "";
    private final Set<String> validCoordinateIds = new HashSet<String>();
    private final Set<String> validProfileIds = new HashSet<String>();
    private final ModelVersionProcessor versionProcessor;

    @Inject
    public DefaultModelValidator(ModelVersionProcessor versionProcessor) {
        this.versionProcessor = versionProcessor;
    }

    @Override
    public void validateFileModel(Model ma, ModelBuildingRequest request, ModelProblemCollector problems) {
        org.apache.maven.api.model.Model m = ma.getDelegate();
        Parent parent = m.getParent();
        if (parent != null) {
            this.validateStringNotEmpty("parent.groupId", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.BASE, parent.getGroupId(), (InputLocationTracker)parent);
            this.validateStringNotEmpty("parent.artifactId", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.BASE, parent.getArtifactId(), (InputLocationTracker)parent);
            if (DefaultModelValidator.equals(parent.getGroupId(), m.getGroupId()) && DefaultModelValidator.equals(parent.getArtifactId(), m.getArtifactId())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.BASE, "parent.artifactId", null, "must be changed, the parent element cannot have the same groupId:artifactId as the project.", (InputLocationTracker)parent);
            }
            if (DefaultModelValidator.equals("LATEST", parent.getVersion()) || DefaultModelValidator.equals("RELEASE", parent.getVersion())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.BASE, "parent.version", null, "is either LATEST or RELEASE (both of them are being deprecated)", (InputLocationTracker)parent);
            }
        }
        if (request.getValidationLevel() >= 20) {
            HashSet<String> modules = new HashSet<String>();
            int n = m.getModules().size();
            for (int i = 0; i < n; ++i) {
                String module = (String)m.getModules().get(i);
                if (modules.add(module)) continue;
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, "modules.module[" + i + "]", null, "specifies duplicate child module " + module, (InputLocationTracker)m.getLocation((Object)"modules"));
            }
            ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
            if (m.getModelVersion() != null && !m.getModelVersion().isEmpty()) {
                this.validateModelVersion(problems, m.getModelVersion(), (InputLocationTracker)m, VALID_MODEL_VERSIONS);
            }
            this.validateStringNoExpression("groupId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, m.getGroupId(), (InputLocationTracker)m);
            if (parent == null) {
                this.validateStringNotEmpty("groupId", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, m.getGroupId(), (InputLocationTracker)m);
            }
            this.validateStringNoExpression("artifactId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, m.getArtifactId(), (InputLocationTracker)m);
            this.validateStringNotEmpty("artifactId", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, m.getArtifactId(), (InputLocationTracker)m);
            this.validateVersionNoExpression("version", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, m.getVersion(), (InputLocationTracker)m);
            if (parent == null) {
                this.validateStringNotEmpty("version", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, m.getVersion(), (InputLocationTracker)m);
            }
            this.validate20RawDependencies(problems, m.getDependencies(), "dependencies.dependency.", EMPTY, request);
            this.validate20RawDependenciesSelfReferencing(problems, m, m.getDependencies(), "dependencies.dependency", request);
            if (m.getDependencyManagement() != null) {
                this.validate20RawDependencies(problems, m.getDependencyManagement().getDependencies(), "dependencyManagement.dependencies.dependency.", EMPTY, request);
            }
            this.validateRawRepositories(problems, m.getRepositories(), "repositories.repository.", EMPTY, request);
            this.validateRawRepositories(problems, m.getPluginRepositories(), "pluginRepositories.pluginRepository.", EMPTY, request);
            Build build = m.getBuild();
            if (build != null) {
                this.validate20RawPlugins(problems, build.getPlugins(), "build.plugins.plugin.", EMPTY, request);
                PluginManagement mgmt = build.getPluginManagement();
                if (mgmt != null) {
                    this.validate20RawPlugins(problems, mgmt.getPlugins(), "build.pluginManagement.plugins.plugin.", EMPTY, request);
                }
            }
            HashSet<String> profileIds = new HashSet<String>();
            for (org.apache.maven.api.model.Profile profile : m.getProfiles()) {
                String prefix = "profiles.profile[" + profile.getId() + "].";
                this.validateProfileId(prefix, "id", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V40, profile.getId(), null, (InputLocationTracker)m);
                if (!profileIds.add(profile.getId())) {
                    DefaultModelValidator.addViolation(problems, errOn30, ModelProblem.Version.V20, "profiles.profile.id", null, "must be unique but found duplicate profile with id " + profile.getId(), (InputLocationTracker)profile);
                }
                this.validate30RawProfileActivation(problems, profile.getActivation(), prefix);
                this.validate20RawDependencies(problems, profile.getDependencies(), prefix, "dependencies.dependency.", request);
                if (profile.getDependencyManagement() != null) {
                    this.validate20RawDependencies(problems, profile.getDependencyManagement().getDependencies(), prefix, "dependencyManagement.dependencies.dependency.", request);
                }
                this.validateRawRepositories(problems, profile.getRepositories(), prefix, "repositories.repository.", request);
                this.validateRawRepositories(problems, profile.getPluginRepositories(), prefix, "pluginRepositories.pluginRepository.", request);
                BuildBase buildBase = profile.getBuild();
                if (buildBase == null) continue;
                this.validate20RawPlugins(problems, buildBase.getPlugins(), prefix, "plugins.plugin.", request);
                PluginManagement mgmt = buildBase.getPluginManagement();
                if (mgmt == null) continue;
                this.validate20RawPlugins(problems, mgmt.getPlugins(), prefix, "pluginManagement.plugins.plugin.", request);
            }
        }
    }

    @Override
    public void validateRawModel(Model ma, ModelBuildingRequest request, ModelProblemCollector problems) {
        Parent parent;
        org.apache.maven.api.model.Model m = ma.getDelegate();
        this.validateStringNotEmpty("modelVersion", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, m.getModelVersion(), (InputLocationTracker)m);
        this.validateModelVersion(problems, m.getModelVersion(), (InputLocationTracker)m, VALID_MODEL_VERSIONS);
        String minVersion = new MavenModelVersion().getModelVersion(m);
        if (m.getModelVersion() != null && DefaultModelValidator.compareModelVersions(minVersion, m.getModelVersion()) > 0) {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V40, "model", null, "the model contains elements that require a model version of " + minVersion, (InputLocationTracker)m);
        }
        if ((parent = m.getParent()) != null) {
            this.validateStringNotEmpty("parent.version", problems, ModelProblem.Severity.FATAL, ModelProblem.Version.BASE, parent.getVersion(), (InputLocationTracker)parent);
        }
    }

    private void validate30RawProfileActivation(ModelProblemCollector problems, Activation activation, String prefix) {
        if (activation == null) {
            return;
        }
        LinkedList<ActivationFrame> stk = new LinkedList<ActivationFrame>();
        Supplier<String> pathSupplier = () -> {
            boolean parallel = false;
            return StreamSupport.stream(((Iterable)stk::descendingIterator).spliterator(), false).map(ActivationFrame::location).collect(Collectors.joining("."));
        };
        Supplier<org.apache.maven.api.model.InputLocation> locationSupplier = () -> {
            if (stk.size() < 2) {
                return null;
            }
            Iterator f = stk.iterator();
            String location = ((ActivationFrame)f.next()).location;
            ActivationFrame parent = (ActivationFrame)f.next();
            return parent.parent.map(p -> p.getLocation((Object)location)).orElse(null);
        };
        UnaryOperator transformer = s -> {
            if (this.hasProjectExpression((String)s)) {
                String path = (String)pathSupplier.get();
                Matcher matcher = EXPRESSION_PROJECT_NAME_PATTERN.matcher((CharSequence)s);
                while (matcher.find()) {
                    String propertyName = matcher.group(0);
                    if (path.startsWith("activation.file.") && "${project.basedir}".equals(propertyName)) continue;
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V30, prefix + path, null, "Failed to interpolate profile activation property " + s + ": " + propertyName + " expressions are not supported during profile activation.", (InputLocationTracker)locationSupplier.get());
                }
            }
            return s;
        };
        new ActivationWalker(stk, transformer).transformActivation(activation);
    }

    private void validate20RawPlugins(ModelProblemCollector problems, List<Plugin> plugins, String prefix, String prefix2, ModelBuildingRequest request) {
        ModelProblem.Severity errOn31 = DefaultModelValidator.getSeverity(request, 31);
        HashMap<String, Plugin> index = new HashMap<String, Plugin>();
        for (Plugin plugin : plugins) {
            String key;
            Plugin existing;
            if (plugin.getGroupId() == null || plugin.getGroupId() != null && plugin.getGroupId().trim().isEmpty()) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, prefix + prefix2 + "(groupId:artifactId)", null, "groupId of a plugin must be defined. ", (InputLocationTracker)plugin);
            }
            if (plugin.getArtifactId() == null || plugin.getArtifactId() != null && plugin.getArtifactId().trim().isEmpty()) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, prefix + prefix2 + "(groupId:artifactId)", null, "artifactId of a plugin must be defined. ", (InputLocationTracker)plugin);
            }
            if (plugin.getVersion() != null && plugin.getVersion().trim().isEmpty()) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, prefix + prefix2 + "(groupId:artifactId)", null, "version of a plugin must be defined. ", (InputLocationTracker)plugin);
            }
            if ((existing = (Plugin)index.get(key = plugin.getKey())) != null) {
                DefaultModelValidator.addViolation(problems, errOn31, ModelProblem.Version.V20, prefix + prefix2 + "(groupId:artifactId)", null, "must be unique but found duplicate declaration of plugin " + key, (InputLocationTracker)plugin);
            } else {
                index.put(key, plugin);
            }
            HashSet<String> executionIds = new HashSet<String>();
            for (PluginExecution exec : plugin.getExecutions()) {
                if (executionIds.add(exec.getId())) continue;
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, prefix + prefix2 + "[" + plugin.getKey() + "].executions.execution.id", null, "must be unique but found duplicate execution with id " + exec.getId(), (InputLocationTracker)exec);
            }
        }
    }

    @Override
    public void validateEffectiveModel(Model ma, ModelBuildingRequest request, ModelProblemCollector problems) {
        org.apache.maven.api.model.Model m = ma.getDelegate();
        this.validateStringNotEmpty("modelVersion", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, m.getModelVersion(), (InputLocationTracker)m);
        this.validateCoordinateId("groupId", problems, m.getGroupId(), (InputLocationTracker)m);
        this.validateCoordinateId("artifactId", problems, m.getArtifactId(), (InputLocationTracker)m);
        this.validateStringNotEmpty("packaging", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, m.getPackaging(), (InputLocationTracker)m);
        if (!m.getModules().isEmpty()) {
            if (!"pom".equals(m.getPackaging())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, "packaging", null, "with value '" + m.getPackaging() + "' is invalid. Aggregator projects require 'pom' as packaging.", (InputLocationTracker)m);
            }
            int n = m.getModules().size();
            for (int i = 0; i < n; ++i) {
                String module = (String)m.getModules().get(i);
                boolean isBlankModule = true;
                if (module != null) {
                    for (int j = 0; j < module.length(); ++j) {
                        if (Character.isWhitespace(module.charAt(j))) continue;
                        isBlankModule = false;
                    }
                }
                if (!isBlankModule) continue;
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, "modules.module[" + i + "]", null, "has been specified without a path to the project directory.", (InputLocationTracker)m.getLocation((Object)"modules"));
            }
        }
        this.validateStringNotEmpty("version", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, m.getVersion(), (InputLocationTracker)m);
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        this.validateEffectiveDependencies(problems, m, m.getDependencies(), false, request);
        DependencyManagement mgmt = m.getDependencyManagement();
        if (mgmt != null) {
            this.validateEffectiveDependencies(problems, m, mgmt.getDependencies(), true, request);
        }
        if (request.getValidationLevel() >= 20) {
            Reporting reporting;
            ModelProblem.Severity errOn31 = DefaultModelValidator.getSeverity(request, 31);
            this.validateBannedCharacters(EMPTY, "version", problems, errOn31, ModelProblem.Version.V20, m.getVersion(), null, (InputLocationTracker)m, "\\/:\"<>|?*");
            this.validate20ProperSnapshotVersion("version", problems, errOn31, ModelProblem.Version.V20, m.getVersion(), null, (InputLocationTracker)m);
            Build build = m.getBuild();
            if (build != null) {
                for (Object p : build.getPlugins()) {
                    this.validateStringNotEmpty("build.plugins.plugin.artifactId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, p.getArtifactId(), (InputLocationTracker)p);
                    this.validateStringNotEmpty("build.plugins.plugin.groupId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, p.getGroupId(), (InputLocationTracker)p);
                    this.validate20PluginVersion("build.plugins.plugin.version", problems, p.getVersion(), p.getKey(), (InputLocationTracker)p, request);
                    this.validateBoolean("build.plugins.plugin.inherited", EMPTY, problems, errOn30, ModelProblem.Version.V20, p.getInherited(), p.getKey(), (InputLocationTracker)p);
                    this.validateBoolean("build.plugins.plugin.extensions", EMPTY, problems, errOn30, ModelProblem.Version.V20, p.getExtensions(), p.getKey(), (InputLocationTracker)p);
                    this.validate20EffectivePluginDependencies(problems, (Plugin)p, request);
                }
                this.validate20RawResources(problems, build.getResources(), "build.resources.resource.", request);
                this.validate20RawResources(problems, build.getTestResources(), "build.testResources.testResource.", request);
            }
            if ((reporting = m.getReporting()) != null) {
                for (ReportPlugin p : reporting.getPlugins()) {
                    this.validateStringNotEmpty("reporting.plugins.plugin.artifactId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, p.getArtifactId(), (InputLocationTracker)p);
                    this.validateStringNotEmpty("reporting.plugins.plugin.groupId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, p.getGroupId(), (InputLocationTracker)p);
                }
            }
            for (Repository repository : m.getRepositories()) {
                this.validate20EffectiveRepository(problems, repository, "repositories.repository.", request);
            }
            for (Repository repository : m.getPluginRepositories()) {
                this.validate20EffectiveRepository(problems, repository, "pluginRepositories.pluginRepository.", request);
            }
            DistributionManagement distMgmt = m.getDistributionManagement();
            if (distMgmt != null) {
                if (distMgmt.getStatus() != null) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, "distributionManagement.status", null, "must not be specified.", (InputLocationTracker)distMgmt);
                }
                this.validate20EffectiveRepository(problems, (Repository)distMgmt.getRepository(), "distributionManagement.repository.", request);
                this.validate20EffectiveRepository(problems, (Repository)distMgmt.getSnapshotRepository(), "distributionManagement.snapshotRepository.", request);
            }
        }
    }

    @Override
    public void validateExternalProfiles(List<Profile> activeExternalProfiles, Model ma, ModelBuildingRequest request, ModelProblemCollector problems) {
        org.apache.maven.api.model.Model m = ma.getDelegate();
        for (org.apache.maven.api.model.Profile profile : activeExternalProfiles.stream().map(Profile::getDelegate).collect(Collectors.toList())) {
            String externalRepositoriesSource = "external profile with id '" + profile.getId() + "' in settings.xml";
            this.validateUniqueRepositoryIds(false, m.getRepositories(), profile.getRepositories(), externalRepositoriesSource, problems);
            this.validateUniqueRepositoryIds(true, m.getPluginRepositories(), profile.getPluginRepositories(), externalRepositoriesSource, problems);
        }
    }

    private void validateUniqueRepositoryIds(boolean isPluginRepository, Collection<Repository> pomRepositories, Collection<Repository> externalRepositories, String externalRepositoriesSource, ModelProblemCollector problems) {
        for (Repository externalRepository : externalRepositories) {
            Optional<Repository> clashingPomRepository = pomRepositories.stream().filter(r -> Objects.equals(r.getId(), externalRepository.getId())).filter(r -> !Objects.equals(r.getUrl(), externalRepository.getUrl())).findFirst();
            if (!clashingPomRepository.isPresent()) continue;
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.BASE, isPluginRepository ? "pluginRepositories.repository" : "repositories.repository", clashingPomRepository.get().getId(), "is overwritten by the repository with same id but having a different url from " + externalRepositoriesSource, (InputLocationTracker)clashingPomRepository.get());
        }
    }

    private void validate20RawDependencies(ModelProblemCollector problems, List<Dependency> dependencies, String prefix, String prefix2, ModelBuildingRequest request) {
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        ModelProblem.Severity errOn31 = DefaultModelValidator.getSeverity(request, 31);
        HashMap<String, Dependency> index = new HashMap<String, Dependency>();
        for (Dependency dependency : dependencies) {
            Dependency existing;
            String key = dependency.getManagementKey();
            if ("import".equals(dependency.getScope())) {
                if (!"pom".equals(dependency.getType())) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, prefix + prefix2 + "type", key, "must be 'pom' to import the managed dependencies.", (InputLocationTracker)dependency);
                } else if (dependency.getClassifier() != null && !dependency.getClassifier().isEmpty()) {
                    DefaultModelValidator.addViolation(problems, errOn30, ModelProblem.Version.V20, prefix + prefix2 + "classifier", key, "must be empty, imported POM cannot have a classifier.", (InputLocationTracker)dependency);
                }
            } else if ("system".equals(dependency.getScope())) {
                String sysPath;
                if (request.getValidationLevel() >= 31) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V31, prefix + prefix2 + "scope", key, "declares usage of deprecated 'system' scope ", (InputLocationTracker)dependency);
                }
                if ((sysPath = dependency.getSystemPath()) != null && !sysPath.isEmpty()) {
                    if (!this.hasExpression(sysPath)) {
                        DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, prefix + prefix2 + "systemPath", key, "should use a variable instead of a hard-coded path " + sysPath, (InputLocationTracker)dependency);
                    } else if (sysPath.contains("${basedir}") || sysPath.contains("${project.basedir}")) {
                        DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, prefix + prefix2 + "systemPath", key, "should not point at files within the project directory, " + sysPath + " will be unresolvable by dependent projects", (InputLocationTracker)dependency);
                    }
                }
            }
            if (DefaultModelValidator.equals("LATEST", dependency.getVersion()) || DefaultModelValidator.equals("RELEASE", dependency.getVersion())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.BASE, prefix + prefix2 + "version", key, "is either LATEST or RELEASE (both of them are being deprecated)", (InputLocationTracker)dependency);
            }
            if ((existing = (Dependency)index.get(key)) != null) {
                String msg = DefaultModelValidator.equals(existing.getVersion(), dependency.getVersion()) ? "duplicate declaration of version " + Objects.toString(dependency.getVersion(), "(?)") : "version " + Objects.toString(existing.getVersion(), "(?)") + " vs " + Objects.toString(dependency.getVersion(), "(?)");
                DefaultModelValidator.addViolation(problems, errOn31, ModelProblem.Version.V20, prefix + prefix2 + "(groupId:artifactId:type:classifier)", null, "must be unique: " + key + " -> " + msg, (InputLocationTracker)dependency);
                continue;
            }
            index.put(key, dependency);
        }
    }

    private void validate20RawDependenciesSelfReferencing(ModelProblemCollector problems, org.apache.maven.api.model.Model m, List<Dependency> dependencies, String prefix, ModelBuildingRequest request) {
        for (Dependency dependency : dependencies) {
            String mKey;
            String key = dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + (String)(dependency.getClassifier() != null ? ":" + dependency.getClassifier() : EMPTY);
            if (!key.equals(mKey = m.getGroupId() + ":" + m.getArtifactId() + ":" + m.getVersion())) continue;
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V31, prefix + "[" + key + "]", key, "is referencing itself.", (InputLocationTracker)dependency);
        }
    }

    private void validateEffectiveDependencies(ModelProblemCollector problems, org.apache.maven.api.model.Model m, List<Dependency> dependencies, boolean management, ModelBuildingRequest request) {
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        String prefix = management ? "dependencyManagement.dependencies.dependency." : "dependencies.dependency.";
        for (Dependency d : dependencies) {
            this.validateEffectiveDependency(problems, d, management, prefix, request);
            if (request.getValidationLevel() < 20) continue;
            this.validateBoolean(prefix, "optional", problems, errOn30, ModelProblem.Version.V20, d.getOptional(), d.getManagementKey(), (InputLocationTracker)d);
            if (!management) {
                this.validateVersion(prefix, "version", problems, errOn30, ModelProblem.Version.V20, d.getVersion(), d.getManagementKey(), (InputLocationTracker)d);
                this.validateEnum(prefix, "scope", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, d.getScope(), d.getManagementKey(), (InputLocationTracker)d, "provided", "compile", "runtime", "test", "system");
                this.validateEffectiveModelAgainstDependency(prefix, problems, m, d, request);
                continue;
            }
            this.validateEnum(prefix, "scope", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, d.getScope(), d.getManagementKey(), (InputLocationTracker)d, "provided", "compile", "runtime", "test", "system", "import");
        }
    }

    private void validateEffectiveModelAgainstDependency(String prefix, ModelProblemCollector problems, org.apache.maven.api.model.Model m, Dependency d, ModelBuildingRequest request) {
        String mKey;
        String key = d.getGroupId() + ":" + d.getArtifactId() + ":" + d.getVersion() + (String)(d.getClassifier() != null ? ":" + d.getClassifier() : EMPTY);
        if (key.equals(mKey = m.getGroupId() + ":" + m.getArtifactId() + ":" + m.getVersion())) {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V31, prefix + "[" + key + "]", key, "is referencing itself.", (InputLocationTracker)d);
        }
    }

    private void validate20EffectivePluginDependencies(ModelProblemCollector problems, Plugin plugin, ModelBuildingRequest request) {
        List dependencies = plugin.getDependencies();
        if (!dependencies.isEmpty()) {
            String prefix = "build.plugins.plugin[" + plugin.getKey() + "].dependencies.dependency.";
            ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
            for (Dependency d : dependencies) {
                this.validateEffectiveDependency(problems, d, false, prefix, request);
                this.validateVersion(prefix, "version", problems, errOn30, ModelProblem.Version.BASE, d.getVersion(), d.getManagementKey(), (InputLocationTracker)d);
                this.validateEnum(prefix, "scope", problems, errOn30, ModelProblem.Version.BASE, d.getScope(), d.getManagementKey(), (InputLocationTracker)d, "compile", "runtime", "system");
            }
        }
    }

    private void validateEffectiveDependency(ModelProblemCollector problems, Dependency d, boolean management, String prefix, ModelBuildingRequest request) {
        this.validateCoordinateId(prefix, "artifactId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, d.getArtifactId(), d.getManagementKey(), (InputLocationTracker)d);
        this.validateCoordinateId(prefix, "groupId", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, d.getGroupId(), d.getManagementKey(), (InputLocationTracker)d);
        if (!management) {
            this.validateStringNotEmpty(prefix, "type", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, d.getType(), d.getManagementKey(), (InputLocationTracker)d);
            this.validateDependencyVersion(problems, d, prefix);
        }
        if ("system".equals(d.getScope())) {
            String systemPath = d.getSystemPath();
            if (systemPath == null || systemPath.isEmpty()) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, prefix + "systemPath", d.getManagementKey(), "is missing.", (InputLocationTracker)d);
            } else {
                File sysFile = new File(systemPath);
                if (!sysFile.isAbsolute()) {
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, prefix + "systemPath", d.getManagementKey(), "must specify an absolute path but is " + systemPath, (InputLocationTracker)d);
                } else if (!sysFile.isFile()) {
                    String jdkHome;
                    String msg = "refers to a non-existing file " + sysFile.getAbsolutePath();
                    if ((systemPath = systemPath.replace('/', File.separatorChar).replace('\\', File.separatorChar)).startsWith(jdkHome = request.getSystemProperties().getProperty("java.home", EMPTY) + File.separator + "..")) {
                        msg = msg + ". Please verify that you run Maven using a JDK and not just a JRE.";
                    }
                    DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.BASE, prefix + "systemPath", d.getManagementKey(), msg, (InputLocationTracker)d);
                }
            }
        } else if (d.getSystemPath() != null && !d.getSystemPath().isEmpty()) {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, prefix + "systemPath", d.getManagementKey(), "must be omitted. This field may only be specified for a dependency with system scope.", (InputLocationTracker)d);
        }
        if (request.getValidationLevel() >= 20) {
            for (Exclusion exclusion : d.getExclusions()) {
                if (request.getValidationLevel() < 30) {
                    this.validateCoordinateId(prefix, "exclusions.exclusion.groupId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, exclusion.getGroupId(), d.getManagementKey(), (InputLocationTracker)exclusion);
                    this.validateCoordinateId(prefix, "exclusions.exclusion.artifactId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, exclusion.getArtifactId(), d.getManagementKey(), (InputLocationTracker)exclusion);
                    continue;
                }
                this.validateCoordinateIdWithWildcards(prefix, "exclusions.exclusion.groupId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V30, exclusion.getGroupId(), d.getManagementKey(), (InputLocationTracker)exclusion);
                this.validateCoordinateIdWithWildcards(prefix, "exclusions.exclusion.artifactId", problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V30, exclusion.getArtifactId(), d.getManagementKey(), (InputLocationTracker)exclusion);
            }
        }
    }

    protected void validateDependencyVersion(ModelProblemCollector problems, Dependency d, String prefix) {
        this.validateStringNotEmpty(prefix, "version", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, d.getVersion(), d.getManagementKey(), (InputLocationTracker)d);
    }

    private void validateRawRepositories(ModelProblemCollector problems, List<Repository> repositories, String prefix, String prefix2, ModelBuildingRequest request) {
        HashMap<String, Repository> index = new HashMap<String, Repository>();
        for (Repository repository : repositories) {
            String key;
            Repository existing;
            this.validateStringNotEmpty(prefix, prefix2, "id", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, repository.getId(), null, (InputLocationTracker)repository);
            if (this.validateStringNotEmpty(prefix, prefix2, "[" + repository.getId() + "].url", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, repository.getUrl(), null, (InputLocationTracker)repository)) {
                Matcher m = EXPRESSION_NAME_PATTERN.matcher(repository.getUrl());
                while (m.find()) {
                    if ("basedir".equals(m.group(1)) || "project.basedir".equals(m.group(1)) || "project.baseUri".equals(m.group(1))) continue;
                    this.validateStringNoExpression(prefix + prefix2 + "[" + repository.getId() + "].url", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V40, repository.getUrl(), (InputLocationTracker)repository);
                    break;
                }
            }
            if ((existing = (Repository)index.get(key = repository.getId())) != null) {
                ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
                DefaultModelValidator.addViolation(problems, errOn30, ModelProblem.Version.V20, prefix + prefix2 + "id", null, "must be unique: " + repository.getId() + " -> " + existing.getUrl() + " vs " + repository.getUrl(), (InputLocationTracker)repository);
                continue;
            }
            index.put(key, repository);
        }
    }

    private void validate20EffectiveRepository(ModelProblemCollector problems, Repository repository, String prefix, ModelBuildingRequest request) {
        if (repository != null) {
            ModelProblem.Severity errOn31 = DefaultModelValidator.getSeverity(request, 31);
            this.validateBannedCharacters(prefix, "id", problems, errOn31, ModelProblem.Version.V20, repository.getId(), null, (InputLocationTracker)repository, "\\/:\"<>|?*");
            if ("local".equals(repository.getId())) {
                DefaultModelValidator.addViolation(problems, errOn31, ModelProblem.Version.V20, prefix + "id", null, "must not be 'local', this identifier is reserved for the local repository, using it for other repositories will corrupt your repository metadata.", (InputLocationTracker)repository);
            }
            if ("legacy".equals(repository.getLayout())) {
                DefaultModelValidator.addViolation(problems, ModelProblem.Severity.WARNING, ModelProblem.Version.V20, prefix + "layout", repository.getId(), "uses the unsupported value 'legacy', artifact resolution might fail.", (InputLocationTracker)repository);
            }
        }
    }

    private void validate20RawResources(ModelProblemCollector problems, List<Resource> resources, String prefix, ModelBuildingRequest request) {
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        for (Resource resource : resources) {
            this.validateStringNotEmpty(prefix, "directory", problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, resource.getDirectory(), null, (InputLocationTracker)resource);
            this.validateBoolean(prefix, "filtering", problems, errOn30, ModelProblem.Version.V20, resource.getFiltering(), resource.getDirectory(), (InputLocationTracker)resource);
        }
    }

    private boolean validateCoordinateId(String fieldName, ModelProblemCollector problems, String id, InputLocationTracker tracker) {
        return this.validateCoordinateId(EMPTY, fieldName, problems, ModelProblem.Severity.ERROR, ModelProblem.Version.BASE, id, null, tracker);
    }

    private boolean validateCoordinateId(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String id, String sourceHint, InputLocationTracker tracker) {
        if (this.validCoordinateIds.contains(id)) {
            return true;
        }
        if (!this.validateStringNotEmpty(prefix, fieldName, problems, severity, version, id, sourceHint, tracker)) {
            return false;
        }
        if (!this.isValidCoordinateId(id)) {
            DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "with value '" + id + "' does not match a valid coordinate id pattern.", tracker);
            return false;
        }
        this.validCoordinateIds.add(id);
        return true;
    }

    private boolean isValidCoordinateId(String id) {
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (this.isValidCoordinateIdCharacter(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidCoordinateIdCharacter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.';
    }

    private boolean validateProfileId(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String id, String sourceHint, InputLocationTracker tracker) {
        if (this.validProfileIds.contains(id)) {
            return true;
        }
        if (!this.validateStringNotEmpty(prefix, fieldName, problems, severity, version, id, sourceHint, tracker)) {
            return false;
        }
        if (!this.isValidProfileId(id)) {
            DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "with value '" + id + "' does not match a valid profile id pattern.", tracker);
            return false;
        }
        this.validProfileIds.add(id);
        return true;
    }

    private boolean isValidProfileId(String id) {
        switch (id.charAt(0)) {
            case '!': 
            case '+': 
            case '-': 
            case '?': {
                return false;
            }
        }
        return true;
    }

    private boolean validateCoordinateIdWithWildcards(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String id, String sourceHint, InputLocationTracker tracker) {
        if (!this.validateStringNotEmpty(prefix, fieldName, problems, severity, version, id, sourceHint, tracker)) {
            return false;
        }
        if (!this.isValidCoordinateIdWithWildCards(id)) {
            DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "with value '" + id + "' does not match a valid coordinate id pattern.", tracker);
            return false;
        }
        return true;
    }

    private boolean isValidCoordinateIdWithWildCards(String id) {
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (this.isValidCoordinateIdWithWildCardCharacter(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidCoordinateIdWithWildCardCharacter(char c) {
        return this.isValidCoordinateIdCharacter(c) || c == '?' || c == '*';
    }

    private boolean validateStringNoExpression(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, InputLocationTracker tracker) {
        if (!this.hasExpression(string)) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, fieldName, null, "contains an expression but should be a constant.", tracker);
        return false;
    }

    private boolean validateVersionNoExpression(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, InputLocationTracker tracker) {
        if (!this.hasExpression(string)) {
            return true;
        }
        Matcher m = EXPRESSION_NAME_PATTERN.matcher(string.trim());
        while (m.find()) {
            String property = m.group(1);
            if (this.versionProcessor.isValidProperty(property)) continue;
            DefaultModelValidator.addViolation(problems, severity, version, fieldName, null, "contains an expression but should be a constant.", tracker);
            return false;
        }
        return true;
    }

    private boolean hasExpression(String value) {
        return value != null && value.contains("${");
    }

    private boolean hasProjectExpression(String value) {
        return value != null && value.contains("${project.");
    }

    private boolean validateStringNotEmpty(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, InputLocationTracker tracker) {
        return this.validateStringNotEmpty(EMPTY, fieldName, problems, severity, version, string, null, tracker);
    }

    private boolean validateStringNotEmpty(String prefix, String prefix2, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker) {
        if (!this.validateNotNull(prefix, prefix2, fieldName, problems, severity, version, string, sourceHint, tracker)) {
            return false;
        }
        if (!string.isEmpty()) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + prefix2 + fieldName, sourceHint, "is missing.", tracker);
        return false;
    }

    private boolean validateStringNotEmpty(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker) {
        if (!this.validateNotNull(prefix, fieldName, problems, severity, version, string, sourceHint, tracker)) {
            return false;
        }
        if (!string.isEmpty()) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "is missing.", tracker);
        return false;
    }

    private boolean validateNotNull(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, Object object, String sourceHint, InputLocationTracker tracker) {
        if (object != null) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "is missing.", tracker);
        return false;
    }

    private boolean validateNotNull(String prefix, String prefix2, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, Object object, String sourceHint, InputLocationTracker tracker) {
        if (object != null) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + prefix2 + fieldName, sourceHint, "is missing.", tracker);
        return false;
    }

    private boolean validateBoolean(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        if ("true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "must be 'true' or 'false' but is '" + string + "'.", tracker);
        return false;
    }

    private boolean validateEnum(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker, String ... validValues) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        List<String> values = Arrays.asList(validValues);
        if (values.contains(string)) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "must be one of " + values + " but is '" + string + "'.", tracker);
        return false;
    }

    private boolean validateModelVersion(ModelProblemCollector problems, String string, InputLocationTracker tracker, List<String> validVersions) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        if (validVersions.contains(string)) {
            return true;
        }
        boolean newerThanAll = true;
        boolean olderThanAll = true;
        for (String validValue : validVersions) {
            int comparison = DefaultModelValidator.compareModelVersions(validValue, string);
            newerThanAll = newerThanAll && comparison < 0;
            olderThanAll = olderThanAll && comparison > 0;
        }
        if (newerThanAll) {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, "modelVersion", null, "of '" + string + "' is newer than the versions supported by this version of Maven: " + validVersions + ". Building this project requires a newer version of Maven.", tracker);
        } else if (olderThanAll) {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.FATAL, ModelProblem.Version.V20, "modelVersion", null, "of '" + string + "' is older than the versions supported by this version of Maven: " + validVersions + ". Building this project requires an older version of Maven.", tracker);
        } else {
            DefaultModelValidator.addViolation(problems, ModelProblem.Severity.ERROR, ModelProblem.Version.V20, "modelVersion", null, "must be one of " + validVersions + " but is '" + string + "'.", tracker);
        }
        return false;
    }

    private static int compareModelVersions(String first, String second) {
        String[] firstSegments = first.split("\\.");
        String[] secondSegments = second.split("\\.");
        for (int i = 0; i < Math.max(firstSegments.length, secondSegments.length); ++i) {
            int result = Long.valueOf(i < firstSegments.length ? firstSegments[i] : "0").compareTo(Long.valueOf(i < secondSegments.length ? secondSegments[i] : "0"));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private boolean validateBannedCharacters(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker, String banned) {
        if (string != null) {
            for (int i = string.length() - 1; i >= 0; --i) {
                if (banned.indexOf(string.charAt(i)) < 0) continue;
                DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "must not contain any of these characters " + banned + " but found " + string.charAt(i), tracker);
                return false;
            }
        }
        return true;
    }

    private boolean validateVersion(String prefix, String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        if (this.hasExpression(string)) {
            DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "must be a valid version but is '" + string + "'.", tracker);
            return false;
        }
        return this.validateBannedCharacters(prefix, fieldName, problems, severity, version, string, sourceHint, tracker, "\\/:\"<>|?*");
    }

    private boolean validate20ProperSnapshotVersion(String fieldName, ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String string, String sourceHint, InputLocationTracker tracker) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        if (string.endsWith("SNAPSHOT") && !string.endsWith("-SNAPSHOT")) {
            DefaultModelValidator.addViolation(problems, severity, version, fieldName, sourceHint, "uses an unsupported snapshot version format, should be '*-SNAPSHOT' instead.", tracker);
            return false;
        }
        return true;
    }

    private boolean validate20PluginVersion(String fieldName, ModelProblemCollector problems, String string, String sourceHint, InputLocationTracker tracker, ModelBuildingRequest request) {
        if (string == null) {
            return true;
        }
        ModelProblem.Severity errOn30 = DefaultModelValidator.getSeverity(request, 30);
        if (!this.validateVersion(EMPTY, fieldName, problems, errOn30, ModelProblem.Version.V20, string, sourceHint, tracker)) {
            return false;
        }
        if (string.isEmpty() || "RELEASE".equals(string) || "LATEST".equals(string)) {
            DefaultModelValidator.addViolation(problems, errOn30, ModelProblem.Version.V20, fieldName, sourceHint, "must be a valid version but is '" + string + "'.", tracker);
            return false;
        }
        return true;
    }

    private static void addViolation(ModelProblemCollector problems, ModelProblem.Severity severity, ModelProblem.Version version, String fieldName, String sourceHint, String message, InputLocationTracker tracker) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append('\'').append(fieldName).append('\'');
        if (sourceHint != null) {
            buffer.append(" for ").append(sourceHint);
        }
        buffer.append(' ').append(message);
        problems.add(new ModelProblemCollectorRequest(severity, version).setMessage(buffer.toString()).setLocation(DefaultModelValidator.getLocation(fieldName, tracker)));
    }

    private static InputLocation getLocation(String fieldName, InputLocationTracker tracker) {
        org.apache.maven.api.model.InputLocation location = null;
        if (tracker != null) {
            if (fieldName != null) {
                Object key = fieldName;
                int idx = fieldName.lastIndexOf(46);
                if (idx >= 0) {
                    fieldName = fieldName.substring(idx + 1);
                    key = fieldName;
                }
                if (fieldName.endsWith("]")) {
                    key = fieldName.substring(fieldName.lastIndexOf(91) + 1, fieldName.length() - 1);
                    try {
                        key = Integer.valueOf(key.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                location = tracker.getLocation(key);
            }
            if (location == null) {
                location = tracker.getLocation((Object)EMPTY);
            }
        }
        return location != null ? new InputLocation(location) : null;
    }

    private static boolean equals(String s1, String s2) {
        String c1 = s1 == null ? EMPTY : s1.trim();
        String c2 = s2 == null ? EMPTY : s2.trim();
        return c1.equals(c2);
    }

    private static ModelProblem.Severity getSeverity(ModelBuildingRequest request, int errorThreshold) {
        return DefaultModelValidator.getSeverity(request.getValidationLevel(), errorThreshold);
    }

    private static ModelProblem.Severity getSeverity(int validationLevel, int errorThreshold) {
        if (validationLevel < errorThreshold) {
            return ModelProblem.Severity.WARNING;
        }
        return ModelProblem.Severity.ERROR;
    }

    private static class ActivationWalker
    extends MavenTransformer {
        private final Deque<ActivationFrame> stk;

        ActivationWalker(Deque<ActivationFrame> stk, UnaryOperator<String> transformer) {
            super(transformer);
            this.stk = stk;
        }

        private ActivationFrame nextFrame(String property) {
            return new ActivationFrame(property, Optional.empty());
        }

        private <P> ActivationFrame nextFrame(String property, Function<P, InputLocationTracker> child) {
            Optional<? extends InputLocationTracker> parent = this.stk.peek().parent;
            return new ActivationFrame(property, parent.map(child));
        }

        public Activation transformActivation(Activation target) {
            this.stk.push(new ActivationFrame("activation", Optional.of(target)));
            try {
                Activation activation = super.transformActivation(target);
                return activation;
            }
            finally {
                this.stk.pop();
            }
        }

        protected Activation.Builder transformActivation_ActiveByDefault(Supplier<? extends Activation.Builder> creator, Activation.Builder builder, Activation target) {
            return builder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Activation.Builder transformActivation_File(Supplier<? extends Activation.Builder> creator, Activation.Builder builder, Activation target) {
            this.stk.push(this.nextFrame("file", Activation::getFile));
            Optional.ofNullable(target.getFile());
            try {
                Activation.Builder builder2 = super.transformActivation_File(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ActivationFile.Builder transformActivationFile_Exists(Supplier<? extends ActivationFile.Builder> creator, ActivationFile.Builder builder, ActivationFile target) {
            this.stk.push(this.nextFrame("exists"));
            try {
                ActivationFile.Builder builder2 = super.transformActivationFile_Exists(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ActivationFile.Builder transformActivationFile_Missing(Supplier<? extends ActivationFile.Builder> creator, ActivationFile.Builder builder, ActivationFile target) {
            this.stk.push(this.nextFrame("missing"));
            try {
                ActivationFile.Builder builder2 = super.transformActivationFile_Missing(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Activation.Builder transformActivation_Jdk(Supplier<? extends Activation.Builder> creator, Activation.Builder builder, Activation target) {
            this.stk.push(this.nextFrame("jdk"));
            try {
                Activation.Builder builder2 = super.transformActivation_Jdk(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Activation.Builder transformActivation_Os(Supplier<? extends Activation.Builder> creator, Activation.Builder builder, Activation target) {
            this.stk.push(this.nextFrame("os", Activation::getOs));
            try {
                Activation.Builder builder2 = super.transformActivation_Os(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ActivationOS.Builder transformActivationOS_Arch(Supplier<? extends ActivationOS.Builder> creator, ActivationOS.Builder builder, ActivationOS target) {
            this.stk.push(this.nextFrame("arch"));
            try {
                ActivationOS.Builder builder2 = super.transformActivationOS_Arch(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ActivationOS.Builder transformActivationOS_Family(Supplier<? extends ActivationOS.Builder> creator, ActivationOS.Builder builder, ActivationOS target) {
            this.stk.push(this.nextFrame("family"));
            try {
                ActivationOS.Builder builder2 = super.transformActivationOS_Family(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ActivationOS.Builder transformActivationOS_Name(Supplier<? extends ActivationOS.Builder> creator, ActivationOS.Builder builder, ActivationOS target) {
            this.stk.push(this.nextFrame("name"));
            try {
                ActivationOS.Builder builder2 = super.transformActivationOS_Name(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ActivationOS.Builder transformActivationOS_Version(Supplier<? extends ActivationOS.Builder> creator, ActivationOS.Builder builder, ActivationOS target) {
            this.stk.push(this.nextFrame("version"));
            try {
                ActivationOS.Builder builder2 = super.transformActivationOS_Version(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Activation.Builder transformActivation_Packaging(Supplier<? extends Activation.Builder> creator, Activation.Builder builder, Activation target) {
            this.stk.push(this.nextFrame("packaging"));
            try {
                Activation.Builder builder2 = super.transformActivation_Packaging(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Activation.Builder transformActivation_Property(Supplier<? extends Activation.Builder> creator, Activation.Builder builder, Activation target) {
            this.stk.push(this.nextFrame("property", Activation::getProperty));
            try {
                Activation.Builder builder2 = super.transformActivation_Property(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ActivationProperty.Builder transformActivationProperty_Name(Supplier<? extends ActivationProperty.Builder> creator, ActivationProperty.Builder builder, ActivationProperty target) {
            this.stk.push(this.nextFrame("name"));
            try {
                ActivationProperty.Builder builder2 = super.transformActivationProperty_Name(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ActivationProperty.Builder transformActivationProperty_Value(Supplier<? extends ActivationProperty.Builder> creator, ActivationProperty.Builder builder, ActivationProperty target) {
            this.stk.push(this.nextFrame("value"));
            try {
                ActivationProperty.Builder builder2 = super.transformActivationProperty_Value(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }
    }

    private record ActivationFrame(String location, Optional<? extends InputLocationTracker> parent) {
    }
}

