/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class Parent implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field artifactId
     */
    private String artifactId;

    /**
     * Field groupId
     */
    private String groupId;

    /**
     * Field version
     */
    private String version;

    /**
     * Field relativePath
     */
    private String relativePath = "../pom.xml";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get The artifact id of the project to extend.
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Get The group id of the project to extend.
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Get The relative path of the parent-pom within the project
     * hierarchy
     */
    public String getRelativePath()
    {
        return this.relativePath;
    } //-- String getRelativePath() 

    /**
     * Get The version of the project to extend.
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Set The artifact id of the project to extend.
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Set The group id of the project to extend.
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Set The relative path of the parent-pom within the project
     * hierarchy
     * 
     * @param relativePath
     */
    public void setRelativePath(String relativePath)
    {
        this.relativePath = relativePath;
    } //-- void setRelativePath(String) 

    /**
     * Set The version of the project to extend.
     * 
     * @param version
     */
    public void setVersion(String version)
    {
        this.version = version;
    } //-- void setVersion(String) 


            public String getId()
            {
                StringBuffer id = new StringBuffer();

                id.append( getGroupId() );
                id.append( ":" );
                id.append( getArtifactId() );
                id.append( ":" );
              //  id.append( getPackaging() );
                id.append( ":" );
                id.append( getVersion() );

                return id.toString();
            }
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
