/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.registry;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.plugin.registry.MavenPluginRegistryBuilder;
import org.apache.maven.plugin.registry.PluginRegistry;
import org.apache.maven.plugin.registry.PluginRegistryUtils;
import org.apache.maven.plugin.registry.RuntimeInfo;
import org.apache.maven.plugin.registry.io.xpp3.PluginRegistryXpp3Reader;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultPluginRegistryBuilder
extends AbstractLogEnabled
implements MavenPluginRegistryBuilder,
Initializable {
    public static final String userHome = System.getProperty("user.home");
    private String userRegistryPath;
    private String globalRegistryPath;
    private File userRegistryFile;
    private File globalRegistryFile;

    public void initialize() {
        this.userRegistryFile = this.getFile(this.userRegistryPath, "user.home", "org.apache.maven.user-plugin-registry");
        this.globalRegistryFile = this.getFile(this.globalRegistryPath, "maven.home", "org.apache.maven.global-plugin-registry");
        this.getLogger().debug("Building Maven global-level settings from: '" + this.globalRegistryFile.getAbsolutePath() + "'");
        this.getLogger().debug("Building Maven user-level settings from: '" + this.userRegistryFile.getAbsolutePath() + "'");
    }

    public PluginRegistry buildPluginRegistry() throws IOException, XmlPullParserException {
        PluginRegistry global = this.readPluginRegistry(this.globalRegistryFile);
        PluginRegistry user = this.readPluginRegistry(this.userRegistryFile);
        if (user == null && global != null) {
            PluginRegistryUtils.recursivelySetSourceLevel(global, "global-level");
            user = global;
        } else {
            PluginRegistryUtils.merge(user, global, "global-level");
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginRegistry readPluginRegistry(File registryFile) throws IOException, XmlPullParserException {
        PluginRegistry registry = null;
        if (registryFile.exists() && registryFile.isFile()) {
            FileReader reader = null;
            try {
                reader = new FileReader(registryFile);
                PluginRegistryXpp3Reader modelReader = new PluginRegistryXpp3Reader();
                registry = modelReader.read(reader);
                RuntimeInfo rtInfo = new RuntimeInfo(registry);
                registry.setRuntimeInfo(rtInfo);
                rtInfo.setFile(registryFile);
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
            IOUtil.close((Reader)reader);
        }
        return registry;
    }

    private File getFile(String pathPattern, String basedirSysProp, String altLocationSysProp) {
        String path = System.getProperty(altLocationSysProp);
        if (StringUtils.isEmpty((String)path)) {
            String basedir = System.getProperty(basedirSysProp);
            basedir = basedir.replaceAll("\\\\", "/");
            basedir = basedir.replaceAll("\\$", "\\\\\\$");
            path = pathPattern.replaceAll("\\$\\{" + basedirSysProp + "\\}", basedir);
            path = path.replaceAll("\\\\", "/");
            path = path.replaceAll("//", "/");
            return new File(path).getAbsoluteFile();
        }
        return new File(path).getAbsoluteFile();
    }

    public PluginRegistry createUserPluginRegistry() {
        PluginRegistry registry = new PluginRegistry();
        RuntimeInfo rtInfo = new RuntimeInfo(registry);
        registry.setRuntimeInfo(rtInfo);
        rtInfo.setFile(this.userRegistryFile);
        return registry;
    }
}

