/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles.activation;

import org.apache.maven.model.Activation;
import org.apache.maven.model.Profile;
import org.apache.maven.profiles.activation.DetectedProfileActivator;
import org.codehaus.plexus.util.StringUtils;

public class JdkPrefixProfileActivator
extends DetectedProfileActivator {
    private static final String JDK_VERSION = System.getProperty("java.version");

    public boolean isActive(Profile profile) {
        Activation activation = profile.getActivation();
        String jdk = activation.getJdk();
        return JDK_VERSION.startsWith(jdk);
    }

    protected boolean canDetectActivation(Profile profile) {
        return profile.getActivation() != null && StringUtils.isNotEmpty((String)profile.getActivation().getJdk());
    }
}

